/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.server.security.enterprise.auth.NeoInteractionLevel;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.NamedFunction;
import org.neo4j.test.rule.concurrent.ThreadingRule;

class ThreadedTransaction<S> {
    private volatile Future<Throwable> done = null;
    private final NeoInteractionLevel<S> neo;
    private final DoubleLatch latch;

    ThreadedTransaction(NeoInteractionLevel<S> neo, DoubleLatch latch) {
        this.neo = neo;
        this.latch = latch;
    }

    String executeCreateNode(ThreadingRule threading, S subject) {
        String query = "CREATE (:Test { name: '" + this.neo.nameOf(subject) + "-node'})";
        return this.execute(threading, subject, query);
    }

    String execute(ThreadingRule threading, S subject, String query) {
        return this.doExecute(threading, subject, KernelTransaction.Type.explicit, false, query)[0];
    }

    String[] execute(ThreadingRule threading, S subject, String ... queries) {
        return this.doExecute(threading, subject, KernelTransaction.Type.explicit, false, queries);
    }

    String executeEarly(ThreadingRule threading, S subject, KernelTransaction.Type txType, String query) {
        return this.doExecute(threading, subject, txType, true, query)[0];
    }

    String[] executeEarly(ThreadingRule threading, S subject, KernelTransaction.Type txType, String ... queries) {
        return this.doExecute(threading, subject, txType, true, queries);
    }

    private String[] doExecute(ThreadingRule threading, S subject, final KernelTransaction.Type txType, final boolean startEarly, final String ... queries) {
        NamedFunction startTransaction = new NamedFunction<S, Throwable>("threaded-transaction-" + Arrays.hashCode(queries)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Throwable apply(S subject) {
                try (InternalTransaction tx = ThreadedTransaction.this.neo.beginLocalTransactionAsUser(subject, txType);){
                    Result result = null;
                    try {
                        if (startEarly) {
                            ThreadedTransaction.this.latch.start();
                        }
                        for (String query : queries) {
                            if (result != null) {
                                result.close();
                            }
                            result = ThreadedTransaction.this.neo.getLocalGraph().execute(query);
                        }
                        if (!startEarly) {
                            ThreadedTransaction.this.latch.startAndWaitForAllToStart();
                        }
                    }
                    finally {
                        if (!startEarly) {
                            ThreadedTransaction.this.latch.start();
                        }
                        ThreadedTransaction.this.latch.finishAndWaitForAllToFinish();
                    }
                    result.close();
                    tx.success();
                    String[] stringArray = null;
                    return stringArray;
                }
                catch (Throwable t) {
                    return t;
                }
            }
        };
        this.done = threading.execute((ThrowingFunction)startTransaction, subject);
        return queries;
    }

    void closeAndAssertSuccess() throws Throwable {
        Throwable exceptionInOtherThread = this.join();
        if (exceptionInOtherThread != null) {
            throw new AssertionError("Expected no exception in ThreadCreate, but got one.", exceptionInOtherThread);
        }
    }

    void closeAndAssertExplicitTermination() throws Throwable {
        Throwable exceptionInOtherThread = this.join();
        if (exceptionInOtherThread == null) {
            TestCase.fail((String)"Expected explicit TransactionTerminatedException in the threaded transaction, but no exception was raised");
        }
        MatcherAssert.assertThat((String)Exceptions.stringify((Throwable)exceptionInOtherThread), (Object)exceptionInOtherThread.getMessage(), (Matcher)Matchers.containsString((String)"Explicitly terminated by the user."));
    }

    void closeAndAssertSomeTermination() throws Throwable {
        Throwable exceptionInOtherThread = this.join();
        if (exceptionInOtherThread == null) {
            TestCase.fail((String)"Expected a TransactionTerminatedException in the threaded transaction, but no exception was raised");
        }
        MatcherAssert.assertThat((String)Exceptions.stringify((Throwable)exceptionInOtherThread), (Object)exceptionInOtherThread, (Matcher)Matchers.instanceOf(TransactionTerminatedException.class));
    }

    private Throwable join() throws ExecutionException, InterruptedException {
        return this.done.get();
    }
}

