/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.server.security.enterprise.auth.NeoInteractionLevel;
import org.neo4j.test.Barrier;
import org.neo4j.test.NamedFunction;
import org.neo4j.test.rule.concurrent.ThreadingRule;

public class ThreadedTransactionPeriodicCommit<S> {
    final Barrier.Control barrier = new Barrier.Control();
    private Future<String> loadCsvResult;
    private Future<Throwable> servCsvResult;
    int csvHttpPort = 8089;
    NeoInteractionLevel<S> neo;

    ThreadedTransactionPeriodicCommit(NeoInteractionLevel<S> neo) {
        this.neo = neo;
    }

    void execute(ThreadingRule threading, S subject, int nLines) {
        NamedFunction<Integer, Throwable> servCsv = new NamedFunction<Integer, Throwable>("serv-csv"){

            public Throwable apply(Integer n) throws RuntimeException {
                try {
                    ServerSocket serverSocket = new ServerSocket(ThreadedTransactionPeriodicCommit.this.csvHttpPort);
                    Socket clientSocket = serverSocket.accept();
                    PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
                    out.print("HTTP/1.1 200 \r\n");
                    out.print("Content-Type: text/plain\r\n");
                    out.print("Connection: close\r\n");
                    out.print("\r\n");
                    for (int i = 0; i < n - 1; ++i) {
                        out.print("line " + i + "\r\n");
                    }
                    out.flush();
                    ThreadedTransactionPeriodicCommit.this.barrier.reached();
                    out.print("line " + (n - 1) + "\r\n");
                    out.close();
                    clientSocket.close();
                    serverSocket.close();
                    return null;
                }
                catch (Throwable t) {
                    return t;
                }
            }
        };
        NamedFunction loadCsv = new NamedFunction<S, String>("load-csv"){

            public String apply(S subject) {
                try {
                    return ThreadedTransactionPeriodicCommit.this.neo.executeQuery(subject, "USING PERIODIC COMMIT 1 LOAD CSV FROM 'http://localhost:" + ThreadedTransactionPeriodicCommit.this.csvHttpPort + "/file.csv' AS line CREATE (l:Line {name: line[0]}) RETURN line[0] as name", null, r -> {});
                }
                catch (Throwable t) {
                    return t.getMessage();
                }
            }
        };
        this.servCsvResult = threading.execute((ThrowingFunction)servCsv, (Object)nLines);
        this.loadCsvResult = threading.execute((ThrowingFunction)loadCsv, subject);
    }

    void closeAndAssertSuccess() throws Throwable {
        String exceptionMsgInOtherThread = this.join();
        if (exceptionMsgInOtherThread != "") {
            TestCase.fail((String)("Expected no exception in ThreadedCreate, got '" + exceptionMsgInOtherThread + "'"));
        }
    }

    void closeAndAssertError(String errMsg) throws Throwable {
        String exceptionMsgInOtherThread = this.join();
        MatcherAssert.assertThat((Object)exceptionMsgInOtherThread, (Matcher)IsEqual.equalTo((Object)errMsg));
    }

    private String join() throws ExecutionException, InterruptedException {
        this.barrier.release();
        this.servCsvResult.get();
        return this.loadCsvResult.get();
    }
}

