/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth;

import java.io.IOException;
import org.apache.shiro.mgt.SecurityManager;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.api.security.AuthenticationResult;
import org.neo4j.kernel.api.security.PasswordPolicy;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.enterprise.api.security.EnterpriseSecurityContext;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.BasicPasswordPolicy;
import org.neo4j.server.security.auth.InMemoryUserRepository;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.enterprise.auth.EnterpriseUserManager;
import org.neo4j.server.security.enterprise.auth.InMemoryRoleRepository;
import org.neo4j.server.security.enterprise.auth.InternalFlatFileRealm;
import org.neo4j.server.security.enterprise.auth.PersonalUserManager;
import org.neo4j.server.security.enterprise.auth.RoleRepository;
import org.neo4j.server.security.enterprise.auth.ShiroSubject;
import org.neo4j.server.security.enterprise.auth.StandardEnterpriseSecurityContext;
import org.neo4j.server.security.enterprise.auth.UserManagementProcedures;
import org.neo4j.server.security.enterprise.log.SecurityLog;
import org.neo4j.test.assertion.Assert;

public class UserManagementProceduresLoggingTest {
    private TestUserManagementProcedures authProcedures;
    private AssertableLogProvider log = null;
    private EnterpriseSecurityContext matsContext = null;
    private EnterpriseUserManager generalUserManager;

    @Before
    public void setUp() throws Throwable {
        this.log = new AssertableLogProvider();
        SecurityLog securityLog = new SecurityLog(this.log.getLog(this.getClass()));
        this.authProcedures = new TestUserManagementProcedures();
        this.authProcedures.graph = (GraphDatabaseAPI)Mockito.mock(GraphDatabaseAPI.class);
        this.authProcedures.securityLog = securityLog;
        this.generalUserManager = this.getUserManager();
        TestSecurityContext adminContext = new TestSecurityContext("admin", true, this.generalUserManager);
        this.matsContext = new TestSecurityContext("mats", false, this.generalUserManager);
        this.setSubject((EnterpriseSecurityContext)adminContext);
    }

    private void setSubject(EnterpriseSecurityContext securityContext) {
        this.authProcedures.securityContext = securityContext;
        this.authProcedures.userManager = new PersonalUserManager(this.generalUserManager, (SecurityContext)securityContext, this.authProcedures.securityLog);
    }

    private EnterpriseUserManager getUserManager() throws Throwable {
        InternalFlatFileRealm realm = new InternalFlatFileRealm((UserRepository)new InMemoryUserRepository(), (RoleRepository)new InMemoryRoleRepository(), (PasswordPolicy)new BasicPasswordPolicy(), (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class), (JobScheduler)Mockito.mock(JobScheduler.class), (UserRepository)new InMemoryUserRepository(), (UserRepository)new InMemoryUserRepository());
        realm.start();
        return realm;
    }

    @Test
    public void shouldLogCreatingUser() throws Throwable {
        this.authProcedures.createUser("andres", "el password", true);
        this.authProcedures.createUser("mats", "el password", false);
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.info("[admin]: created user `%s`%s", "andres", ", with password change required"), this.info("[admin]: created user `%s`%s", "mats", "")});
    }

    @Test
    public void shouldLogFailureToCreateUser() throws Throwable {
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.createUser(null, "pw", true)));
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.createUser("", "pw", true)));
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.createUser("andres", "", true)));
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.createUser("mats", null, true)));
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.createUser("neo4j", "nonEmpty", true)));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[admin]: tried to create user `%s`: %s", null, "The provided username is empty."), this.error("[admin]: tried to create user `%s`: %s", "", "The provided username is empty."), this.error("[admin]: tried to create user `%s`: %s", "andres", "A password cannot be empty."), this.error("[admin]: tried to create user `%s`: %s", "mats", "A password cannot be empty."), this.error("[admin]: tried to create user `%s`: %s", "neo4j", "The specified user 'neo4j' already exists.")});
    }

    @Test
    public void shouldLogUnauthorizedCreatingUser() throws Throwable {
        this.setSubject(this.matsContext);
        this.catchAuthorizationViolation((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.createUser("andres", "", true)));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[mats]: tried to create user `%s`: %s", "andres", "Permission denied.")});
    }

    @Test
    public void shouldLogDeletingUser() throws Throwable {
        this.authProcedures.createUser("andres", "el password", false);
        this.authProcedures.deleteUser("andres");
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.info("[admin]: created user `%s`%s", "andres", ""), this.info("[admin]: deleted user `%s`", "andres")});
    }

    @Test
    public void shouldLogDeletingNonExistentUser() throws Throwable {
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.deleteUser("andres")));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[admin]: tried to delete user `%s`: %s", "andres", "User 'andres' does not exist.")});
    }

    @Test
    public void shouldLogUnauthorizedDeleteUser() throws Throwable {
        this.setSubject(this.matsContext);
        this.catchAuthorizationViolation((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.deleteUser("admin")));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[mats]: tried to delete user `%s`: %s", "admin", "Permission denied.")});
    }

    @Test
    public void shouldLogAddingRoleToUser() throws Throwable {
        this.authProcedures.createUser("mats", "neo4j", false);
        this.authProcedures.addRoleToUser("architect", "mats");
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.info("[admin]: created user `%s`%s", "mats", ""), this.info("[admin]: added role `%s` to user `%s`", "architect", "mats")});
    }

    @Test
    public void shouldLogFailureToAddRoleToUser() throws Throwable {
        this.authProcedures.createUser("mats", "neo4j", false);
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.addRoleToUser("null", "mats")));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.info("[admin]: created user `%s`%s", "mats", ""), this.error("[admin]: tried to add role `%s` to user `%s`: %s", "null", "mats", "Role 'null' does not exist.")});
    }

    @Test
    public void shouldLogUnauthorizedAddingRole() throws Throwable {
        this.setSubject(this.matsContext);
        this.catchAuthorizationViolation((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.addRoleToUser("admin", "mats")));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[mats]: tried to add role `%s` to user `%s`: %s", "admin", "mats", "Permission denied.")});
    }

    @Test
    public void shouldLogRemovalOfRoleFromUser() throws Throwable {
        this.authProcedures.createUser("mats", "neo4j", false);
        this.authProcedures.addRoleToUser("reader", "mats");
        this.log.clear();
        this.authProcedures.removeRoleFromUser("reader", "mats");
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.info("[admin]: removed role `%s` from user `%s`", "reader", "mats")});
    }

    @Test
    public void shouldLogFailureToRemoveRoleFromUser() throws Throwable {
        this.authProcedures.createUser("mats", "neo4j", false);
        this.authProcedures.addRoleToUser("reader", "mats");
        this.log.clear();
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.removeRoleFromUser("notReader", "mats")));
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.removeRoleFromUser("reader", "notMats")));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[admin]: tried to remove role `%s` from user `%s`: %s", "notReader", "mats", "Role 'notReader' does not exist."), this.error("[admin]: tried to remove role `%s` from user `%s`: %s", "reader", "notMats", "User 'notMats' does not exist.")});
    }

    @Test
    public void shouldLogUnauthorizedRemovingRole() throws Throwable {
        this.setSubject(this.matsContext);
        this.catchAuthorizationViolation((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.removeRoleFromUser("admin", "admin")));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[mats]: tried to remove role `%s` from user `%s`: %s", "admin", "admin", "Permission denied.")});
    }

    @Test
    public void shouldLogUserPasswordChanges() throws IOException, InvalidArgumentsException {
        this.authProcedures.createUser("mats", "neo4j", true);
        this.log.clear();
        this.authProcedures.changeUserPassword("mats", "longPassword", false);
        this.authProcedures.changeUserPassword("mats", "longerPassword", true);
        this.setSubject(this.matsContext);
        this.authProcedures.changeUserPassword("mats", "evenLongerPassword", false);
        this.authProcedures.changePassword("superLongPassword", false);
        this.authProcedures.changePassword("infinitePassword", true);
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.info("[admin]: changed password for user `%s`%s", "mats", ""), this.info("[admin]: changed password for user `%s`%s", "mats", ", with password change required"), this.info("[mats]: changed password%s", ""), this.info("[mats]: changed password%s", ""), this.info("[mats]: changed password%s", ", with password change required")});
    }

    @Test
    public void shouldLogFailureToChangeUserPassword() throws Throwable {
        this.authProcedures.createUser("andres", "neo4j", true);
        this.log.clear();
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.changeUserPassword("andres", "neo4j", false)));
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.changeUserPassword("andres", "", false)));
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.changeUserPassword("notAndres", "good password", false)));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[admin]: tried to change password for user `%s`: %s", "andres", "Old password and new password cannot be the same."), this.error("[admin]: tried to change password for user `%s`: %s", "andres", "A password cannot be empty."), this.error("[admin]: tried to change password for user `%s`: %s", "notAndres", "User 'notAndres' does not exist.")});
    }

    @Test
    public void shouldLogFailureToChangeOwnPassword() throws Throwable {
        this.authProcedures.createUser("mats", "neo4j", true);
        this.setSubject(this.matsContext);
        this.log.clear();
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.changeUserPassword("mats", "neo4j", false)));
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.changeUserPassword("mats", "", false)));
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.changePassword(null, false)));
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.changePassword("", false)));
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.changePassword("neo4j", false)));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[mats]: tried to change password: %s", "Old password and new password cannot be the same."), this.error("[mats]: tried to change password: %s", "A password cannot be empty."), this.error("[mats]: tried to change password: %s", "A password cannot be empty."), this.error("[mats]: tried to change password: %s", "A password cannot be empty."), this.error("[mats]: tried to change password: %s", "Old password and new password cannot be the same.")});
    }

    @Test
    public void shouldLogUnauthorizedChangePassword() throws Throwable {
        this.authProcedures.createUser("andres", "neo4j", true);
        this.log.clear();
        this.setSubject(this.matsContext);
        this.catchAuthorizationViolation((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.changeUserPassword("andres", "otherPw", false)));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[mats]: tried to change password for user `%s`: %s", "andres", "Permission denied.")});
    }

    @Test
    public void shouldLogSuspendUser() throws Throwable {
        this.authProcedures.createUser("mats", "neo4j", false);
        this.log.clear();
        this.authProcedures.suspendUser("mats");
        this.authProcedures.suspendUser("mats");
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.info("[admin]: suspended user `%s`", "mats"), this.info("[admin]: suspended user `%s`", "mats")});
    }

    @Test
    public void shouldLogFailureToSuspendUser() throws Throwable {
        this.authProcedures.createUser("mats", "neo4j", false);
        this.log.clear();
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.suspendUser("notMats")));
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.suspendUser("admin")));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[admin]: tried to suspend user `%s`: %s", "notMats", "User 'notMats' does not exist."), this.error("[admin]: tried to suspend user `%s`: %s", "admin", "Suspending yourself (user 'admin') is not allowed.")});
    }

    @Test
    public void shouldLogUnauthorizedSuspendUser() throws Throwable {
        this.setSubject(this.matsContext);
        this.catchAuthorizationViolation((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.suspendUser("admin")));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[mats]: tried to suspend user `%s`: %s", "admin", "Permission denied.")});
    }

    @Test
    public void shouldLogActivateUser() throws Throwable {
        this.authProcedures.createUser("mats", "neo4j", false);
        this.authProcedures.suspendUser("mats");
        this.log.clear();
        this.authProcedures.activateUser("mats", false);
        this.authProcedures.activateUser("mats", false);
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.info("[admin]: activated user `%s`", "mats"), this.info("[admin]: activated user `%s`", "mats")});
    }

    @Test
    public void shouldLogFailureToActivateUser() throws Throwable {
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.activateUser("notMats", false)));
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.activateUser("admin", false)));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[admin]: tried to activate user `%s`: %s", "notMats", "User 'notMats' does not exist."), this.error("[admin]: tried to activate user `%s`: %s", "admin", "Activating yourself (user 'admin') is not allowed.")});
    }

    @Test
    public void shouldLogUnauthorizedActivateUser() throws Throwable {
        this.setSubject(this.matsContext);
        this.catchAuthorizationViolation((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.activateUser("admin", true)));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[mats]: tried to activate user `%s`: %s", "admin", "Permission denied.")});
    }

    @Test
    public void shouldLogCreatingRole() throws Throwable {
        this.authProcedures.createRole("role");
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.info("[admin]: created role `%s`", "role")});
    }

    @Test
    public void shouldLogFailureToCreateRole() throws Throwable {
        this.authProcedures.createRole("role");
        this.log.clear();
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.createRole(null)));
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.createRole("")));
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.createRole("role")));
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.createRole("!@#$")));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[admin]: tried to create role `%s`: %s", null, "The provided role name is empty."), this.error("[admin]: tried to create role `%s`: %s", "", "The provided role name is empty."), this.error("[admin]: tried to create role `%s`: %s", "role", "The specified role 'role' already exists."), this.error("[admin]: tried to create role `%s`: %s", "!@#$", "Role name '!@#$' contains illegal characters. Use simple ascii characters and numbers.")});
    }

    @Test
    public void shouldLogUnauthorizedCreateRole() throws Exception {
        this.setSubject(this.matsContext);
        this.catchAuthorizationViolation((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.createRole("role")));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[mats]: tried to create role `%s`: %s", "role", "Permission denied.")});
    }

    @Test
    public void shouldLogDeletingRole() throws Exception {
        this.authProcedures.createRole("foo");
        this.log.clear();
        this.authProcedures.deleteRole("foo");
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.info("[admin]: deleted role `%s`", "foo")});
    }

    @Test
    public void shouldLogFailureToDeleteRole() throws Exception {
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.deleteRole(null)));
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.deleteRole("")));
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.deleteRole("foo")));
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.deleteRole("admin")));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[admin]: tried to delete role `%s`: %s", null, "Role 'null' does not exist."), this.error("[admin]: tried to delete role `%s`: %s", "", "Role '' does not exist."), this.error("[admin]: tried to delete role `%s`: %s", "foo", "Role 'foo' does not exist."), this.error("[admin]: tried to delete role `%s`: %s", "admin", "'admin' is a predefined role and can not be deleted.")});
    }

    @Test
    public void shouldLogUnauthorizedDeletingRole() throws Exception {
        this.setSubject(this.matsContext);
        this.catchAuthorizationViolation((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.deleteRole("admin")));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[mats]: tried to delete role `%s`: %s", "admin", "Permission denied.")});
    }

    @Test
    public void shouldLogIfUnexpectedErrorTerminatingTransactions() throws Exception {
        this.authProcedures.createUser("johan", "neo4j", false);
        this.authProcedures.failTerminateTransaction();
        this.log.clear();
        Assert.assertException(() -> this.authProcedures.deleteUser("johan"), RuntimeException.class, (String)"Unexpected error");
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.info("[admin]: deleted user `%s`", "johan"), this.error("[admin]: failed to terminate running transaction and bolt connections for user `%s` following %s: %s", "johan", "deletion", "Unexpected error")});
    }

    @Test
    public void shouldLogUnauthorizedListUsers() throws Exception {
        this.setSubject(this.matsContext);
        this.catchAuthorizationViolation((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.listUsers()));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[mats]: tried to list users: %s", "Permission denied.")});
    }

    @Test
    public void shouldLogUnauthorizedListRoles() throws Exception {
        this.setSubject(this.matsContext);
        this.catchAuthorizationViolation((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.listRoles()));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[mats]: tried to list roles: %s", "Permission denied.")});
    }

    @Test
    public void shouldLogFailureToListRolesForUser() throws Exception {
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.listRolesForUser(null)));
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.listRolesForUser("")));
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.listRolesForUser("nonExistent")));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[admin]: tried to list roles for user `%s`: %s", null, "User 'null' does not exist."), this.error("[admin]: tried to list roles for user `%s`: %s", "", "User '' does not exist."), this.error("[admin]: tried to list roles for user `%s`: %s", "nonExistent", "User 'nonExistent' does not exist.")});
    }

    @Test
    public void shouldLogUnauthorizedListRolesForUser() throws Exception {
        this.setSubject(this.matsContext);
        this.catchAuthorizationViolation((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.listRolesForUser("user")));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[mats]: tried to list roles for user `%s`: %s", "user", "Permission denied.")});
    }

    @Test
    public void shouldLogFailureToListUsersForRole() throws Exception {
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.listUsersForRole(null)));
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.listUsersForRole("")));
        this.catchInvalidArguments((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.listUsersForRole("nonExistent")));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[admin]: tried to list users for role `%s`: %s", null, "Role 'null' does not exist."), this.error("[admin]: tried to list users for role `%s`: %s", "", "Role '' does not exist."), this.error("[admin]: tried to list users for role `%s`: %s", "nonExistent", "Role 'nonExistent' does not exist.")});
    }

    @Test
    public void shouldLogUnauthorizedListUsersForRole() throws Exception {
        this.setSubject(this.matsContext);
        this.catchAuthorizationViolation((ThrowingAction<Exception>)((ThrowingAction)() -> this.authProcedures.listUsersForRole("role")));
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{this.error("[mats]: tried to list users for role `%s`: %s", "role", "Permission denied.")});
    }

    private void catchInvalidArguments(ThrowingAction<Exception> f) throws Exception {
        Assert.assertException(f, InvalidArgumentsException.class);
    }

    private void catchAuthorizationViolation(ThrowingAction<Exception> f) throws Exception {
        Assert.assertException(f, AuthorizationViolationException.class);
    }

    private AssertableLogProvider.LogMatcher info(String message, String ... arguments) {
        if (arguments.length == 0) {
            return AssertableLogProvider.inLog(this.getClass()).info(message);
        }
        return AssertableLogProvider.inLog(this.getClass()).info(message, (Object[])arguments);
    }

    private AssertableLogProvider.LogMatcher error(String message, String ... arguments) {
        return AssertableLogProvider.inLog(this.getClass()).error(message, (Object[])arguments);
    }

    private static class TestUserManagementProcedures
    extends UserManagementProcedures {
        private boolean failTerminateTransactions = false;

        private TestUserManagementProcedures() {
        }

        void failTerminateTransaction() {
            this.failTerminateTransactions = true;
        }

        protected void terminateTransactionsForValidUser(String username) {
            if (this.failTerminateTransactions) {
                throw new RuntimeException("Unexpected error");
            }
        }

        protected void terminateConnectionsForValidUser(String username) {
        }
    }

    private static class TestShiroSubject
    extends ShiroSubject {
        private final String name;

        TestShiroSubject(String name) {
            super((SecurityManager)Mockito.mock(SecurityManager.class), AuthenticationResult.SUCCESS);
            this.name = name;
        }

        public Object getPrincipal() {
            return this.name;
        }
    }

    private static class TestSecurityContext
    extends StandardEnterpriseSecurityContext {
        private final String name;
        private final boolean isAdmin;
        private final EnterpriseUserManager userManager;

        TestSecurityContext(String name, boolean isAdmin, EnterpriseUserManager userManager) {
            super(null, (ShiroSubject)new TestShiroSubject(name));
            this.name = name;
            this.isAdmin = isAdmin;
            this.userManager = userManager;
        }

        public boolean isAdmin() {
            return this.isAdmin;
        }

        public EnterpriseUserManager getUserManager() {
            return this.userManager;
        }
    }
}

