/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth.integration.bolt;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.bolt.v1.messaging.message.InitMessage;
import org.neo4j.bolt.v1.messaging.message.PullAllMessage;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;
import org.neo4j.bolt.v1.messaging.message.RunMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.transport.integration.Neo4jWithSocket;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.bolt.v1.transport.socket.client.SecureSocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.TransportConnection;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.security.enterprise.configuration.SecuritySettings;
import org.neo4j.test.TestEnterpriseGraphDatabaseFactory;
import org.neo4j.test.TestGraphDatabaseFactory;

@Ignore
public class ActiveDirectoryAuthenticationIT {
    @Rule
    public Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), this.getTestGraphDatabaseFactory(), this.asSettings(this.getSettingsFunction()));
    private Consumer<Map<Setting<?>, String>> useSystemAccountSettings = settings -> {
        settings.put(SecuritySettings.ldap_authorization_use_system_account, "true");
        settings.put(SecuritySettings.ldap_authorization_system_username, "Neo4j System");
        settings.put(SecuritySettings.ldap_authorization_system_password, "ProudListingsMedia1");
    };
    public Factory<TransportConnection> cf = SecureSocketConnection::new;
    public HostnamePort address = new HostnamePort("localhost:7687");
    protected TransportConnection client;

    private void restartNeo4jServerWithOverriddenSettings(Consumer<Map<Setting<?>, String>> overrideSettingsFunction) throws IOException {
        this.server.shutdownDatabase();
        this.server.ensureDatabase(this.asSettings(overrideSettingsFunction));
    }

    private Consumer<Map<String, String>> asSettings(Consumer<Map<Setting<?>, String>> overrideSettingsFunction) {
        return settings -> {
            LinkedHashMap o = new LinkedHashMap();
            overrideSettingsFunction.accept(o);
            for (Setting key : o.keySet()) {
                settings.put(key.name(), o.get(key));
            }
        };
    }

    protected TestGraphDatabaseFactory getTestGraphDatabaseFactory() {
        return new TestEnterpriseGraphDatabaseFactory();
    }

    protected Consumer<Map<Setting<?>, String>> getSettingsFunction() {
        return settings -> {
            settings.put(GraphDatabaseSettings.auth_enabled, "true");
            settings.put(SecuritySettings.auth_provider, "ldap");
            settings.put(SecuritySettings.ldap_server, "activedirectory.neohq.net");
            settings.put(SecuritySettings.ldap_authentication_user_dn_template, "CN={0},CN=Users,DC=neo4j,DC=com");
            settings.put(SecuritySettings.ldap_authorization_use_system_account, "false");
            settings.put(SecuritySettings.ldap_authorization_user_search_base, "cn=Users,dc=neo4j,dc=com");
            settings.put(SecuritySettings.ldap_authorization_user_search_filter, "(&(objectClass=*)(CN={0}))");
            settings.put(SecuritySettings.ldap_authorization_group_membership_attribute_names, "memberOf");
            settings.put(SecuritySettings.ldap_authorization_group_to_role_mapping, "'CN=Neo4j Read Only,CN=Users,DC=neo4j,DC=com'=reader;CN=Neo4j Read-Write,CN=Users,DC=neo4j,DC=com=publisher;CN=Neo4j Schema Manager,CN=Users,DC=neo4j,DC=com=architect;CN=Neo4j Administrator,CN=Users,DC=neo4j,DC=com=admin");
        };
    }

    @Test
    public void shouldNotBeAbleToLoginUnknownUserOnEC2() throws Throwable {
        this.assertAuthFail("unknown", "ProudListingsMedia1");
    }

    @Test
    public void shouldBeAbleToLoginAndAuthorizeReaderWithUserLdapContextOnEC2() throws Throwable {
        this.assertAuth("neo", "ProudListingsMedia1");
        this.assertReadSucceeds();
        this.assertWriteFails("'neo' with roles [reader]");
    }

    @Test
    public void shouldBeAbleToLoginAndAuthorizeReaderOnEC2() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(this.useSystemAccountSettings);
        this.assertAuth("neo", "ProudListingsMedia1");
        this.assertReadSucceeds();
        this.assertWriteFails("'neo' with roles [reader]");
    }

    @Test
    public void shouldBeAbleToLoginAndAuthorizePublisherWithUserLdapContextOnEC2() throws Throwable {
        this.assertAuth("tank", "ProudListingsMedia1");
        this.assertWriteSucceeds();
    }

    @Test
    public void shouldBeAbleToLoginAndAuthorizePublisherOnEC2() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(this.useSystemAccountSettings);
        this.assertAuth("tank", "ProudListingsMedia1");
        this.assertWriteSucceeds();
    }

    @Test
    public void shouldBeAbleToLoginAndAuthorizeNoPermissionUserWithUserLdapContextOnEC2() throws Throwable {
        this.assertAuth("smith", "ProudListingsMedia1");
        this.assertReadFails("'smith' with no roles");
    }

    @Test
    public void shouldBeAbleToLoginAndAuthorizeNoPermissionUserOnEC2() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(this.useSystemAccountSettings);
        this.assertAuth("smith", "ProudListingsMedia1");
        this.assertReadFails("'smith' with no roles");
    }

    @Test
    public void shouldBeAbleToLoginAndAuthorizeReaderUsingLdapsOnEC2() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(this.useSystemAccountSettings.andThen(settings -> settings.put(SecuritySettings.ldap_server, "ldaps://activedirectory.neohq.net:636")));
        this.assertAuth("neo", "ProudListingsMedia1");
        this.assertReadSucceeds();
        this.assertWriteFails("'neo' with roles [reader]");
    }

    @Test
    public void shouldBeAbleToLoginAndAuthorizeReaderWithUserLdapContextUsingLDAPSOnEC2() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(settings -> settings.put(SecuritySettings.ldap_server, "ldaps://activedirectory.neohq.net:636"));
        this.assertAuth("neo", "ProudListingsMedia1");
        this.assertReadSucceeds();
        this.assertWriteFails("'neo' with roles [reader]");
    }

    @Test
    public void shouldBeAbleToLoginAndAuthorizeReaderUsingStartTlsOnEC2() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(this.useSystemAccountSettings.andThen(settings -> settings.put(SecuritySettings.ldap_use_starttls, "true")));
        this.assertAuth("neo", "ProudListingsMedia1");
        this.assertReadSucceeds();
        this.assertWriteFails("'neo' with roles [reader]");
    }

    @Test
    public void shouldBeAbleToLoginAndAuthorizeReaderWithUserLdapContextUsingStartTlsOnEC2() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(settings -> settings.put(SecuritySettings.ldap_use_starttls, "true"));
        this.assertAuth("neo", "ProudListingsMedia1");
        this.assertReadSucceeds();
        this.assertWriteFails("'neo' with roles [reader]");
    }

    @Test
    public void shouldBeAbleToAccessEC2ActiveDirectoryInstance() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(settings -> {});
        this.assertAuth("tank", "ProudListingsMedia1");
        this.assertReadSucceeds();
        this.assertWriteSucceeds();
    }

    @Before
    public void setup() {
        this.client = (TransportConnection)this.cf.newInstance();
    }

    @After
    public void teardown() throws Exception {
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    private void assertAuth(String username, String password) throws Exception {
        this.assertAuth(username, password, null);
    }

    private void assertAuth(String username, String password, String realm) throws Exception {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions((long)1L, (long)0L, (long)0L, (long)0L)).send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", this.authToken(username, password, realm))}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess()}));
    }

    private Map<String, Object> authToken(String username, String password, String realm) {
        if (realm != null && realm.length() > 0) {
            return MapUtil.map((Object[])new Object[]{"principal", username, "credentials", password, "scheme", "basic", "realm", realm});
        }
        return MapUtil.map((Object[])new Object[]{"principal", username, "credentials", password, "scheme", "basic"});
    }

    private void assertAuthFail(String username, String password) throws Exception {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions((long)1L, (long)0L, (long)0L, (long)0L)).send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)MapUtil.map((Object[])new Object[]{"principal", username, "credentials", password, "scheme", "basic"}))}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, (String)"The client is unauthorized due to authentication failure.")}));
    }

    protected void assertReadSucceeds() throws Exception {
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"MATCH (n) RETURN n"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
    }

    protected void assertReadFails(String username) throws Exception {
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"MATCH (n) RETURN n"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.Forbidden, (String)String.format("Read operations are not allowed for user %s.", username))}));
    }

    protected void assertWriteSucceeds() throws Exception {
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"CREATE ()"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
    }

    protected void assertWriteFails(String username) throws Exception {
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"CREATE ()"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.Forbidden, (String)String.format("Write operations are not allowed for user %s.", username))}));
    }
}

