/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth.integration.bolt;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.runners.Parameterized;
import org.neo4j.bolt.v1.messaging.message.InitMessage;
import org.neo4j.bolt.v1.messaging.message.PullAllMessage;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;
import org.neo4j.bolt.v1.messaging.message.ResetMessage;
import org.neo4j.bolt.v1.messaging.message.RunMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.runtime.spi.ImmutableRecord;
import org.neo4j.bolt.v1.runtime.spi.Record;
import org.neo4j.bolt.v1.transport.integration.Neo4jWithSocket;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.bolt.v1.transport.socket.client.SecureSocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.SecureWebSocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.SocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.TransportConnection;
import org.neo4j.bolt.v1.transport.socket.client.WebSocketConnection;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.test.TestEnterpriseGraphDatabaseFactory;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.concurrent.ThreadingRule;

public class BoltConnectionManagementIT {
    @Rule
    public Neo4jWithSocket server = new Neo4jWithSocket(this.getClass(), this.getTestGraphDatabaseFactory(), this.getSettingsFunction());
    @Rule
    public final ThreadingRule threading = new ThreadingRule();
    @Parameterized.Parameter(value=0)
    public Factory<TransportConnection> cf;
    @Parameterized.Parameter(value=1)
    public HostnamePort address;
    protected TransportConnection admin;
    protected TransportConnection user;

    @Before
    public void setup() throws Exception {
        this.admin = (TransportConnection)this.cf.newInstance();
        this.user = (TransportConnection)this.cf.newInstance();
        this.authenticate(this.admin, "neo4j", "neo4j", "123");
        BoltConnectionManagementIT.createNewUser(this.admin, "Igor", "123");
    }

    @After
    public void teardown() throws Exception {
        if (this.admin != null) {
            this.admin.disconnect();
        }
        if (this.user != null) {
            this.user.disconnect();
        }
    }

    protected TestGraphDatabaseFactory getTestGraphDatabaseFactory() {
        return new TestEnterpriseGraphDatabaseFactory();
    }

    protected Consumer<Map<String, String>> getSettingsFunction() {
        return settings -> settings.put(GraphDatabaseSettings.auth_enabled.name(), "true");
    }

    @Parameterized.Parameters
    public static Collection<Object[]> transports() {
        return Arrays.asList({SocketConnection::new, new HostnamePort("localhost:7687")}, {WebSocketConnection::new, new HostnamePort("localhost:7687")}, {SecureSocketConnection::new, new HostnamePort("localhost:7687")}, {SecureWebSocketConnection::new, new HostnamePort("localhost:7687")});
    }

    public void shouldListOwnConnection() throws Throwable {
        this.admin.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"CALL dbms.listConnections() YIELD username, connectionCount"), PullAllMessage.pullAll()}));
        Map<String, Long> result = BoltConnectionManagementIT.collectConnectionResult(this.admin, 1);
        Assert.assertTrue((boolean)result.containsKey("neo4j"));
        Assert.assertTrue((result.get("neo4j") == 1L ? 1 : 0) != 0);
    }

    public void shouldListAllConnections() throws Throwable {
        this.authenticate(this.user, "Igor", "123", null);
        this.admin.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"CALL dbms.listConnections() YIELD username, connectionCount"), PullAllMessage.pullAll()}));
        Map<String, Long> result = BoltConnectionManagementIT.collectConnectionResult(this.admin, 2);
        Assert.assertTrue((boolean)result.containsKey("neo4j"));
        Assert.assertTrue((result.get("neo4j") == 1L ? 1 : 0) != 0);
        Assert.assertTrue((boolean)result.containsKey("Igor"));
        Assert.assertTrue((result.get("Igor") == 1L ? 1 : 0) != 0);
    }

    public void shouldNotListConnectionsIfNotAdmin() throws Throwable {
        this.authenticate(this.user, "Igor", "123", null);
        this.user.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"CALL dbms.listConnections() YIELD username, connectionCount"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.user, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.Forbidden, (String)"Permission denied.")}));
    }

    public void shouldTerminateConnectionForUser() throws Throwable {
        this.authenticate(this.user, "Igor", "123", null);
        this.admin.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"CALL dbms.terminateConnectionsForUser( 'Igor' ) YIELD username, connectionCount"), PullAllMessage.pullAll()}));
        Map<String, Long> terminationResult = BoltConnectionManagementIT.collectConnectionResult(this.admin, 1);
        Assert.assertTrue((boolean)terminationResult.containsKey("Igor"));
        Assert.assertTrue((terminationResult.get("Igor") == 1L ? 1 : 0) != 0);
        this.admin.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"CALL dbms.listConnections() YIELD username, connectionCount"), PullAllMessage.pullAll()}));
        Map<String, Long> listResult = BoltConnectionManagementIT.collectConnectionResult(this.admin, 1);
        Assert.assertTrue((boolean)listResult.containsKey("neo4j"));
        Assert.assertTrue((listResult.get("neo4j") == 1L ? 1 : 0) != 0);
        BoltConnectionManagementIT.verifyConnectionHasTerminated(this.user);
    }

    public void shouldNotFailWhenTerminatingConnectionsForUserWithNoConnections() throws Throwable {
        this.admin.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"CALL dbms.terminateConnectionsForUser( 'Igor' ) YIELD username, connectionCount"), PullAllMessage.pullAll()}));
        Map<String, Long> terminationResult = BoltConnectionManagementIT.collectConnectionResult(this.admin, 1);
        Assert.assertTrue((boolean)terminationResult.containsKey("Igor"));
        Assert.assertTrue((terminationResult.get("Igor") == 0L ? 1 : 0) != 0);
    }

    public void shouldFailWhenTerminatingConnectionsForNonExistentUser() throws Throwable {
        this.admin.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"CALL dbms.terminateConnectionsForUser( 'NonExistentUser' ) YIELD username, connectionCount"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.admin, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgFailure((Status)Status.General.InvalidArguments, (String)"User 'NonExistentUser' does not exist.")}));
    }

    public void shouldFailWhenTerminatingConnectionsByNonAdmin() throws Throwable {
        this.authenticate(this.user, "Igor", "123", null);
        BoltConnectionManagementIT.assertFailTerminateConnectionForUser(this.user, "neo4j");
        BoltConnectionManagementIT.assertFailTerminateConnectionForUser(this.user, "NonExistentUser");
        BoltConnectionManagementIT.assertFailTerminateConnectionForUser(this.user, "");
    }

    public void shouldTerminateOwnConnectionIfAdmin() throws Throwable {
        BoltConnectionManagementIT.assertTerminateOwnConnection(this.admin, "neo4j");
    }

    public void shouldTerminateOwnConnectionsIfAdmin() throws Throwable {
        this.authenticate(this.user, "neo4j", "123", null);
        BoltConnectionManagementIT.assertTerminateOwnConnections(this.admin, this.user, "neo4j");
    }

    public void shouldTerminateOwnConnectionIfNonAdmin() throws Throwable {
        this.authenticate(this.user, "Igor", "123", null);
        BoltConnectionManagementIT.assertTerminateOwnConnection(this.user, "Igor");
    }

    public void shouldTerminateOwnConnectionsIfNonAdmin() throws Throwable {
        TransportConnection user2 = (TransportConnection)this.cf.newInstance();
        this.authenticate(this.user, "Igor", "123", null);
        this.authenticate(user2, "Igor", "123", null);
        BoltConnectionManagementIT.assertTerminateOwnConnections(this.user, user2, "Igor");
    }

    private static void verifyConnectionHasTerminated(TransportConnection conn) throws Exception {
        try {
            conn.recv(1);
            Assert.fail((String)"Connection should have terminated");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void assertTerminateOwnConnection(TransportConnection conn, String username) throws Exception {
        conn.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)("CALL dbms.terminateConnectionsForUser( '" + username + "' ) YIELD username, connectionCount")), PullAllMessage.pullAll()}));
        BoltConnectionManagementIT.verifyConnectionHasTerminated(conn);
    }

    private static void assertTerminateOwnConnections(TransportConnection conn1, TransportConnection conn2, String username) throws Exception {
        conn1.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)("CALL dbms.terminateConnectionsForUser( '" + username + "' ) YIELD username, connectionCount")), PullAllMessage.pullAll()}));
        BoltConnectionManagementIT.verifyConnectionHasTerminated(conn1);
        BoltConnectionManagementIT.verifyConnectionHasTerminated(conn2);
    }

    private static void assertFailTerminateConnectionForUser(TransportConnection client, String username) throws Exception {
        client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)("CALL dbms.terminateConnectionsForUser( '" + username + "' ) YIELD username, connectionCount")), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.Forbidden, (String)"Permission denied."), MessageMatchers.msgIgnored()}));
        client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{ResetMessage.reset()}));
        MatcherAssert.assertThat((Object)client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess()}));
    }

    private void authenticate(TransportConnection client, String username, String password, String newPassword) throws Exception {
        Map authToken = MapUtil.map((Object[])new Object[]{"principal", username, "credentials", password, "scheme", "basic"});
        if (newPassword != null) {
            authToken.put("new_credentials", newPassword);
        }
        client.connect(this.address).send(TransportTestUtil.acceptedVersions((long)1L, (long)0L, (long)0L, (long)0L)).send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", (Map)authToken)}));
        MatcherAssert.assertThat((Object)client, (Matcher)TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess()}));
    }

    private static void createNewUser(TransportConnection client, String username, String password) throws Exception {
        client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)("CALL dbms.security.createUser( '" + username + "', '" + password + "', false )")), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
    }

    private static Map<String, Long> collectConnectionResult(TransportConnection client, int n) {
        CollectingMatcher collector = new CollectingMatcher();
        MatcherAssert.assertThat((Object)client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess((Matcher)CoreMatchers.allOf((Matcher)Matchers.hasEntry((Matcher)CoreMatchers.is((Object)"fields"), (Matcher)CoreMatchers.equalTo(Arrays.asList("username", "connectionCount"))), (Matcher)Matchers.hasKey((Object)"result_available_after")))}));
        for (int i = 0; i < n; ++i) {
            MatcherAssert.assertThat((Object)client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgRecord((Matcher)collector)}));
        }
        MatcherAssert.assertThat((Object)client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess()}));
        return collector.result();
    }

    static class CollectingMatcher
    extends BaseMatcher<Record> {
        Map<String, Long> resultMap = new HashMap<String, Long>();

        CollectingMatcher() {
        }

        public void describeTo(Description description) {
        }

        public boolean matches(Object o) {
            if (o instanceof ImmutableRecord) {
                Object[] fields = ((ImmutableRecord)o).fields();
                this.resultMap.put(fields[0].toString(), (Long)fields[1]);
                return true;
            }
            return false;
        }

        public Map<String, Long> result() {
            return this.resultMap;
        }
    }
}

