/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth.integration.bolt;

import java.time.Clock;
import java.util.Map;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.bolt.security.auth.AuthenticationException;
import org.neo4j.bolt.security.auth.BasicAuthentication;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.UserManagerSupplier;
import org.neo4j.server.security.auth.AuthenticationStrategy;
import org.neo4j.server.security.auth.InMemoryUserRepository;
import org.neo4j.server.security.auth.RateLimitedAuthenticationStrategy;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.enterprise.auth.MultiRealmAuthManagerRule;
import org.neo4j.test.assertion.Assert;

public class BoltInitChangePasswordTest {
    @Rule
    public MultiRealmAuthManagerRule authManagerRule = new MultiRealmAuthManagerRule((UserRepository)new InMemoryUserRepository(), (AuthenticationStrategy)new RateLimitedAuthenticationStrategy(Clock.systemUTC(), 3));
    private BasicAuthentication authentication;

    @Before
    public void setup() throws Throwable {
        this.authentication = new BasicAuthentication((AuthManager)this.authManagerRule.getManager(), (UserManagerSupplier)this.authManagerRule.getManager());
        this.authManagerRule.getManager().getUserManager().newUser("neo4j", "123", true);
    }

    @Test
    public void shouldLogInitPasswordChange() throws Throwable {
        this.authentication.authenticate(this.authToken("neo4j", "123", "secret"));
        MultiRealmAuthManagerRule.FullSecurityLog fullLog = this.authManagerRule.getFullSecurityLog();
        fullLog.assertHasLine("neo4j", "logged in");
        fullLog.assertHasLine("neo4j", "changed password");
    }

    @Test
    public void shouldLogFailedInitPasswordChange() throws Throwable {
        Assert.assertException(() -> this.authentication.authenticate(this.authToken("neo4j", "123", "123")), AuthenticationException.class, (String)"Old password and new password cannot be the same.");
        MultiRealmAuthManagerRule.FullSecurityLog fullLog = this.authManagerRule.getFullSecurityLog();
        fullLog.assertHasLine("neo4j", "logged in");
        fullLog.assertHasLine("neo4j", "tried to change password: Old password and new password cannot be the same.");
    }

    private Map<String, Object> authToken(String username, String password, String newPassword) {
        return MapUtil.map((Object[])new Object[]{"principal", username, "credentials", password, "new_credentials", newPassword, "scheme", "basic"});
    }
}

