/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth.integration.bolt;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.function.Consumer;
import org.neo4j.bolt.v1.transport.integration.AuthenticationIT;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.test.TestEnterpriseGraphDatabaseFactory;
import org.neo4j.test.TestGraphDatabaseFactory;

public class EnterpriseAuthenticationIT
extends AuthenticationIT {
    protected TestGraphDatabaseFactory getTestGraphDatabaseFactory() {
        return new TestEnterpriseGraphDatabaseFactory();
    }

    protected Consumer<Map<String, String>> getSettingsFunction() {
        Path homeDir;
        try {
            homeDir = Files.createTempDirectory("logs", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Test setup failed to create temporary directory", e);
        }
        return settings -> {
            settings.put(GraphDatabaseSettings.auth_enabled.name(), "true");
            settings.put(GraphDatabaseSettings.logs_directory.name(), homeDir.toAbsolutePath().toString());
        };
    }

    public void shouldFailIfMalformedAuthTokenUnknownScheme() throws Throwable {
    }
}

