/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth.integration.bolt;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.neo4j.bolt.v1.messaging.message.InitMessage;
import org.neo4j.bolt.v1.messaging.message.PullAllMessage;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;
import org.neo4j.bolt.v1.messaging.message.RunMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.runtime.spi.StreamMatchers;
import org.neo4j.bolt.v1.transport.integration.Neo4jWithSocket;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.bolt.v1.transport.socket.client.SecureSocketConnection;
import org.neo4j.bolt.v1.transport.socket.client.TransportConnection;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.test.TestEnterpriseGraphDatabaseFactory;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.parboiled.common.StringUtils;

public abstract class EnterpriseAuthenticationTestBase
extends AbstractLdapTestUnit {
    @Rule
    public Neo4jWithSocket server = new Neo4jWithSocket(((Object)((Object)this)).getClass(), this.getTestGraphDatabaseFactory(), this.asSettings(this.getSettingsFunction()));
    protected static String createdUserPassword = "nativePassword";
    public Factory<TransportConnection> cf = SecureSocketConnection::new;
    public HostnamePort address = new HostnamePort("localhost:7687");
    protected TransportConnection client;

    protected void restartNeo4jServerWithOverriddenSettings(Consumer<Map<Setting<?>, String>> overrideSettingsFunction) throws IOException {
        this.server.shutdownDatabase();
        this.server.ensureDatabase(this.asSettings(overrideSettingsFunction));
    }

    protected Consumer<Map<String, String>> asSettings(Consumer<Map<Setting<?>, String>> overrideSettingsFunction) {
        return settings -> {
            LinkedHashMap o = new LinkedHashMap();
            overrideSettingsFunction.accept(o);
            for (Setting key : o.keySet()) {
                settings.put(key.name(), o.get(key));
            }
        };
    }

    protected TestGraphDatabaseFactory getTestGraphDatabaseFactory() {
        return new TestEnterpriseGraphDatabaseFactory();
    }

    protected Consumer<Map<Setting<?>, String>> getSettingsFunction() {
        return settings -> settings.put(GraphDatabaseSettings.auth_enabled, "true");
    }

    @Before
    public void setup() {
        this.client = (TransportConnection)this.cf.newInstance();
    }

    @After
    public void teardown() throws Exception {
        if (this.client != null) {
            this.client.disconnect();
        }
    }

    protected void reconnect() throws Exception {
        if (this.client != null) {
            this.client.disconnect();
        }
        this.client = (TransportConnection)this.cf.newInstance();
    }

    protected void testCreateReaderUser() throws Exception {
        this.testCreateReaderUser("neo");
    }

    protected void testAuthWithReaderUser() throws Exception {
        this.testAuthWithReaderUser("neo", "abc123", null);
    }

    protected void testAuthWithPublisherUser() throws Exception {
        this.testAuthWithPublisherUser("tank", "abc123", null);
    }

    protected void testCreateReaderUser(String username) throws Exception {
        this.assertAuthAndChangePassword("neo4j", "abc123", "123");
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)("CALL dbms.security.createUser( '" + username + "', '" + createdUserPassword + "', false ) CALL dbms.security.addRoleToUser( 'reader', '" + username + "' ) RETURN 0")), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)0L)}))}));
    }

    protected void testAuthWithReaderUser(String username, String password, String realm) throws Exception {
        this.assertAuth(username, password, realm);
        this.assertReadSucceeds();
        this.assertWriteFails(username, "reader");
    }

    protected void testAuthWithPublisherUser(String username, String password, String realm) throws Exception {
        this.assertAuth(username, password, realm);
        this.assertWriteSucceeds();
    }

    protected void testAuthWithNoPermissionUser(String username, String password) throws Exception {
        this.assertAuth(username, password);
        this.assertReadFails(username, "");
    }

    protected void assertAuth(String username, String password) throws Exception {
        this.assertConnectionSucceeds(this.authToken(username, password, null));
    }

    protected void assertAuthAndChangePassword(String username, String password, String newPassword) throws Exception {
        this.assertAuth(username, password);
        String query = String.format("CALL dbms.security.changeUserPassword('%s', '%s', false)", username, newPassword);
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)query), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
    }

    protected void assertAuth(String username, String password, String realm) throws Exception {
        this.assertConnectionSucceeds(this.authToken(username, password, realm));
    }

    protected void assertAuthFail(String username, String password) throws Exception {
        this.assertConnectionFails(MapUtil.map((Object[])new Object[]{"principal", username, "credentials", password, "scheme", "basic"}));
    }

    protected void assertRoles(String ... roles) throws Exception {
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"CALL dbms.showCurrentUser"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.equalTo((Object)"tank"), Matchers.containsInAnyOrder((Object[])roles), Matchers.anything()})), MessageMatchers.msgSuccess()}));
    }

    protected void assertConnectionSucceeds(Map<String, Object> authToken) throws Exception {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions((long)1L, (long)0L, (long)0L, (long)0L)).send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", authToken)}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess()}));
    }

    protected void assertConnectionFails(Map<String, Object> authToken) throws Exception {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions((long)1L, (long)0L, (long)0L, (long)0L)).send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", authToken)}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.Unauthorized, (String)"The client is unauthorized due to authentication failure.")}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    protected void assertReadSucceeds() throws Exception {
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"MATCH (n) RETURN count(n)"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(0L))})), MessageMatchers.msgSuccess()}));
    }

    protected void assertReadFails(String username, String roles) throws Exception {
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"MATCH (n) RETURN n"), PullAllMessage.pullAll()}));
        String roleString = StringUtils.isEmpty((String)roles) ? "no roles" : "roles [" + roles + "]";
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.Forbidden, (String)String.format("Read operations are not allowed for user '%s' with %s.", username, roleString))}));
    }

    protected void assertWriteSucceeds() throws Exception {
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"CREATE ()"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
    }

    protected void assertWriteFails(String username, String roles) throws Exception {
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"CREATE ()"), PullAllMessage.pullAll()}));
        String roleString = StringUtils.isEmpty((String)roles) ? "no roles" : "roles [" + roles + "]";
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.Forbidden, (String)String.format("Write operations are not allowed for user '%s' with %s.", username, roleString))}));
    }

    protected void assertBeginTransactionSucceeds() throws Exception {
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"BEGIN"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
    }

    protected void assertCommitTransaction() throws Exception {
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"COMMIT"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
    }

    protected void assertQuerySucceeds(String query) throws Exception {
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)query), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
    }

    protected Map<String, Object> authToken(String username, String password, String realm) {
        if (realm != null && realm.length() > 0) {
            return MapUtil.map((Object[])new Object[]{"principal", username, "credentials", password, "scheme", "basic", "realm", realm});
        }
        return MapUtil.map((Object[])new Object[]{"principal", username, "credentials", password, "scheme", "basic"});
    }
}

