/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth.integration.bolt;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapContext;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapOperationErrorException;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.annotations.SaslMechanism;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.annotations.LoadSchema;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.Interceptor;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.integ.AbstractLdapTestUnit;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.ldap.handlers.extended.StartTlsHandler;
import org.apache.directory.server.ldap.handlers.sasl.cramMD5.CramMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.digestMD5.DigestMd5MechanismHandler;
import org.apache.shiro.realm.ldap.JndiLdapContextFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.neo4j.bolt.v1.messaging.message.InitMessage;
import org.neo4j.bolt.v1.messaging.message.PullAllMessage;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;
import org.neo4j.bolt.v1.messaging.message.RunMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.runtime.spi.StreamMatchers;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.bolt.v1.transport.socket.client.TransportConnection;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.SecurityContext;
import org.neo4j.kernel.enterprise.api.security.EnterpriseSecurityContext;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.server.security.enterprise.auth.EnterpriseAuthAndUserManager;
import org.neo4j.server.security.enterprise.auth.ProcedureInteractionTestBase;
import org.neo4j.server.security.enterprise.auth.integration.bolt.EnterpriseAuthenticationTestBase;
import org.neo4j.server.security.enterprise.auth.integration.bolt.TimeoutTests;
import org.neo4j.server.security.enterprise.configuration.SecuritySettings;
import org.neo4j.test.DoubleLatch;

@RunWith(value=FrameworkRunner.class)
@CreateDS(name="Test", partitions={@CreatePartition(name="example", suffix="dc=example,dc=com", contextEntry=@ContextEntry(entryLdif="dn: dc=example,dc=com\ndc: example\no: example\nobjectClass: top\nobjectClass: dcObject\nobjectClass: organization\n\n"))}, loadedSchemas={@LoadSchema(name="nis", enabled=true)})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", port=10389, address="0.0.0.0"), @CreateTransport(protocol="LDAPS", port=10636, address="0.0.0.0", ssl=true)}, saslMechanisms={@SaslMechanism(name="DIGEST-MD5", implClass=DigestMd5MechanismHandler.class), @SaslMechanism(name="CRAM-MD5", implClass=CramMd5MechanismHandler.class)}, saslHost="0.0.0.0", extendedOpHandlers={StartTlsHandler.class}, keyStore="target/test-classes/neo4j_ldap_test_keystore.jks", certificatePassword="secret")
@ApplyLdifFiles(value={"ldap_test_data.ldif"})
public class LdapAuthIT
extends EnterpriseAuthenticationTestBase {
    private final String MD5_HASHED_abc123 = "{MD5}6ZoYxCjLONXyYIU2eJIuAw==";
    private static Consumer<Map<Setting<?>, String>> ldapOnlyAuthSettings = settings -> {
        settings.put(SecuritySettings.auth_provider, "ldap");
        settings.put(SecuritySettings.native_authentication_enabled, "false");
        settings.put(SecuritySettings.native_authorization_enabled, "false");
        settings.put(SecuritySettings.ldap_authentication_enabled, "true");
        settings.put(SecuritySettings.ldap_authorization_enabled, "true");
    };
    private static Consumer<Map<Setting<?>, String>> activeDirectoryOnEc2Settings = settings -> {
        settings.put(SecuritySettings.auth_provider, "ldap");
        settings.put(SecuritySettings.ldap_server, "henrik.neohq.net:389");
        settings.put(SecuritySettings.ldap_authentication_user_dn_template, "cn={0},cn=Users,dc=neo4j,dc=com");
        settings.put(SecuritySettings.ldap_authorization_user_search_base, "cn=Users,dc=neo4j,dc=com");
        settings.put(SecuritySettings.ldap_authorization_user_search_filter, "(&(objectClass=*)(CN={0}))");
        settings.put(SecuritySettings.ldap_authorization_group_membership_attribute_names, "memberOf");
        settings.put(SecuritySettings.ldap_authorization_group_to_role_mapping, "'CN=Neo4j Read Only,CN=Users,DC=neo4j,DC=com'=reader;CN=Neo4j Read-Write,CN=Users,DC=neo4j,DC=com=publisher;CN=Neo4j Schema Manager,CN=Users,DC=neo4j,DC=com=architect;CN=Neo4j Administrator,CN=Users,DC=neo4j,DC=com=admin");
    };
    private static Consumer<Map<Setting<?>, String>> activeDirectoryOnEc2NotUsingSystemAccountSettings = activeDirectoryOnEc2Settings.andThen(settings -> settings.put(SecuritySettings.ldap_authorization_use_system_account, "false"));
    private static Consumer<Map<Setting<?>, String>> activeDirectoryOnEc2UsingSystemAccountSettings = activeDirectoryOnEc2Settings.andThen(settings -> {
        settings.put(SecuritySettings.ldap_authorization_use_system_account, "true");
        settings.put(SecuritySettings.ldap_authorization_system_username, "Petra Selmer");
        settings.put(SecuritySettings.ldap_authorization_system_password, "S0uthAfrica");
    });

    @Override
    @Before
    public void setup() {
        super.setup();
        LdapAuthIT.getLdapServer().setConfidentialityRequired(false);
    }

    private void restartNeo4jServerWithSaslDigestMd5() throws IOException {
        this.server.shutdownDatabase();
        this.server.ensureDatabase(this.asSettings(ldapOnlyAuthSettings.andThen(settings -> {
            settings.put(SecuritySettings.ldap_authentication_mechanism, "DIGEST-MD5");
            settings.put(SecuritySettings.ldap_authentication_user_dn_template, "{0}");
        })));
    }

    private void restartNeo4jServerWithSaslCramMd5() throws IOException {
        this.server.shutdownDatabase();
        this.server.ensureDatabase(this.asSettings(ldapOnlyAuthSettings.andThen(settings -> {
            settings.put(SecuritySettings.ldap_authentication_mechanism, "CRAM-MD5");
            settings.put(SecuritySettings.ldap_authentication_user_dn_template, "{0}");
        })));
    }

    @Override
    protected Consumer<Map<Setting<?>, String>> getSettingsFunction() {
        return super.getSettingsFunction().andThen(ldapOnlyAuthSettings).andThen(settings -> {
            settings.put(SecuritySettings.ldap_server, "0.0.0.0:10389");
            settings.put(SecuritySettings.ldap_authentication_user_dn_template, "cn={0},ou=users,dc=example,dc=com");
            settings.put(SecuritySettings.ldap_authentication_cache_enabled, "true");
            settings.put(SecuritySettings.ldap_authorization_system_username, "uid=admin,ou=system");
            settings.put(SecuritySettings.ldap_authorization_system_password, "secret");
            settings.put(SecuritySettings.ldap_authorization_use_system_account, "true");
            settings.put(SecuritySettings.ldap_authorization_user_search_base, "dc=example,dc=com");
            settings.put(SecuritySettings.ldap_authorization_user_search_filter, "(&(objectClass=*)(uid={0}))");
            settings.put(SecuritySettings.ldap_authorization_group_membership_attribute_names, "gidnumber");
            settings.put(SecuritySettings.ldap_authorization_group_to_role_mapping, "500=reader;501=publisher;502=architect;503=admin");
            settings.put(SecuritySettings.procedure_roles, "test.allowedReadProcedure:role1");
            settings.put(SecuritySettings.ldap_read_timeout, "1s");
        });
    }

    @Test
    public void shouldLoginWithLdap() throws Throwable {
        this.assertAuth("neo4j", "abc123");
        this.reconnect();
        this.assertAuth("neo4j", "abc123");
    }

    @Test
    public void shouldLoginWithLdapWithAuthenticationCacheDisabled() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(ldapOnlyAuthSettings.andThen(settings -> settings.put(SecuritySettings.ldap_authentication_cache_enabled, "false")));
        this.assertAuth("neo4j", "abc123");
        this.reconnect();
        this.assertAuth("neo4j", "abc123");
    }

    @Test
    public void shouldFailToLoginWithLdapIfInvalidCredentials() throws Throwable {
        this.assertAuthFail("neo4j", "CANT_REMEMBER_MY_PASSWORDS_ANYMORE!");
    }

    @Test
    public void shoulFailToLoginWithLdapIfInvalidCredentialsFollowingSuccessfulLogin() throws Throwable {
        this.assertAuth("neo4j", "abc123");
        this.reconnect();
        this.assertAuthFail("neo4j", "");
    }

    @Test
    public void shouldLoginWithLdapUsingSaslDigestMd5() throws Throwable {
        this.restartNeo4jServerWithSaslDigestMd5();
        this.assertAuth("neo4j", "{MD5}6ZoYxCjLONXyYIU2eJIuAw==");
    }

    @Test
    public void shouldFailToLoginWithLdapDigestMd5IfInvalidCredentials() throws Throwable {
        this.restartNeo4jServerWithSaslDigestMd5();
        this.assertAuthFail("neo4j", "{MD5}6ZoYxCjLONXyYIU2eJIuAw==".toUpperCase());
    }

    @Test
    public void shouldLoginWithLdapUsingSaslCramMd5() throws Throwable {
        this.restartNeo4jServerWithSaslCramMd5();
        this.assertAuth("neo4j", "{MD5}6ZoYxCjLONXyYIU2eJIuAw==");
    }

    @Test
    public void shouldFailToLoginWithLdapCramMd5IfInvalidCredentials() throws Throwable {
        this.restartNeo4jServerWithSaslCramMd5();
        this.assertAuthFail("neo4j", "{MD5}6ZoYxCjLONXyYIU2eJIuAw==".toUpperCase());
    }

    @Test
    public void shouldBeAbleToLoginAndAuthorizeReaderWithLdapOnly() throws Throwable {
        this.testAuthWithReaderUser();
    }

    @Test
    public void shouldBeAbleToLoginAndAuthorizePublisherWithLdapOnly() throws Throwable {
        this.testAuthWithPublisherUser();
    }

    @Test
    public void shouldBeAbleToLoginAndAuthorizeNoPermissionUserWithLdapOnly() throws Throwable {
        this.testAuthWithNoPermissionUser("smith", "abc123");
    }

    @Test
    public void shouldShowCurrentUser() throws Throwable {
        this.assertAuth("smith", "abc123");
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"CALL dbms.showCurrentUser()"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)"smith"), CoreMatchers.equalTo(Collections.emptyList()), CoreMatchers.equalTo(Collections.emptyList())}))}));
    }

    @Test
    public void shouldBeAbleToLoginAndAuthorizeNoPermissionUserWithLdapOnlyAndNoGroupToRoleMapping() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(ldapOnlyAuthSettings.andThen(settings -> {
            String cfr_ignored_0 = settings.put(SecuritySettings.ldap_authorization_group_to_role_mapping, null);
        }));
        this.testAuthWithNoPermissionUser("neo", "abc123");
    }

    @Test
    public void shouldBeAbleToLoginAndAuthorizeWithLdapOnlyAndQuotedGroupToRoleMapping() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(ldapOnlyAuthSettings.andThen(settings -> settings.put(SecuritySettings.ldap_authorization_group_to_role_mapping, " '500'  =\t reader  ; \"501\"\t=publisher\n;502 =architect  ;  \"503\"=  \nadmin")));
        this.testAuthWithReaderUser();
        this.reconnect();
        this.testAuthWithPublisherUser();
        this.reconnect();
        this.testAuthWithNoPermissionUser("smith", "abc123");
    }

    @Test
    public void shouldBeAbleToLoginAndAuthorizeReaderWithUserLdapContext() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(settings -> settings.put(SecuritySettings.ldap_authorization_use_system_account, "false"));
        this.testAuthWithReaderUser();
    }

    @Test
    public void shouldBeAbleToLoginAndAuthorizePublisherWithUserLdapContext() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(settings -> settings.put(SecuritySettings.ldap_authorization_use_system_account, "false"));
        this.testAuthWithPublisherUser();
    }

    @Test
    public void shouldFailIfAuthorizationExpiredWithUserLdapContext() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(settings -> settings.put(SecuritySettings.ldap_authorization_use_system_account, "false"));
        this.assertAuth("neo4j", "abc123");
        this.assertReadSucceeds();
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"CALL dbms.security.clearAuthCache()"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"MATCH (n) RETURN n"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.AuthorizationExpired, (String)"LDAP authorization info expired.")}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    public void shouldSucceedIfAuthorizationExpiredWithinTransactionWithUserLdapContext() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(settings -> settings.put(SecuritySettings.ldap_authorization_use_system_account, "false"));
        this.assertAuth("neo4j", "abc123");
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"CALL dbms.security.clearAuthCache() MATCH (n) RETURN n"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldBeAbleToLoginAndAuthorizeNoPermissionUserWithUserLdapContext() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(settings -> settings.put(SecuritySettings.ldap_authorization_use_system_account, "false"));
        this.testAuthWithNoPermissionUser("smith", "abc123");
    }

    @Test
    public void shouldBeAbleToLoginAndAuthorizeNoPermissionUserWithUserLdapContextAndNoGroupToRoleMapping() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(settings -> {
            settings.put(SecuritySettings.ldap_authorization_use_system_account, "false");
            settings.put(SecuritySettings.ldap_authorization_group_to_role_mapping, null);
        });
        this.testAuthWithNoPermissionUser("neo", "abc123");
    }

    @Test
    public void shouldBeAbleToLoginWithLdapAndAuthorizeInternally() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(settings -> {
            settings.put(SecuritySettings.auth_providers, "native,ldap");
            settings.put(SecuritySettings.native_authentication_enabled, "false");
            settings.put(SecuritySettings.native_authorization_enabled, "true");
            settings.put(SecuritySettings.ldap_authentication_enabled, "true");
            settings.put(SecuritySettings.ldap_authorization_enabled, "false");
        });
        this.testCreateReaderUser();
        this.reconnect();
        this.testAuthWithReaderUser();
    }

    @Test
    public void shouldBeAbleToLoginNativelyAndAuthorizeWithLdap() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(settings -> {
            settings.put(SecuritySettings.auth_providers, "native,ldap");
            settings.put(SecuritySettings.native_authentication_enabled, "true");
            settings.put(SecuritySettings.native_authorization_enabled, "false");
            settings.put(SecuritySettings.ldap_authentication_enabled, "false");
            settings.put(SecuritySettings.ldap_authorization_enabled, "true");
        });
        String ldapReaderUser = "neo";
        String nativePassword = "nativePassword";
        GraphDatabaseFacade gds = (GraphDatabaseFacade)this.server.graphDatabaseService();
        EnterpriseAuthAndUserManager authManager = (EnterpriseAuthAndUserManager)gds.getDependencyResolver().resolveDependency(EnterpriseAuthAndUserManager.class);
        authManager.getUserManager((SecurityContext)EnterpriseSecurityContext.AUTH_DISABLED).newUser(ldapReaderUser, nativePassword, false);
        this.testAuthWithReaderUser(ldapReaderUser, nativePassword, null);
    }

    @Test
    public void shouldKeepAuthorizationForLifetimeOfTransaction() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(settings -> settings.put(SecuritySettings.ldap_authorization_use_system_account, "false"));
        DoubleLatch latch = new DoubleLatch(2);
        Throwable[] threadFail = new Throwable[]{null};
        Thread readerThread = new Thread(() -> {
            try {
                this.assertAuth("neo", "abc123");
                this.assertBeginTransactionSucceeds();
                this.assertReadSucceeds();
                latch.startAndWaitForAllToStart();
                latch.finishAndWaitForAllToFinish();
                this.assertReadSucceeds();
            }
            catch (Throwable t) {
                threadFail[0] = t;
                latch.start();
                latch.finish();
            }
        });
        readerThread.start();
        latch.startAndWaitForAllToStart();
        this.clearAuthCacheFromDifferentConnection();
        latch.finishAndWaitForAllToFinish();
        readerThread.join();
        if (threadFail[0] != null) {
            throw threadFail[0];
        }
    }

    @Test
    public void shouldKeepAuthorizationForLifetimeOfTransactionWithProcedureAllowed() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(settings -> {
            settings.put(SecuritySettings.ldap_authorization_use_system_account, "false");
            settings.put(SecuritySettings.ldap_authorization_group_to_role_mapping, "503=admin;504=role1");
        });
        GraphDatabaseAPI graphDatabaseAPI = (GraphDatabaseAPI)this.server.graphDatabaseService();
        ((Procedures)graphDatabaseAPI.getDependencyResolver().resolveDependency(Procedures.class)).registerProcedure(ProcedureInteractionTestBase.ClassWithProcedures.class);
        DoubleLatch latch = new DoubleLatch(2);
        Throwable[] threadFail = new Throwable[]{null};
        Thread readerThread = new Thread(() -> {
            try {
                this.assertAuth("smith", "abc123");
                this.assertBeginTransactionSucceeds();
                this.assertAllowedReadProcedure();
                latch.startAndWaitForAllToStart();
                latch.finishAndWaitForAllToFinish();
                this.assertAllowedReadProcedure();
            }
            catch (Throwable t) {
                threadFail[0] = t;
                latch.start();
                latch.finish();
            }
        });
        readerThread.start();
        latch.startAndWaitForAllToStart();
        this.clearAuthCacheFromDifferentConnection();
        latch.finishAndWaitForAllToFinish();
        readerThread.join();
        if (threadFail[0] != null) {
            throw threadFail[0];
        }
    }

    @Test
    public void shouldBeAbleToUseProcedureAllowedAnnotationWithLdapGroupToRoleMapping() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(ldapOnlyAuthSettings.andThen(settings -> settings.put(SecuritySettings.ldap_authorization_group_to_role_mapping, "500=role1")));
        GraphDatabaseAPI graphDatabaseAPI = (GraphDatabaseAPI)this.server.graphDatabaseService();
        ((Procedures)graphDatabaseAPI.getDependencyResolver().resolveDependency(Procedures.class)).registerProcedure(ProcedureInteractionTestBase.ClassWithProcedures.class);
        this.assertAuth("neo", "abc123");
        this.assertAllowedReadProcedure();
    }

    @Test
    public void shouldFailIfInvalidLdapServer() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(ldapOnlyAuthSettings.andThen(settings -> settings.put(SecuritySettings.ldap_server, "ldap://127.0.0.1")));
        this.assertConnectionRefused(this.authToken("neo", "abc123", null), "LDAP connection refused.");
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    @Test
    @Category(value={TimeoutTests.class})
    public void shouldTimeoutIfLdapServerDoesNotRespond() throws Throwable {
        try (DirectoryServiceWaitOnSearch ignore = new DirectoryServiceWaitOnSearch(5000L);){
            this.restartNeo4jServerWithOverriddenSettings(ldapOnlyAuthSettings.andThen(settings -> settings.put(SecuritySettings.ldap_read_timeout, "1s")));
            this.assertAuth("neo", "abc123");
            this.assertLdapAuthorizationTimeout();
        }
    }

    @Test
    @Category(value={TimeoutTests.class})
    public void shouldTimeoutIfLdapServerDoesNotRespondWithoutConnectionPooling() throws Throwable {
        try (DirectoryServiceWaitOnSearch ignore = new DirectoryServiceWaitOnSearch(5000L);){
            this.restartNeo4jServerWithOverriddenSettings(ldapOnlyAuthSettings.andThen(settings -> {
                settings.put(SecuritySettings.ldap_read_timeout, "1s");
                settings.put(SecuritySettings.ldap_authorization_connection_pooling, "false");
            }));
            this.assertAuth("neo", "abc123");
            this.assertLdapAuthorizationTimeout();
        }
    }

    @Test
    @Category(value={TimeoutTests.class})
    public void shouldFailIfLdapSearchFails() throws Throwable {
        try (DirectoryServiceFailOnSearch ignore = new DirectoryServiceFailOnSearch();){
            this.restartNeo4jServerWithOverriddenSettings(ldapOnlyAuthSettings.andThen(settings -> settings.put(SecuritySettings.ldap_read_timeout, "1s")));
            this.assertAuth("neo", "abc123");
            this.assertLdapAuthorizationFailed();
        }
    }

    @Test
    public void shouldTimeoutIfLdapServerDoesNotRespondWithLdapUserContext() throws Throwable {
        try (DirectoryServiceWaitOnSearch ignore = new DirectoryServiceWaitOnSearch(5000L);){
            this.restartNeo4jServerWithOverriddenSettings(ldapOnlyAuthSettings.andThen(settings -> {
                settings.put(SecuritySettings.ldap_authorization_use_system_account, "false");
                settings.put(SecuritySettings.ldap_read_timeout, "1s");
            }));
            this.assertConnectionTimeout(this.authToken("neo", "abc123", null), "LDAP response timed out.");
        }
    }

    private void assertAllowedReadProcedure() throws IOException {
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"CALL test.allowedReadProcedure()"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgRecord((Matcher)StreamMatchers.eqRecord((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)"foo")})), MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldBeAbleToLoginAndAuthorizeReaderWithLdapOnlyUsingLDAPS() throws Throwable {
        LdapAuthIT.getLdapServer().setConfidentialityRequired(true);
        try (EmbeddedTestCertificates ignore = new EmbeddedTestCertificates();){
            this.restartNeo4jServerWithOverriddenSettings(ldapOnlyAuthSettings.andThen(settings -> settings.put(SecuritySettings.ldap_server, "ldaps://localhost:10636")));
            this.testAuthWithReaderUser();
        }
    }

    @Test
    public void shouldBeAbleToLoginAndAuthorizeReaderWithUserLdapContextUsingLDAPS() throws Throwable {
        LdapAuthIT.getLdapServer().setConfidentialityRequired(true);
        try (EmbeddedTestCertificates ignore = new EmbeddedTestCertificates();){
            this.restartNeo4jServerWithOverriddenSettings(ldapOnlyAuthSettings.andThen(settings -> {
                settings.put(SecuritySettings.ldap_authorization_use_system_account, "false");
                settings.put(SecuritySettings.ldap_server, "ldaps://localhost:10636");
            }));
            this.testAuthWithReaderUser();
        }
    }

    @Test
    public void shouldBeAbleToLoginAndAuthorizeReaderWithLdapOnlyUsingStartTls() throws Throwable {
        LdapAuthIT.getLdapServer().setConfidentialityRequired(true);
        try (EmbeddedTestCertificates ignore = new EmbeddedTestCertificates();){
            this.restartNeo4jServerWithOverriddenSettings(ldapOnlyAuthSettings.andThen(settings -> {
                settings.put(SecuritySettings.ldap_server, "localhost:10389");
                settings.put(SecuritySettings.ldap_use_starttls, "true");
            }));
            this.testAuthWithReaderUser();
        }
    }

    @Test
    public void shouldBeAbleToLoginAndAuthorizeReaderWithLdapUserContextUsingStartTls() throws Throwable {
        LdapAuthIT.getLdapServer().setConfidentialityRequired(true);
        try (EmbeddedTestCertificates ignore = new EmbeddedTestCertificates();){
            this.restartNeo4jServerWithOverriddenSettings(ldapOnlyAuthSettings.andThen(settings -> {
                settings.put(SecuritySettings.ldap_authorization_use_system_account, "false");
                settings.put(SecuritySettings.ldap_server, "localhost:10389");
                settings.put(SecuritySettings.ldap_use_starttls, "true");
            }));
            this.testAuthWithReaderUser();
        }
    }

    public void shouldNotBeAbleToLoginUnknownUserOnEC2() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(activeDirectoryOnEc2NotUsingSystemAccountSettings);
        this.assertAuthFail("unknown", "abc123ABC123");
    }

    public void shouldBeAbleToLoginAndAuthorizeReaderWithUserLdapContextOnEC2() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(activeDirectoryOnEc2NotUsingSystemAccountSettings);
        this.assertAuth("neo", "abc123ABC123");
        this.assertReadSucceeds();
        this.assertWriteFails("neo", "");
    }

    public void shouldBeAbleToLoginAndAuthorizeReaderOnEC2() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(activeDirectoryOnEc2UsingSystemAccountSettings);
        this.assertAuth("neo", "abc123ABC123");
        this.assertReadSucceeds();
        this.assertWriteFails("neo", "");
    }

    public void shouldBeAbleToLoginAndAuthorizePublisherWithUserLdapContextOnEC2() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(activeDirectoryOnEc2NotUsingSystemAccountSettings);
        this.assertAuth("tank", "abc123ABC123");
        this.assertWriteSucceeds();
    }

    public void shouldBeAbleToLoginAndAuthorizePublisherOnEC2() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(activeDirectoryOnEc2UsingSystemAccountSettings);
        this.assertAuth("tank", "abc123ABC123");
        this.assertWriteSucceeds();
    }

    public void shouldBeAbleToLoginAndAuthorizeNoPermissionUserWithUserLdapContextOnEC2() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(activeDirectoryOnEc2NotUsingSystemAccountSettings);
        this.assertAuth("smith", "abc123ABC123");
        this.assertReadFails("smith", "");
    }

    public void shouldBeAbleToLoginAndAuthorizeNoPermissionUserOnEC2() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(activeDirectoryOnEc2UsingSystemAccountSettings);
        this.assertAuth("smith", "abc123ABC123");
        this.assertReadFails("smith", "");
    }

    public void shouldBeAbleToLoginAndAuthorizeReaderUsingLdapsOnEC2() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(activeDirectoryOnEc2UsingSystemAccountSettings.andThen(settings -> settings.put(SecuritySettings.ldap_server, "ldaps://henrik.neohq.net:636")));
        this.assertAuth("neo", "abc123ABC123");
        this.assertReadSucceeds();
        this.assertWriteFails("neo", "");
    }

    public void shouldBeAbleToLoginAndAuthorizeReaderWithUserLdapContextUsingLDAPSOnEC2() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(activeDirectoryOnEc2NotUsingSystemAccountSettings.andThen(settings -> settings.put(SecuritySettings.ldap_server, "ldaps://henrik.neohq.net:636")));
        this.assertAuth("neo", "abc123ABC123");
        this.assertReadSucceeds();
        this.assertWriteFails("neo", "");
    }

    public void shouldBeAbleToLoginAndAuthorizeReaderUsingStartTlsOnEC2() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(activeDirectoryOnEc2UsingSystemAccountSettings.andThen(settings -> settings.put(SecuritySettings.ldap_use_starttls, "true")));
        this.assertAuth("neo", "abc123ABC123");
        this.assertReadSucceeds();
        this.assertWriteFails("neo", "");
    }

    public void shouldBeAbleToLoginAndAuthorizeReaderWithUserLdapContextUsingStartTlsOnEC2() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(activeDirectoryOnEc2NotUsingSystemAccountSettings.andThen(settings -> settings.put(SecuritySettings.ldap_use_starttls, "true")));
        this.assertAuth("neo", "abc123ABC123");
        this.assertReadSucceeds();
        this.assertWriteFails("neo", "");
    }

    @Test
    public void shouldBeAbleToLoginWithLdapWhenSelectingRealmFromClient() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(settings -> {
            settings.put(SecuritySettings.auth_providers, "native,ldap");
            settings.put(SecuritySettings.native_authentication_enabled, "true");
            settings.put(SecuritySettings.native_authorization_enabled, "true");
            settings.put(SecuritySettings.ldap_authentication_enabled, "true");
            settings.put(SecuritySettings.ldap_authorization_enabled, "true");
            settings.put(SecuritySettings.ldap_authorization_use_system_account, "true");
        });
        this.testCreateReaderUser("tank");
        this.reconnect();
        this.assertAuth("tank", createdUserPassword, "native");
        this.assertRoles("reader", "publisher");
        this.reconnect();
        this.assertAuth("tank", "abc123", "ldap");
        this.assertRoles("reader", "publisher");
    }

    @Test
    public void shouldBeAbleToAuthorizeUsingNativeWithLdapEnabled() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(settings -> {
            settings.put(SecuritySettings.auth_providers, "ldap,native");
            settings.put(SecuritySettings.native_authentication_enabled, "true");
            settings.put(SecuritySettings.native_authorization_enabled, "true");
            settings.put(SecuritySettings.ldap_authentication_enabled, "true");
            settings.put(SecuritySettings.ldap_authorization_enabled, "true");
            settings.put(SecuritySettings.ldap_authorization_use_system_account, "false");
        });
        this.testCreateReaderUser("simon");
        this.reconnect();
        this.assertAuth("simon", createdUserPassword, "native");
        this.assertReadSucceeds();
    }

    @Test
    public void shouldClearAuthenticationCache() throws Throwable {
        LdapAuthIT.getLdapServer().setConfidentialityRequired(true);
        try (EmbeddedTestCertificates ignore = new EmbeddedTestCertificates();){
            this.restartNeo4jServerWithOverriddenSettings(ldapOnlyAuthSettings.andThen(settings -> settings.put(SecuritySettings.ldap_server, "ldaps://localhost:10636")));
            this.assertAuth("tank", "abc123", "ldap");
            this.changeLDAPPassword("tank", "abc123", "123abc");
            this.reconnect();
            this.assertAuthFail("tank", "123abc");
            this.reconnect();
            this.assertAuth("tank", "abc123", "ldap");
            this.reconnect();
            this.testClearAuthCache();
            this.reconnect();
            this.assertAuthFail("tank", "abc123");
            this.reconnect();
            this.assertAuth("tank", "123abc", "ldap");
        }
    }

    @Test
    public void shouldClearAuthorizationCache() throws Throwable {
        LdapAuthIT.getLdapServer().setConfidentialityRequired(true);
        try (EmbeddedTestCertificates ignore = new EmbeddedTestCertificates();){
            this.restartNeo4jServerWithOverriddenSettings(ldapOnlyAuthSettings.andThen(settings -> settings.put(SecuritySettings.ldap_server, "ldaps://localhost:10636")));
            this.assertAuth("tank", "abc123", "ldap");
            this.assertReadSucceeds();
            this.assertWriteSucceeds();
            this.changeLDAPGroup("tank", "abc123", "reader");
            this.reconnect();
            this.assertAuth("tank", "abc123", "ldap");
            this.assertReadSucceeds();
            this.assertWriteSucceeds();
            this.reconnect();
            this.testClearAuthCache();
            this.reconnect();
            this.assertAuth("tank", "abc123", "ldap");
            this.assertReadSucceeds();
            this.assertWriteFails("tank", "reader");
        }
    }

    private void clearAuthCacheFromDifferentConnection() throws Exception {
        TransportConnection adminClient = (TransportConnection)this.cf.newInstance();
        Map<String, Object> authToken = this.authToken("neo4j", "abc123", null);
        adminClient.connect(this.address).send(TransportTestUtil.acceptedVersions((long)1L, (long)0L, (long)0L, (long)0L)).send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", authToken)}));
        MatcherAssert.assertThat((Object)adminClient, (Matcher)TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)adminClient, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess()}));
        adminClient.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"CALL dbms.security.clearAuthCache()"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)adminClient, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
    }

    private void assertLdapAuthorizationTimeout() throws IOException {
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"MATCH (n) RETURN n"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.AuthProviderTimeout, (String)"LDAP response timed out.")}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    private void assertLdapAuthorizationFailed() throws IOException {
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"MATCH (n) RETURN n"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.AuthProviderFailed, (String)"LDAP authorization request failed.")}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    private void assertConnectionTimeout(Map<String, Object> authToken, String message) throws Exception {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions((long)1L, (long)0L, (long)0L, (long)0L)).send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", authToken)}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.AuthProviderTimeout, (String)message)}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    private void assertConnectionRefused(Map<String, Object> authToken, String message) throws Exception {
        this.client.connect(this.address).send(TransportTestUtil.acceptedVersions((long)1L, (long)0L, (long)0L, (long)0L)).send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{InitMessage.init((String)"TestClient/1.1", authToken)}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((byte[])new byte[]{0, 0, 0, 1}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.AuthProviderFailed, (String)message)}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyDisconnects());
    }

    private void testClearAuthCache() throws Exception {
        this.assertAuth("neo4j", "abc123");
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"CALL dbms.security.clearAuthCache()"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
    }

    private void modifyLDAPAttribute(String username, Object credentials, String attribute, Object value) throws Throwable {
        String principal = String.format("cn=%s,ou=users,dc=example,dc=com", username);
        String principal1 = String.format("cn=%s,ou=users,dc=example,dc=com", username);
        JndiLdapContextFactory contextFactory = new JndiLdapContextFactory();
        contextFactory.setUrl("ldaps://localhost:10636");
        LdapContext ctx = contextFactory.getLdapContext((Object)principal1, credentials);
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute(attribute, value))};
        ctx.modifyAttributes(principal, mods);
        ctx.close();
    }

    private void changeLDAPPassword(String username, Object credentials, Object newCredentials) throws Throwable {
        this.modifyLDAPAttribute(username, credentials, "userpassword", newCredentials);
    }

    private void changeLDAPGroup(String username, Object credentials, String group) throws Throwable {
        String gid;
        switch (group) {
            case "reader": {
                gid = "500";
                break;
            }
            case "publisher": {
                gid = "501";
                break;
            }
            case "architect": {
                gid = "502";
                break;
            }
            case "admin": {
                gid = "503";
                break;
            }
            case "none": {
                gid = "504";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid group name '" + group + "', expected one of none, reader, publisher, architect, or admin");
            }
        }
        this.modifyLDAPAttribute(username, credentials, "gidnumber", gid);
    }

    private class EmbeddedTestCertificates
    implements AutoCloseable {
        private static final String KEY_STORE = "javax.net.ssl.keyStore";
        private static final String KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
        private static final String TRUST_STORE = "javax.net.ssl.trustStore";
        private static final String TRUST_STORE_PASSWORD = "javax.net.ssl.trustStorePassword";
        private final String keyStore = System.getProperty("javax.net.ssl.keyStore");
        private final String keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
        private final String trustStore = System.getProperty("javax.net.ssl.trustStore");
        private final String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");

        EmbeddedTestCertificates() {
            File keyStoreFile = this.fileFromResources("/neo4j_ldap_test_keystore.jks");
            String keyStorePath = keyStoreFile.getAbsolutePath();
            System.setProperty(KEY_STORE, keyStorePath);
            System.setProperty(KEY_STORE_PASSWORD, "secret");
            System.setProperty(TRUST_STORE, keyStorePath);
            System.setProperty(TRUST_STORE_PASSWORD, "secret");
        }

        @Override
        public void close() throws Exception {
            this.resetProperty(KEY_STORE, this.keyStore);
            this.resetProperty(KEY_STORE_PASSWORD, this.keyStorePassword);
            this.resetProperty(TRUST_STORE, this.trustStore);
            this.resetProperty(TRUST_STORE_PASSWORD, this.trustStorePassword);
        }

        private File fileFromResources(String path) {
            URL url = this.getClass().getResource(path);
            return new File(url.getFile());
        }

        private void resetProperty(String property, String value) {
            if (property != null) {
                System.clearProperty(property);
            } else {
                System.setProperty(property, value);
            }
        }
    }

    private class DirectoryServiceFailOnSearch
    implements AutoCloseable {
        private final Interceptor failOnSearchInterceptor;

        DirectoryServiceFailOnSearch() {
            this.failOnSearchInterceptor = new BaseInterceptor(){

                public String getName() {
                    return ((Object)((Object)this)).getClass().getName();
                }

                public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
                    throw new LdapOperationErrorException();
                }
            };
            try {
                AbstractLdapTestUnit.getService().addFirst(this.failOnSearchInterceptor);
            }
            catch (LdapException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() throws Exception {
            AbstractLdapTestUnit.getService().remove(this.failOnSearchInterceptor.getName());
        }
    }

    private class DirectoryServiceWaitOnSearch
    implements AutoCloseable {
        private final Interceptor waitOnSearchInterceptor;

        DirectoryServiceWaitOnSearch(final long waitingTimeMillis) {
            this.waitOnSearchInterceptor = new BaseInterceptor(){

                public String getName() {
                    return ((Object)((Object)this)).getClass().getName();
                }

                public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
                    try {
                        Thread.sleep(waitingTimeMillis);
                    }
                    catch (InterruptedException e) {
                        Thread.interrupted();
                    }
                    return super.search(searchContext);
                }
            };
            try {
                AbstractLdapTestUnit.getService().addFirst(this.waitOnSearchInterceptor);
            }
            catch (LdapException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() throws Exception {
            AbstractLdapTestUnit.getService().remove(this.waitOnSearchInterceptor.getName());
        }
    }
}

