/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth.integration.bolt;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.directory.server.annotations.CreateLdapServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.annotations.SaslMechanism;
import org.apache.directory.server.core.annotations.ApplyLdifFiles;
import org.apache.directory.server.core.annotations.ContextEntry;
import org.apache.directory.server.core.annotations.CreateDS;
import org.apache.directory.server.core.annotations.CreatePartition;
import org.apache.directory.server.core.annotations.LoadSchema;
import org.apache.directory.server.core.integ.FrameworkRunner;
import org.apache.directory.server.ldap.handlers.extended.StartTlsHandler;
import org.apache.directory.server.ldap.handlers.sasl.cramMD5.CramMd5MechanismHandler;
import org.apache.directory.server.ldap.handlers.sasl.digestMD5.DigestMd5MechanismHandler;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.server.security.enterprise.auth.integration.bolt.EnterpriseAuthenticationTestBase;
import org.neo4j.server.security.enterprise.auth.plugin.LdapGroupHasUsersAuthPlugin;
import org.neo4j.server.security.enterprise.configuration.SecuritySettings;

@RunWith(value=FrameworkRunner.class)
@CreateDS(name="Test", partitions={@CreatePartition(name="example", suffix="dc=example,dc=com", contextEntry=@ContextEntry(entryLdif="dn: dc=example,dc=com\ndc: example\no: example\nobjectClass: top\nobjectClass: dcObject\nobjectClass: organization\n\n"))}, loadedSchemas={@LoadSchema(name="nis", enabled=true)})
@CreateLdapServer(transports={@CreateTransport(protocol="LDAP", port=10389, address="0.0.0.0"), @CreateTransport(protocol="LDAPS", port=10636, address="0.0.0.0", ssl=true)}, saslMechanisms={@SaslMechanism(name="DIGEST-MD5", implClass=DigestMd5MechanismHandler.class), @SaslMechanism(name="CRAM-MD5", implClass=CramMd5MechanismHandler.class)}, saslHost="0.0.0.0", extendedOpHandlers={StartTlsHandler.class}, keyStore="target/test-classes/neo4j_ldap_test_keystore.jks", certificatePassword="secret")
@ApplyLdifFiles(value={"ldap_group_has_users_test_data.ldif"})
public class LdapExamplePluginAuthenticationIT
extends EnterpriseAuthenticationTestBase {
    @Override
    @Before
    public void setup() {
        super.setup();
        LdapExamplePluginAuthenticationIT.getLdapServer().setConfidentialityRequired(false);
    }

    @Override
    protected Consumer<Map<Setting<?>, String>> getSettingsFunction() {
        return super.getSettingsFunction().andThen(settings -> settings.put(SecuritySettings.auth_provider, "plugin-" + new LdapGroupHasUsersAuthPlugin().name()));
    }

    @Test
    public void shouldBeAbleToLoginAndAuthorizeWithLdapGroupHasUsersAuthPlugin() throws Throwable {
        this.testAuthWithReaderUser();
        this.reconnect();
        this.testAuthWithPublisherUser();
        this.reconnect();
        this.testAuthWithNoPermissionUser("smith", "abc123");
    }
}

