/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth.integration.bolt;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.neo4j.bolt.v1.messaging.message.PullAllMessage;
import org.neo4j.bolt.v1.messaging.message.RequestMessage;
import org.neo4j.bolt.v1.messaging.message.RunMessage;
import org.neo4j.bolt.v1.messaging.util.MessageMatchers;
import org.neo4j.bolt.v1.transport.integration.TransportTestUtil;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.security.enterprise.auth.integration.bolt.EnterpriseAuthenticationTestBase;
import org.neo4j.server.security.enterprise.auth.plugin.TestCacheableAuthPlugin;
import org.neo4j.server.security.enterprise.auth.plugin.TestCacheableAuthenticationPlugin;
import org.neo4j.server.security.enterprise.auth.plugin.TestCustomCacheableAuthenticationPlugin;
import org.neo4j.server.security.enterprise.configuration.SecuritySettings;

public class PluginAuthenticationIT
extends EnterpriseAuthenticationTestBase {
    private static final List<String> defaultTestPluginRealmList = Arrays.asList("TestAuthenticationPlugin", "TestAuthPlugin", "TestCacheableAdminAuthPlugin", "TestCacheableAuthenticationPlugin", "TestCacheableAuthPlugin", "TestCustomCacheableAuthenticationPlugin", "TestCustomParametersAuthenticationPlugin");
    private static final String DEFAULT_TEST_PLUGIN_REALMS = String.join((CharSequence)", ", defaultTestPluginRealmList.stream().map(s -> StringUtils.prependIfMissing((String)s, (CharSequence)"plugin-", (CharSequence[])new CharSequence[0])).collect(Collectors.toList()));

    @Override
    protected Consumer<Map<Setting<?>, String>> getSettingsFunction() {
        return super.getSettingsFunction().andThen(settings -> settings.put(SecuritySettings.auth_providers, DEFAULT_TEST_PLUGIN_REALMS));
    }

    @Test
    public void shouldAuthenticateWithTestAuthenticationPlugin() throws Throwable {
        this.assertConnectionSucceeds(this.authToken("neo4j", "neo4j", "plugin-TestAuthenticationPlugin"));
    }

    @Test
    public void shouldAuthenticateWithTestCacheableAuthenticationPlugin() throws Throwable {
        Map<String, Object> authToken = this.authToken("neo4j", "neo4j", "plugin-TestCacheableAuthenticationPlugin");
        TestCacheableAuthenticationPlugin.getAuthenticationInfoCallCount.set(0);
        this.restartNeo4jServerWithOverriddenSettings(settings -> settings.put(SecuritySettings.auth_cache_ttl, "60m"));
        this.assertConnectionSucceeds(authToken);
        MatcherAssert.assertThat((Object)TestCacheableAuthenticationPlugin.getAuthenticationInfoCallCount.get(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.reconnect();
        this.assertConnectionSucceeds(authToken);
        MatcherAssert.assertThat((Object)TestCacheableAuthenticationPlugin.getAuthenticationInfoCallCount.get(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.reconnect();
        authToken.put("credentials", "wrong_password");
        this.assertConnectionFails(authToken);
        MatcherAssert.assertThat((Object)TestCacheableAuthenticationPlugin.getAuthenticationInfoCallCount.get(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void shouldAuthenticateWithTestCustomCacheableAuthenticationPlugin() throws Throwable {
        Map<String, Object> authToken = this.authToken("neo4j", "neo4j", "plugin-TestCustomCacheableAuthenticationPlugin");
        TestCustomCacheableAuthenticationPlugin.getAuthenticationInfoCallCount.set(0);
        this.restartNeo4jServerWithOverriddenSettings(settings -> settings.put(SecuritySettings.auth_cache_ttl, "60m"));
        this.assertConnectionSucceeds(authToken);
        MatcherAssert.assertThat((Object)TestCustomCacheableAuthenticationPlugin.getAuthenticationInfoCallCount.get(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.reconnect();
        this.assertConnectionSucceeds(authToken);
        MatcherAssert.assertThat((Object)TestCustomCacheableAuthenticationPlugin.getAuthenticationInfoCallCount.get(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.reconnect();
        authToken.put("credentials", "wrong_password");
        this.assertConnectionFails(authToken);
        MatcherAssert.assertThat((Object)TestCustomCacheableAuthenticationPlugin.getAuthenticationInfoCallCount.get(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void shouldAuthenticateAndAuthorizeWithTestAuthPlugin() throws Throwable {
        this.assertConnectionSucceeds(this.authToken("neo4j", "neo4j", "plugin-TestAuthPlugin"));
        this.assertReadSucceeds();
        this.assertWriteFails("neo4j", "reader");
    }

    @Test
    public void shouldAuthenticateAndAuthorizeWithCacheableTestAuthPlugin() throws Throwable {
        this.assertConnectionSucceeds(this.authToken("neo4j", "neo4j", "plugin-TestCacheableAuthPlugin"));
        this.assertReadSucceeds();
        this.assertWriteFails("neo4j", "reader");
    }

    @Test
    public void shouldAuthenticateWithTestCacheableAuthPlugin() throws Throwable {
        Map<String, Object> authToken = this.authToken("neo4j", "neo4j", "plugin-TestCacheableAuthPlugin");
        TestCacheableAuthPlugin.getAuthInfoCallCount.set(0);
        this.restartNeo4jServerWithOverriddenSettings(settings -> settings.put(SecuritySettings.auth_cache_ttl, "60m"));
        this.assertConnectionSucceeds(authToken);
        MatcherAssert.assertThat((Object)TestCacheableAuthPlugin.getAuthInfoCallCount.get(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.assertReadSucceeds();
        this.assertWriteFails("neo4j", "reader");
        this.reconnect();
        this.assertConnectionSucceeds(authToken);
        MatcherAssert.assertThat((Object)TestCacheableAuthPlugin.getAuthInfoCallCount.get(), (Matcher)CoreMatchers.equalTo((Object)1));
        this.assertReadSucceeds();
        this.assertWriteFails("neo4j", "reader");
        this.reconnect();
        authToken.put("credentials", "wrong_password");
        this.assertConnectionFails(authToken);
        MatcherAssert.assertThat((Object)TestCacheableAuthPlugin.getAuthInfoCallCount.get(), (Matcher)CoreMatchers.equalTo((Object)1));
    }

    @Test
    public void shouldAuthenticateAndAuthorizeWithTestCombinedAuthPlugin() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(settings -> settings.put(SecuritySettings.auth_providers, "plugin-TestCombinedAuthPlugin"));
        this.assertConnectionSucceeds(this.authToken("neo4j", "neo4j", "plugin-TestCombinedAuthPlugin"));
        this.assertReadSucceeds();
        this.assertWriteFails("neo4j", "reader");
    }

    @Test
    public void shouldAuthenticateAndAuthorizeWithTwoSeparateTestPlugins() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(settings -> settings.put(SecuritySettings.auth_providers, "plugin-TestAuthenticationPlugin,plugin-TestAuthorizationPlugin"));
        this.assertConnectionSucceeds(this.authToken("neo4j", "neo4j", null));
        this.assertReadSucceeds();
        this.assertWriteFails("neo4j", "reader");
    }

    @Test
    public void shouldFailIfAuthorizationExpiredWithAuthPlugin() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(settings -> settings.put(SecuritySettings.auth_providers, "plugin-TestCacheableAdminAuthPlugin"));
        this.assertConnectionSucceeds(this.authToken("neo4j", "neo4j", "plugin-TestCacheableAdminAuthPlugin"));
        this.assertReadSucceeds();
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"CALL dbms.security.clearAuthCache()"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"MATCH (n) RETURN n"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.AuthorizationExpired, (String)"Plugin 'plugin-TestCacheableAdminAuthPlugin' authorization info expired.")}));
    }

    @Test
    public void shouldSucceedIfAuthorizationExpiredWithinTransactionWithAuthPlugin() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(settings -> settings.put(SecuritySettings.auth_providers, "plugin-TestCacheableAdminAuthPlugin"));
        this.assertConnectionSucceeds(this.authToken("neo4j", "neo4j", "plugin-TestCacheableAdminAuthPlugin"));
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"CALL dbms.security.clearAuthCache() MATCH (n) RETURN n"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgSuccess(), MessageMatchers.msgSuccess()}));
    }

    @Test
    public void shouldAuthenticateWithTestCustomParametersAuthenticationPlugin() throws Throwable {
        this.assertConnectionSucceeds(MapUtil.map((Object[])new Object[]{"scheme", "custom", "principal", "neo4j", "realm", "plugin-TestCustomParametersAuthenticationPlugin", "parameters", MapUtil.map((Object[])new Object[]{"my_credentials", Arrays.asList(1L, 2L, 3L, 4L)})}));
    }

    @Test
    public void shouldPassOnAuthorizationExpiredException() throws Throwable {
        this.restartNeo4jServerWithOverriddenSettings(settings -> settings.put(SecuritySettings.auth_providers, "plugin-TestCombinedAuthPlugin"));
        this.assertConnectionSucceeds(this.authToken("authorization_expired_user", "neo4j", null));
        this.client.send(TransportTestUtil.chunk((RequestMessage[])new RequestMessage[]{RunMessage.run((String)"MATCH (n) RETURN n"), PullAllMessage.pullAll()}));
        MatcherAssert.assertThat((Object)this.client, (Matcher)TransportTestUtil.eventuallyReceives((Matcher[])new Matcher[]{MessageMatchers.msgFailure((Status)Status.Security.AuthorizationExpired, (String)"Plugin 'plugin-TestCombinedAuthPlugin' authorization info expired: authorization_expired_user needs to re-authenticate.")}));
    }
}

