/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth.plugin;

import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.neo4j.server.security.enterprise.auth.plugin.api.AuthToken;
import org.neo4j.server.security.enterprise.auth.plugin.api.AuthenticationException;
import org.neo4j.server.security.enterprise.auth.plugin.spi.AuthInfo;
import org.neo4j.server.security.enterprise.auth.plugin.spi.AuthPlugin;

public class LdapGroupHasUsersAuthPlugin
extends AuthPlugin.Adapter {
    private static final String GROUP_SEARCH_BASE = "ou=groups,dc=example,dc=com";
    private static final String GROUP_SEARCH_FILTER = "(&(objectClass=posixGroup)(memberUid={0}))";
    public static final String GROUP_ID = "gidNumber";

    public String name() {
        return "ldap-alternative-groups";
    }

    public AuthInfo authenticateAndAuthorize(AuthToken authToken) throws AuthenticationException {
        try {
            String username = authToken.principal();
            char[] password = authToken.credentials();
            LdapContext ctx = this.authenticate(username, password);
            Set<String> roles = this.authorize(ctx, username);
            return AuthInfo.of((Object)username, roles);
        }
        catch (NamingException e) {
            throw new AuthenticationException(e.getMessage());
        }
    }

    private LdapContext authenticate(String username, char[] password) throws NamingException {
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://0.0.0.0:10389");
        env.put("java.naming.security.principal", String.format("cn=%s,ou=users,dc=example,dc=com", username));
        env.put("java.naming.security.credentials", password);
        return new InitialLdapContext(env, null);
    }

    private Set<String> authorize(LdapContext ctx, String username) throws NamingException {
        SearchResult searchResult;
        Attributes attributes;
        LinkedHashSet<String> roleNames = new LinkedHashSet<String>();
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        searchCtls.setReturningAttributes(new String[]{GROUP_ID});
        Object[] searchArguments = new Object[]{username};
        NamingEnumeration<SearchResult> result = ctx.search(GROUP_SEARCH_BASE, GROUP_SEARCH_FILTER, searchArguments, searchCtls);
        if (result.hasMoreElements() && (attributes = (searchResult = result.next()).getAttributes()) != null) {
            NamingEnumeration<? extends Attribute> attributeEnumeration = attributes.getAll();
            while (attributeEnumeration.hasMore()) {
                String groupId;
                String neo4jGroup;
                Attribute attribute = attributeEnumeration.next();
                String attributeId = attribute.getID();
                if (!attributeId.equalsIgnoreCase(GROUP_ID) || (neo4jGroup = this.getNeo4jRoleForGroupId(groupId = (String)attribute.get())) == null) continue;
                roleNames.add(neo4jGroup);
            }
        }
        return roleNames;
    }

    private String getNeo4jRoleForGroupId(String groupId) {
        if ("500".equals(groupId)) {
            return "reader";
        }
        if ("501".equals(groupId)) {
            return "publisher";
        }
        if ("502".equals(groupId)) {
            return "architect";
        }
        if ("503".equals(groupId)) {
            return "admin";
        }
        return null;
    }
}

