/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth.plugin;

import org.apache.shiro.crypto.hash.SimpleHash;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.server.security.enterprise.auth.SecureHasher;
import org.neo4j.server.security.enterprise.auth.plugin.PluginAuthenticationInfo;
import org.neo4j.server.security.enterprise.auth.plugin.spi.AuthenticationInfo;
import org.neo4j.server.security.enterprise.auth.plugin.spi.CacheableAuthenticationInfo;
import org.neo4j.server.security.enterprise.auth.plugin.spi.CustomCacheableAuthenticationInfo;

public class PluginAuthenticationInfoTest {
    @Test
    public void shouldCreateCorrectAuthenticationInfo() {
        PluginAuthenticationInfo internalAuthInfo = PluginAuthenticationInfo.createCacheable((AuthenticationInfo)AuthenticationInfo.of((Object)"thePrincipal"), (String)"theRealm", null);
        MatcherAssert.assertThat((Object)internalAuthInfo.getPrincipals().asList(), (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new String[]{"thePrincipal"}));
    }

    @Test
    public void shouldCreateCorrectAuthenticationInfoFromCacheable() {
        SecureHasher hasher = (SecureHasher)Mockito.mock(SecureHasher.class);
        Mockito.when((Object)hasher.hash((byte[])Matchers.any())).thenReturn((Object)new SimpleHash("some-hash"));
        PluginAuthenticationInfo internalAuthInfo = PluginAuthenticationInfo.createCacheable((AuthenticationInfo)CacheableAuthenticationInfo.of((Object)"thePrincipal", (byte[])new byte[]{1}), (String)"theRealm", (SecureHasher)hasher);
        MatcherAssert.assertThat((Object)internalAuthInfo.getPrincipals().asList(), (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new String[]{"thePrincipal"}));
    }

    @Test
    public void shouldCreateCorrectAuthenticationInfoFromCustomCacheable() {
        SecureHasher hasher = (SecureHasher)Mockito.mock(SecureHasher.class);
        Mockito.when((Object)hasher.hash((byte[])Matchers.any())).thenReturn((Object)new SimpleHash("some-hash"));
        PluginAuthenticationInfo internalAuthInfo = PluginAuthenticationInfo.createCacheable((AuthenticationInfo)CustomCacheableAuthenticationInfo.of((Object)"thePrincipal", ignoredAuthToken -> true), (String)"theRealm", (SecureHasher)hasher);
        MatcherAssert.assertThat((Object)internalAuthInfo.getPrincipals().asList(), (Matcher)org.hamcrest.Matchers.containsInAnyOrder((Object[])new String[]{"thePrincipal"}));
    }
}

