/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth.plugin;

import java.time.Clock;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.server.security.enterprise.auth.SecureHasher;
import org.neo4j.server.security.enterprise.auth.plugin.PluginRealm;
import org.neo4j.server.security.enterprise.auth.plugin.TestAuthPlugin;
import org.neo4j.server.security.enterprise.auth.plugin.TestAuthenticationPlugin;
import org.neo4j.server.security.enterprise.auth.plugin.TestAuthorizationPlugin;
import org.neo4j.server.security.enterprise.auth.plugin.api.AuthProviderOperations;
import org.neo4j.server.security.enterprise.auth.plugin.spi.AuthPlugin;
import org.neo4j.server.security.enterprise.auth.plugin.spi.AuthenticationPlugin;
import org.neo4j.server.security.enterprise.auth.plugin.spi.AuthorizationPlugin;
import org.neo4j.server.security.enterprise.log.SecurityLog;

public class PluginRealmTest {
    private Config config = (Config)Mockito.mock(Config.class);
    private AssertableLogProvider log = new AssertableLogProvider();
    private SecurityLog securityLog = new SecurityLog(this.log.getLog(this.getClass()));

    @Test
    public void shouldLogToSecurityLogFromAuthPlugin() throws Throwable {
        PluginRealm pluginRealm = new PluginRealm((AuthPlugin)new LoggingAuthPlugin(), this.config, this.securityLog, Clock.systemUTC(), (SecureHasher)Mockito.mock(SecureHasher.class));
        pluginRealm.initialize();
        this.assertLogged("LoggingAuthPlugin");
    }

    @Test
    public void shouldLogToSecurityLogFromAuthenticationPlugin() throws Throwable {
        PluginRealm pluginRealm = new PluginRealm((AuthenticationPlugin)new LoggingAuthenticationPlugin(), null, this.config, this.securityLog, Clock.systemUTC(), (SecureHasher)Mockito.mock(SecureHasher.class));
        pluginRealm.initialize();
        this.assertLogged("LoggingAuthenticationPlugin");
    }

    @Test
    public void shouldLogToSecurityLogFromAuthorizationPlugin() throws Throwable {
        PluginRealm pluginRealm = new PluginRealm(null, (AuthorizationPlugin)new LoggingAuthorizationPlugin(), this.config, this.securityLog, Clock.systemUTC(), (SecureHasher)Mockito.mock(SecureHasher.class));
        pluginRealm.initialize();
        this.assertLogged("LoggingAuthorizationPlugin");
    }

    private void assertLogged(String name) {
        this.log.assertExactly(new AssertableLogProvider.LogMatcher[]{AssertableLogProvider.inLog(this.getClass()).info(String.format("{plugin-%s} info line", name)), AssertableLogProvider.inLog(this.getClass()).warn(String.format("{plugin-%s} warn line", name)), AssertableLogProvider.inLog(this.getClass()).error(String.format("{plugin-%s} error line", name))});
    }

    private static void logLines(AuthProviderOperations api) throws Throwable {
        AuthProviderOperations.Log log = api.log();
        if (log.isDebugEnabled()) {
            log.debug("debug line");
        }
        log.info("info line");
        log.warn("warn line");
        log.error("error line");
    }

    private class LoggingAuthorizationPlugin
    extends TestAuthorizationPlugin {
        private LoggingAuthorizationPlugin() {
        }

        public void initialize(AuthProviderOperations api) throws Throwable {
            PluginRealmTest.logLines(api);
        }
    }

    private class LoggingAuthenticationPlugin
    extends TestAuthenticationPlugin {
        private LoggingAuthenticationPlugin() {
        }

        public void initialize(AuthProviderOperations api) throws Throwable {
            PluginRealmTest.logLines(api);
        }
    }

    private class LoggingAuthPlugin
    extends TestAuthPlugin {
        private LoggingAuthPlugin() {
        }

        public void initialize(AuthProviderOperations api) throws Throwable {
            PluginRealmTest.logLines(api);
        }
    }
}

