/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.auth.plugin;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.neo4j.server.security.enterprise.auth.plugin.api.AuthToken;
import org.neo4j.server.security.enterprise.auth.plugin.api.AuthorizationExpiredException;
import org.neo4j.server.security.enterprise.auth.plugin.spi.AuthenticationInfo;
import org.neo4j.server.security.enterprise.auth.plugin.spi.AuthenticationPlugin;
import org.neo4j.server.security.enterprise.auth.plugin.spi.AuthorizationInfo;
import org.neo4j.server.security.enterprise.auth.plugin.spi.AuthorizationPlugin;

public class TestCombinedAuthPlugin
extends AuthenticationPlugin.Adapter
implements AuthorizationPlugin {
    public String name() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public AuthenticationInfo authenticate(AuthToken authToken) {
        String principal = authToken.principal();
        char[] credentials = authToken.credentials();
        if (principal.equals("neo4j") && Arrays.equals(credentials, "neo4j".toCharArray())) {
            return AuthenticationInfo.of((Object)"neo4j");
        }
        if (principal.equals("authorization_expired_user") && Arrays.equals(credentials, "neo4j".toCharArray())) {
            return (AuthenticationInfo & Serializable)() -> "authorization_expired_user";
        }
        return null;
    }

    public AuthorizationInfo authorize(Collection<AuthorizationPlugin.PrincipalAndProvider> principals) {
        if (principals.stream().anyMatch(p -> "neo4j".equals(p.principal()))) {
            return (AuthorizationInfo & Serializable)() -> Collections.singleton("reader");
        }
        if (principals.stream().anyMatch(p -> "authorization_expired_user".equals(p.principal()))) {
            throw new AuthorizationExpiredException("authorization_expired_user needs to re-authenticate.");
        }
        return null;
    }
}

