/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.enterprise.log;

import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Level;
import org.neo4j.server.security.enterprise.configuration.SecuritySettings;
import org.neo4j.server.security.enterprise.log.SecurityLog;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class SecurityLogTest {
    @Rule
    public EphemeralFileSystemRule fileSystemRule = new EphemeralFileSystemRule();
    private Config config = Config.defaults().augment(MapUtil.stringMap((String[])new String[]{SecuritySettings.store_security_log_rotation_threshold.name(), "5", SecuritySettings.store_security_log_rotation_delay.name(), "1ms"}));

    @Test
    public void shouldRotateLog() throws IOException {
        SecurityLog securityLog = new SecurityLog(this.config, this.fileSystemRule.get(), Runnable::run);
        securityLog.info("line 1");
        securityLog.info("line 2");
        FileSystemAbstraction fs = this.fileSystemRule.get();
        File activeLogFile = (File)this.config.get(SecuritySettings.security_log_filename);
        MatcherAssert.assertThat((Object)fs.fileExists(activeLogFile), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)fs.fileExists(this.archive(1)), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)fs.fileExists(this.archive(2)), (Matcher)Matchers.equalTo((Object)false));
        String[] activeLines = this.readLogFile(fs, activeLogFile);
        MatcherAssert.assertThat((Object)activeLines, (Matcher)Matchers.array((Matcher[])new Matcher[]{Matchers.containsString((String)"line 2")}));
        String[] archiveLines = this.readLogFile(fs, this.archive(1));
        MatcherAssert.assertThat((Object)archiveLines, (Matcher)Matchers.array((Matcher[])new Matcher[]{Matchers.containsString((String)"line 1")}));
    }

    @Test
    public void shouldHonorLogLevel() throws Throwable {
        this.writeAllLevelsAndShutdown(this.withLogLevel(Level.DEBUG), "debug");
        this.writeAllLevelsAndShutdown(this.withLogLevel(Level.INFO), "info");
        this.writeAllLevelsAndShutdown(this.withLogLevel(Level.WARN), "warn");
        this.writeAllLevelsAndShutdown(this.withLogLevel(Level.ERROR), "error");
        FileSystemAbstraction fs = this.fileSystemRule.get();
        File activeLogFile = (File)this.config.get(SecuritySettings.security_log_filename);
        String[] activeLines = this.readLogFile(fs, activeLogFile);
        MatcherAssert.assertThat((Object)activeLines, (Matcher)Matchers.array((Matcher[])new Matcher[]{Matchers.containsString((String)"debug: debug line"), Matchers.containsString((String)"debug: info line"), Matchers.containsString((String)"debug: warn line"), Matchers.containsString((String)"debug: error line"), Matchers.containsString((String)"info: info line"), Matchers.containsString((String)"info: warn line"), Matchers.containsString((String)"info: error line"), Matchers.containsString((String)"warn: warn line"), Matchers.containsString((String)"warn: error line"), Matchers.containsString((String)"error: error line")}));
    }

    private void writeAllLevelsAndShutdown(SecurityLog securityLog, String tag) throws Throwable {
        securityLog.debug(String.format("%s: debug line", tag));
        securityLog.info(String.format("%s: info line", tag));
        securityLog.warn(String.format("%s: warn line", tag));
        securityLog.error(String.format("%s: error line", tag));
        securityLog.shutdown();
    }

    private SecurityLog withLogLevel(Level debug) throws IOException {
        return new SecurityLog(Config.defaults().augment(MapUtil.stringMap((String[])new String[]{SecuritySettings.security_log_level.name(), debug.name()})), this.fileSystemRule.get(), Runnable::run);
    }

    private String[] readLogFile(FileSystemAbstraction fs, File activeLogFile) throws IOException {
        Scanner scan = new Scanner(fs.openAsInputStream(activeLogFile));
        scan.useDelimiter("\\Z");
        String allLines = scan.next();
        scan.close();
        return allLines.split("\\n");
    }

    private File archive(int archiveNumber) {
        return new File(String.format("%s.%d", this.config.get(SecuritySettings.security_log_filename), archiveNumber));
    }
}

