/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.api.security.exception.IllegalCredentialsException;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.server.security.auth.User;
import org.neo4j.server.security.auth.UserRepository;
import org.neo4j.server.security.auth.exception.ConcurrentModificationException;

public class InMemoryUserRepository
extends LifecycleAdapter
implements UserRepository {
    private final ConcurrentHashMap<String, User> users = new ConcurrentHashMap();

    public User findByName(String name) {
        return this.users.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(User user) throws IllegalCredentialsException {
        InMemoryUserRepository inMemoryUserRepository = this;
        synchronized (inMemoryUserRepository) {
            for (User other : this.users.values()) {
                if (!other.name().equals(user.name())) continue;
                throw new IllegalCredentialsException("The specified user already exists");
            }
            this.users.put(user.name(), user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(User existingUser, User updatedUser) throws ConcurrentModificationException {
        if (!existingUser.name().equals(updatedUser.name())) {
            throw new IllegalArgumentException("updatedUser has a different name");
        }
        InMemoryUserRepository inMemoryUserRepository = this;
        synchronized (inMemoryUserRepository) {
            boolean foundUser = false;
            for (User other : this.users.values()) {
                if (!other.equals((Object)existingUser)) continue;
                foundUser = true;
            }
            if (!foundUser) {
                throw new ConcurrentModificationException();
            }
            this.users.put(updatedUser.name(), updatedUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(User user) {
        InMemoryUserRepository inMemoryUserRepository = this;
        synchronized (inMemoryUserRepository) {
            return this.users.remove(user.name()) != null;
        }
    }

    public int numberOfUsers() {
        return this.users.size();
    }

    public boolean isValidName(String name) {
        return true;
    }
}

