/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.shell.AbstractShellIT;
import org.neo4j.shell.StartClient;

public class ErrorsAndWarningsIT
extends AbstractShellIT {
    @Before
    public void setup() throws Exception {
        this.makeServerRemotelyAvailable();
    }

    @Test
    public void unsupportedQueryShouldBeSilent() throws IOException {
        InputStream realStdin = System.in;
        try {
            System.setIn(new ByteArrayInputStream("CYPHER planner=cost CREATE ();".getBytes()));
            String output = this.runAndCaptureOutput(new String[]{"-file", "-"});
            Assert.assertThat((Object)output, (Matcher)Matchers.not((Matcher)CoreMatchers.containsString((String)"Using COST planner is unsupported for this query, please use RULE planner instead")));
        }
        finally {
            System.setIn(realStdin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runAndCaptureOutput(String[] arguments) {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(buf);
        PrintStream oldOut = System.out;
        System.setOut(out);
        try {
            StartClient.main((String[])arguments);
            out.close();
            String string = buf.toString();
            return string;
        }
        finally {
            System.setOut(oldOut);
        }
    }
}

