/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.neo4j.function.Predicates;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.shell.ShellSettings;

public class FreePortIT {
    private static final String HOST = "localhost";
    private static final int PORT = 13463;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    public GraphDatabaseService initialize() throws IOException {
        GraphDatabaseService db = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.temporaryFolder.newFolder()).setConfig(ShellSettings.remote_shell_enabled, "true").setConfig(ShellSettings.remote_shell_host, HOST).setConfig(ShellSettings.remote_shell_port, Integer.toString(13463)).newGraphDatabase();
        return db;
    }

    private boolean portAvailable() {
        return this.portAvailable(HOST, 13463);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean portAvailable(String host, int port) {
        ServerSocket s = null;
        try {
            s = new ServerSocket();
            s.bind(new InetSocketAddress(host, port));
            boolean bl = s.isBound();
            return bl;
        }
        catch (Throwable throwable) {
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    @Test
    public void testPort() throws Exception {
        Assert.assertTrue((boolean)this.portAvailable());
        GraphDatabaseService db = this.initialize();
        Assert.assertTrue((boolean)db.isAvailable(TimeUnit.SECONDS.toMillis(5L)));
        Assert.assertFalse((boolean)this.portAvailable());
        db.shutdown();
        Predicates.await(this::portAvailable, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        Assert.assertTrue((boolean)this.portAvailable());
    }
}

