/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.shell.Output;
import org.neo4j.shell.OutputAsWriter;
import org.neo4j.shell.impl.SystemOutput;

public class OutputAsWriterTest {
    private PrintStream out;
    private ByteArrayOutputStream buffer;
    private SystemOutput output;
    private OutputAsWriter writer;

    @Before
    public void setUp() throws Exception {
        this.out = System.out;
        this.buffer = new ByteArrayOutputStream();
        System.setOut(new PrintStream(this.buffer));
        this.output = new SystemOutput();
        this.writer = new OutputAsWriter((Output)this.output);
    }

    @After
    public void tearDown() throws Exception {
        System.setOut(this.out);
    }

    @Test
    public void shouldNotFlushWithoutNewline() throws Exception {
        this.writer.write("foo".toCharArray());
        Assert.assertEquals((long)0L, (long)this.buffer.size());
    }

    @Test
    public void shouldFlushWithNewline() throws Exception {
        String s = String.format("foobar%n", new Object[0]);
        this.writer.write(s.toCharArray());
        Assert.assertEquals((long)s.length(), (long)this.buffer.size());
        Assert.assertEquals((Object)s, (Object)this.buffer.toString());
    }

    @Test
    public void shouldFlushPartiallyWithNewlineInMiddle() throws Exception {
        String firstPart = String.format("foo%n", new Object[0]);
        String secondPart = "bar";
        String string = firstPart + secondPart;
        String newLine = String.format("%n", new Object[0]);
        String fullString = string + newLine;
        this.writer.write(string.toCharArray());
        Assert.assertEquals((long)firstPart.length(), (long)this.buffer.size());
        Assert.assertEquals((Object)firstPart, (Object)this.buffer.toString());
        this.writer.write(newLine.toCharArray());
        Assert.assertEquals((long)fullString.length(), (long)this.buffer.size());
        Assert.assertEquals((Object)fullString, (Object)this.buffer.toString());
    }
}

