/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.slf4j;

import java.util.ArrayList;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.logging.Log;
import org.neo4j.logging.slf4j.AccumulatingAppender;
import org.neo4j.logging.slf4j.Slf4jLogProvider;

public class Slf4jLogProviderTest {
    Slf4jLogProvider logProvider = new Slf4jLogProvider();

    @Before
    public void clearLoggingEventsAccumulator() {
        this.getAccumulatingAppender().clearEventsList();
    }

    @Test
    public void shouldLogDebug() {
        Log log = this.logProvider.getLog(this.getClass());
        log.debug("Holy debug batman!");
        this.assertLogOccurred(Level.DEBUG, "Holy debug batman!");
    }

    @Test
    public void shouldLogInfo() {
        Log log = this.logProvider.getLog(this.getClass());
        log.info("Holy info batman!");
        this.assertLogOccurred(Level.INFO, "Holy info batman!");
    }

    @Test
    public void shouldLogWarning() {
        Log log = this.logProvider.getLog(this.getClass());
        log.warn("Holy warning batman!");
        this.assertLogOccurred(Level.WARN, "Holy warning batman!");
    }

    @Test
    public void shouldLogError() {
        Log log = this.logProvider.getLog(this.getClass());
        log.error("Holy error batman!");
        this.assertLogOccurred(Level.ERROR, "Holy error batman!");
    }

    private void assertLogOccurred(Level level, String message) {
        ArrayList<LoggingEvent> events = this.getLoggingEvents();
        MatcherAssert.assertThat(events, (Matcher)IsCollectionWithSize.hasSize((int)1));
        LoggingEvent event = events.get(0);
        MatcherAssert.assertThat((Object)event.getLoggerName(), (Matcher)Is.is((Object)this.getClass().getName()));
        MatcherAssert.assertThat((Object)event.getLevel(), (Matcher)Is.is((Object)level));
        MatcherAssert.assertThat((Object)event.getMessage(), (Matcher)Is.is((Object)message));
    }

    private ArrayList<LoggingEvent> getLoggingEvents() {
        return this.getAccumulatingAppender().getEventsList();
    }

    private AccumulatingAppender getAccumulatingAppender() {
        return (AccumulatingAppender)Logger.getRootLogger().getAppender("accumulating");
    }
}

