/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.index.curves;

import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveMonitor;

public class HistogramMonitor
implements SpaceFillingCurveMonitor {
    private int[] counts;
    private int highestDepth;
    private long searchArea;
    private long coveredArea;

    HistogramMonitor(int maxLevel) {
        this.counts = new int[maxLevel + 1];
    }

    public void addRangeAtDepth(int depth) {
        int n = depth;
        this.counts[n] = this.counts[n] + 1;
        if (depth > this.highestDepth) {
            this.highestDepth = depth;
        }
    }

    public void registerSearchArea(long size) {
        this.searchArea = size;
    }

    public void addToCoveredArea(long size) {
        this.coveredArea += size;
    }

    int[] getCounts() {
        return this.counts;
    }

    long getSearchArea() {
        return this.searchArea;
    }

    long getCoveredArea() {
        return this.coveredArea;
    }

    int getHighestDepth() {
        return this.highestDepth;
    }
}

