/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.index.curves;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.neo4j.gis.spatial.index.Envelope;
import org.neo4j.gis.spatial.index.curves.PartialOverlapConfiguration;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;

class SpaceFillingCurveConfigurationTest {
    SpaceFillingCurveConfigurationTest() {
    }

    @Test
    void shouldHandleMaxDepthWithEmptySearchArea() {
        StandardConfiguration standardConfiguration = new StandardConfiguration();
        PartialOverlapConfiguration partialOverlapConf = new PartialOverlapConfiguration();
        Envelope search = new Envelope(-180.0, -180.0, -90.0, 90.0);
        Envelope range = new Envelope(-180.0, 180.0, -90.0, 90.0);
        int maxLevel = 20;
        MatcherAssert.assertThat((Object)partialOverlapConf.maxDepth(search, range, 2, 30), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(maxLevel)));
        MatcherAssert.assertThat((Object)standardConfiguration.maxDepth(search, range, 2, 30), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(maxLevel)));
    }

    @Test
    void shouldReturnMaxDepth1WithWholeSearchArea() {
        StandardConfiguration standardConfiguration = new StandardConfiguration();
        PartialOverlapConfiguration partialOverlapConf = new PartialOverlapConfiguration();
        Envelope range = new Envelope(-180.0, 180.0, -90.0, 90.0);
        MatcherAssert.assertThat((Object)partialOverlapConf.maxDepth(range, range, 2, 30), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)standardConfiguration.maxDepth(range, range, 2, 30), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    void shouldReturnMaxDepth2WithQuarterOfWholeArea() {
        StandardConfiguration standardConfiguration = new StandardConfiguration();
        PartialOverlapConfiguration partialOverlapConf = new PartialOverlapConfiguration();
        Envelope range = new Envelope(-180.0, 180.0, -90.0, 90.0);
        Envelope search = new Envelope(0.0, 180.0, 0.0, 90.0);
        MatcherAssert.assertThat((Object)partialOverlapConf.maxDepth(search, range, 2, 30), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)standardConfiguration.maxDepth(search, range, 2, 30), (Matcher)Matchers.equalTo((Object)2));
    }

    @Test
    void shouldReturnAppropriateDepth() {
        int maxLevel = 30;
        for (int i = 0; i < 30; ++i) {
            StandardConfiguration standardConfiguration = new StandardConfiguration();
            PartialOverlapConfiguration partialOverlapConf = new PartialOverlapConfiguration();
            Envelope range = new Envelope(0.0, 1.0, 0.0, 1.0);
            Envelope search = new Envelope(0.0, Math.pow(2.0, -i), 0.0, Math.pow(2.0, -i));
            MatcherAssert.assertThat((Object)partialOverlapConf.maxDepth(search, range, 2, 30), (Matcher)Matchers.equalTo((Object)(i + 1)));
            MatcherAssert.assertThat((Object)standardConfiguration.maxDepth(search, range, 2, 30), (Matcher)Matchers.equalTo((Object)(i + 1)));
        }
    }
}

