/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gis.spatial.index.curves;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.neo4j.gis.spatial.index.Envelope;
import org.neo4j.gis.spatial.index.curves.HilbertSpaceFillingCurve2D;
import org.neo4j.gis.spatial.index.curves.HilbertSpaceFillingCurve3D;
import org.neo4j.gis.spatial.index.curves.HistogramMonitor;
import org.neo4j.gis.spatial.index.curves.PartialOverlapConfiguration;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurve;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveMonitor;
import org.neo4j.gis.spatial.index.curves.StandardConfiguration;
import org.neo4j.gis.spatial.index.curves.TraverseToBottomConfiguration;
import org.neo4j.gis.spatial.index.curves.ZOrderSpaceFillingCurve2D;
import org.neo4j.logging.FormattedLog;
import org.neo4j.logging.Level;

public class SpaceFillingCurveTest {
    private static final boolean debug = false;
    private FormattedLog logger;

    @BeforeEach
    void setUp() {
        this.logger = FormattedLog.withLogLevel((Level)Level.NONE).toOutputStream((OutputStream)System.out);
    }

    @Test
    void shouldCreateSimple2DZOrderCurveAtLevel1() {
        Envelope envelope = new Envelope(-8.0, 8.0, -8.0, 8.0);
        ZOrderSpaceFillingCurve2D curve = new ZOrderSpaceFillingCurve2D(envelope, 1);
        SpaceFillingCurveTest.assertAtLevel(curve, envelope);
        SpaceFillingCurveTest.assertRange("Bottom-left should evaluate to zero", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 2, 0, 1), 0L);
        SpaceFillingCurveTest.assertRange("Top-left should evaluate to one", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 2, 1, 1), 1L);
        SpaceFillingCurveTest.assertRange("Top-right should evaluate to two", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 2, 0, 0), 2L);
        SpaceFillingCurveTest.assertRange("Bottom-right should evaluate to three", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 2, 1, 0), 3L);
    }

    @Test
    void shouldCreateSimple2DZOrderCurveAtLevel2() {
        Envelope envelope = new Envelope(-8.0, 8.0, -8.0, 8.0);
        ZOrderSpaceFillingCurve2D curve = new ZOrderSpaceFillingCurve2D(envelope, 2);
        SpaceFillingCurveTest.assertAtLevel(curve, envelope);
        SpaceFillingCurveTest.assertRange("'00' should evaluate to 0", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 0, 3), 0L);
        SpaceFillingCurveTest.assertRange("'10' should evaluate to 1", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 1, 3), 1L);
        SpaceFillingCurveTest.assertRange("'11' should evaluate to 2", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 0, 2), 2L);
        SpaceFillingCurveTest.assertRange("'01' should evaluate to 3", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 1, 2), 3L);
        SpaceFillingCurveTest.assertRange("'02' should evaluate to 4", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 2, 3), 4L);
        SpaceFillingCurveTest.assertRange("'03' should evaluate to 5", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 3, 3), 5L);
        SpaceFillingCurveTest.assertRange("'13' should evaluate to 6", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 2, 2), 6L);
        SpaceFillingCurveTest.assertRange("'12' should evaluate to 7", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 3, 2), 7L);
        SpaceFillingCurveTest.assertRange("'22' should evaluate to 8", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 0, 1), 8L);
        SpaceFillingCurveTest.assertRange("'23' should evaluate to 9", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 1, 1), 9L);
        SpaceFillingCurveTest.assertRange("'33' should evaluate to 10", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 0, 0), 10L);
        SpaceFillingCurveTest.assertRange("'32' should evaluate to 11", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 1, 0), 11L);
        SpaceFillingCurveTest.assertRange("'31' should evaluate to 12", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 2, 1), 12L);
        SpaceFillingCurveTest.assertRange("'21' should evaluate to 13", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 3, 1), 13L);
        SpaceFillingCurveTest.assertRange("'20' should evaluate to 14", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 2, 0), 14L);
        SpaceFillingCurveTest.assertRange("'30' should evaluate to 15", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 3, 0), 15L);
    }

    @Test
    void shouldCreateSimple2DZOrderCurveAtLevel3() {
        Envelope envelope = new Envelope(-8.0, 8.0, -8.0, 8.0);
        SpaceFillingCurveTest.assertAtLevel(new ZOrderSpaceFillingCurve2D(envelope, 3), envelope);
    }

    @Test
    void shouldCreateSimple2DZOrderCurveAtLevel4() {
        Envelope envelope = new Envelope(-8.0, 8.0, -8.0, 8.0);
        SpaceFillingCurveTest.assertAtLevel(new ZOrderSpaceFillingCurve2D(envelope, 4), envelope);
    }

    @Test
    void shouldCreateSimple2DZOrderCurveAtLevel5() {
        Envelope envelope = new Envelope(-8.0, 8.0, -8.0, 8.0);
        SpaceFillingCurveTest.assertAtLevel(new ZOrderSpaceFillingCurve2D(envelope, 5), envelope);
    }

    @Test
    void shouldCreateSimple2DZOrderCurveAtLevel24() {
        Envelope envelope = new Envelope(-8.0, 8.0, -8.0, 8.0);
        SpaceFillingCurveTest.assertAtLevel(new ZOrderSpaceFillingCurve2D(envelope, 24), envelope);
    }

    @Test
    void shouldCreateSimple2DZOrderCurveAtManyLevels() {
        Envelope envelope = new Envelope(new double[]{-8.0, -8.0}, new double[]{8.0, 8.0});
        for (int level = 1; level <= 30; ++level) {
            ZOrderSpaceFillingCurve2D curve = new ZOrderSpaceFillingCurve2D(envelope, level);
            this.logger.debug("Max value at level " + level + ": " + curve.getValueWidth());
            SpaceFillingCurveTest.assertAtLevel(curve, envelope);
            SpaceFillingCurveTest.assertRange((int)curve.getWidth(), 0L, curve, 0, (int)curve.getWidth() - 1);
            SpaceFillingCurveTest.assertRange((int)curve.getWidth(), curve.getValueWidth() - 1L, curve, (int)curve.getWidth() - 1, 0);
        }
    }

    @Test
    void shouldCreateSimple2DZOrderCurveAtLevelDefault() {
        Envelope envelope = new Envelope(-8.0, 8.0, -8.0, 8.0);
        SpaceFillingCurveTest.assertAtLevel(new ZOrderSpaceFillingCurve2D(envelope), envelope);
    }

    @Test
    void shouldCreate2DZOrderCurveWithRectangularEnvelope() {
        SpaceFillingCurveTest.assert2DAtLevel(new Envelope(-8.0, 8.0, -20.0, 20.0), 3);
    }

    @Test
    void shouldCreate2DZOrderCurveWithNonCenteredEnvelope() {
        SpaceFillingCurveTest.assert2DAtLevel(new Envelope(2.0, 7.0, 2.0, 7.0), 3);
    }

    @Test
    void shouldWorkWithNormalGPSCoordinatesZOrder() {
        Envelope envelope = new Envelope(-180.0, 180.0, -90.0, 90.0);
        ZOrderSpaceFillingCurve2D curve = new ZOrderSpaceFillingCurve2D(envelope);
        SpaceFillingCurveTest.assertAtLevel(curve, envelope);
    }

    @Test
    void shouldGet2DZOrderSearchTilesForManyLevels() {
        Envelope envelope = new Envelope(-8.0, 8.0, -8.0, 8.0);
        for (int level = 1; level <= 30; ++level) {
            ZOrderSpaceFillingCurve2D curve = new ZOrderSpaceFillingCurve2D(envelope, level);
            double halfTile = curve.getTileWidth(0, level) / 2.0;
            long start = System.currentTimeMillis();
            SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(-8.0, -8.0 + halfTile, 8.0 - halfTile, 8.0)), new SpaceFillingCurve.LongRange(0L, 0L));
            SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(8.0 - halfTile, 8.0, -8.0, -8.0 + halfTile)), new SpaceFillingCurve.LongRange(curve.getValueWidth() - 1L, curve.getValueWidth() - 1L));
            SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(8.0 - halfTile, 8.0, 0.0, 0.0 + halfTile)), new SpaceFillingCurve.LongRange(curve.getValueWidth() / 2L - 1L, curve.getValueWidth() / 2L - 1L));
            this.logger.debug("Hilbert query at level " + level + " took " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    @Test
    void shouldCreateSimple2DHilbertCurveAtLevel1() {
        Envelope envelope = new Envelope(-8.0, 8.0, -8.0, 8.0);
        HilbertSpaceFillingCurve2D curve = new HilbertSpaceFillingCurve2D(envelope, 1);
        SpaceFillingCurveTest.assertAtLevel(curve, envelope);
        SpaceFillingCurveTest.assertRange("Bottom-left should evaluate to zero", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 2, 0, 0), 0L);
        SpaceFillingCurveTest.assertRange("Top-left should evaluate to one", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 2, 0, 1), 1L);
        SpaceFillingCurveTest.assertRange("Top-right should evaluate to two", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 2, 1, 1), 2L);
        SpaceFillingCurveTest.assertRange("Bottom-right should evaluate to three", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 2, 1, 0), 3L);
    }

    @Test
    void shouldCreateSimple2DHilbertCurveAtLevel2() {
        Envelope envelope = new Envelope(-8.0, 8.0, -8.0, 8.0);
        HilbertSpaceFillingCurve2D curve = new HilbertSpaceFillingCurve2D(envelope, 2);
        SpaceFillingCurveTest.assertAtLevel(curve, envelope);
        SpaceFillingCurveTest.assertRange("'00' should evaluate to 0", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 0, 0), 0L);
        SpaceFillingCurveTest.assertRange("'10' should evaluate to 1", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 1, 0), 1L);
        SpaceFillingCurveTest.assertRange("'11' should evaluate to 2", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 1, 1), 2L);
        SpaceFillingCurveTest.assertRange("'01' should evaluate to 3", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 0, 1), 3L);
        SpaceFillingCurveTest.assertRange("'02' should evaluate to 4", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 0, 2), 4L);
        SpaceFillingCurveTest.assertRange("'03' should evaluate to 5", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 0, 3), 5L);
        SpaceFillingCurveTest.assertRange("'13' should evaluate to 6", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 1, 3), 6L);
        SpaceFillingCurveTest.assertRange("'12' should evaluate to 7", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 1, 2), 7L);
        SpaceFillingCurveTest.assertRange("'22' should evaluate to 8", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 2, 2), 8L);
        SpaceFillingCurveTest.assertRange("'23' should evaluate to 9", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 2, 3), 9L);
        SpaceFillingCurveTest.assertRange("'33' should evaluate to 10", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 3, 3), 10L);
        SpaceFillingCurveTest.assertRange("'32' should evaluate to 11", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 3, 2), 11L);
        SpaceFillingCurveTest.assertRange("'31' should evaluate to 12", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 3, 1), 12L);
        SpaceFillingCurveTest.assertRange("'21' should evaluate to 13", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 2, 1), 13L);
        SpaceFillingCurveTest.assertRange("'20' should evaluate to 14", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 2, 0), 14L);
        SpaceFillingCurveTest.assertRange("'30' should evaluate to 15", curve, SpaceFillingCurveTest.getTileEnvelope(envelope, 4, 3, 0), 15L);
    }

    @Test
    void shouldCreateSimple2DHilbertCurveAtLevel3() {
        SpaceFillingCurveTest.assert2DAtLevel(new Envelope(-8.0, 8.0, -8.0, 8.0), 3);
    }

    @Test
    void shouldCreateSimple2DHilbertCurveAtLevel4() {
        SpaceFillingCurveTest.assert2DAtLevel(new Envelope(-8.0, 8.0, -8.0, 8.0), 4);
    }

    @Test
    void shouldCreateSimple2DHilbertCurveAtLevel5() {
        SpaceFillingCurveTest.assert2DAtLevel(new Envelope(-8.0, 8.0, -8.0, 8.0), 5);
    }

    @Test
    void shouldCreateSimple2DHilbertCurveAtLevel24() {
        SpaceFillingCurveTest.assert2DAtLevel(new Envelope(-8.0, 8.0, -8.0, 8.0), 24);
    }

    @Test
    void shouldCreateSimple2DHilbertCurveAtManyLevels() {
        Envelope envelope = new Envelope(new double[]{-8.0, -8.0}, new double[]{8.0, 8.0});
        for (int level = 1; level <= 30; ++level) {
            HilbertSpaceFillingCurve2D curve = new HilbertSpaceFillingCurve2D(envelope, level);
            this.logger.debug("Max value at level " + level + ": " + curve.getValueWidth());
            SpaceFillingCurveTest.assertAtLevel(curve, envelope);
            SpaceFillingCurveTest.assertRange((int)curve.getWidth(), 0L, curve, 0, 0);
            SpaceFillingCurveTest.assertRange((int)curve.getWidth(), curve.getValueWidth() - 1L, curve, (int)curve.getWidth() - 1, 0);
        }
    }

    @Test
    void shouldCreateSimple2DHilbertCurveAtLevelDefault() {
        Envelope envelope = new Envelope(-8.0, 8.0, -8.0, 8.0);
        SpaceFillingCurveTest.assertAtLevel(new HilbertSpaceFillingCurve2D(envelope), envelope);
    }

    @Test
    void shouldCreate2DHilbertCurveWithRectangularEnvelope() {
        SpaceFillingCurveTest.assert2DAtLevel(new Envelope(-8.0, 8.0, -20.0, 20.0), 3);
    }

    @Test
    void shouldCreate2DHilbertCurveWithNonCenteredEnvelope() {
        SpaceFillingCurveTest.assert2DAtLevel(new Envelope(2.0, 7.0, 2.0, 7.0), 3);
    }

    @Test
    void shouldCreate2DHilbertCurveOfThreeLevelsFromExampleInThePaper() {
        HilbertSpaceFillingCurve2D curve = new HilbertSpaceFillingCurve2D(new Envelope(0.0, 8.0, 0.0, 8.0), 3);
        MatcherAssert.assertThat((String)"Example should evaluate to 101110", (Object)curve.derivedValueFor(new double[]{6.0, 4.0}), (Matcher)Matchers.equalTo((Object)46L));
    }

    @Test
    void shouldWorkWithNormalGPSCoordinatesHilbert() {
        Envelope envelope = new Envelope(-180.0, 180.0, -90.0, 90.0);
        HilbertSpaceFillingCurve2D curve = new HilbertSpaceFillingCurve2D(envelope);
        SpaceFillingCurveTest.assertAtLevel(curve, envelope);
    }

    @Test
    void shouldGet2DHilbertSearchTilesForLevel1() {
        Envelope envelope = new Envelope(-8.0, 8.0, -8.0, 8.0);
        HilbertSpaceFillingCurve2D curve = new HilbertSpaceFillingCurve2D(envelope, 1);
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(-6.0, -5.0, -6.0, -5.0)), new SpaceFillingCurve.LongRange(0L, 0L));
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(0.0, 6.0, -6.0, -5.0)), new SpaceFillingCurve.LongRange(3L, 3L));
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(-6.0, 4.0, -5.0, -2.0)), new SpaceFillingCurve.LongRange(0L, 0L), new SpaceFillingCurve.LongRange(3L, 3L));
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(-2.0, -1.0, -6.0, 5.0)), new SpaceFillingCurve.LongRange(0L, 1L));
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(-2.0, 1.0, -6.0, 5.0)), new SpaceFillingCurve.LongRange(0L, 3L));
    }

    @Test
    void shouldGet2DHilbertSearchTilesForLevel2() {
        Envelope envelope = new Envelope(-8.0, 8.0, -8.0, 8.0);
        HilbertSpaceFillingCurve2D curve = new HilbertSpaceFillingCurve2D(envelope, 2);
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(-6.0, -5.0, -6.0, -5.0)), new SpaceFillingCurve.LongRange(0L, 0L));
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(0.0, 6.0, -6.0, -5.0)), new SpaceFillingCurve.LongRange(14L, 15L));
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(-6.0, 4.0, -5.0, -2.0)), new SpaceFillingCurve.LongRange(0L, 3L), new SpaceFillingCurve.LongRange(12L, 15L));
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(-2.0, -1.0, -6.0, 5.0)), new SpaceFillingCurve.LongRange(1L, 2L), new SpaceFillingCurve.LongRange(6L, 7L));
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(-2.0, 1.0, -6.0, 5.0)), new SpaceFillingCurve.LongRange(1L, 2L), new SpaceFillingCurve.LongRange(6L, 9L), new SpaceFillingCurve.LongRange(13L, 14L));
    }

    @Test
    void shouldGet2DHilbertSearchTilesForLevel3() {
        Envelope envelope = new Envelope(-8.0, 8.0, -8.0, 8.0);
        HilbertSpaceFillingCurve2D curve = new HilbertSpaceFillingCurve2D(envelope, 3);
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(-8.0, -7.0, -8.0, -7.0)), new SpaceFillingCurve.LongRange(0L, 0L));
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(0.0, 1.0, 0.0, 1.0)), new SpaceFillingCurve.LongRange(32L, 32L));
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(7.0, 8.0, -8.0, -1.0)), new SpaceFillingCurve.LongRange(48L, 49L), new SpaceFillingCurve.LongRange(62L, 63L));
    }

    @Test
    void shouldGet2DHilbertSearchTilesForManyLevels() {
        Envelope envelope = new Envelope(-8.0, 8.0, -8.0, 8.0);
        for (int level = 1; level <= 30; ++level) {
            HilbertSpaceFillingCurve2D curve = new HilbertSpaceFillingCurve2D(envelope, level);
            double halfTile = curve.getTileWidth(0, level) / 2.0;
            long start = System.currentTimeMillis();
            SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(-8.0, -8.0 + halfTile, -8.0, -8.0 + halfTile)), new SpaceFillingCurve.LongRange(0L, 0L));
            SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(8.0 - halfTile, 8.0, -8.0, -8.0 + halfTile)), new SpaceFillingCurve.LongRange(curve.getValueWidth() - 1L, curve.getValueWidth() - 1L));
            SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(0.0, halfTile, 0.0, halfTile)), new SpaceFillingCurve.LongRange(curve.getValueWidth() / 2L, curve.getValueWidth() / 2L));
            this.logger.debug("Hilbert query at level " + level + " took " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    @Test
    void shouldGet2DHilbertSearchTilesForWideRangeAtManyLevels() {
        int xmin = -100;
        int xmax = 100;
        int ymin = -100;
        int ymax = 100;
        Envelope envelope = new Envelope(-100.0, 100.0, -100.0, 100.0);
        for (int level = 1; level <= 30; ++level) {
            HilbertSpaceFillingCurve2D curve = new HilbertSpaceFillingCurve2D(envelope, level);
            boolean delta = true;
            boolean xhalf = false;
            boolean yhalf = false;
            Envelope q1 = new Envelope(-100.0, -1.0, -100.0, -1.0);
            Envelope q2 = new Envelope(-100.0, -1.0, 0.0, 100.0);
            Envelope q3 = new Envelope(0.0, 100.0, 0.0, 100.0);
            Envelope q4 = new Envelope(0.0, 100.0, -100.0, -1.0);
            SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(q1), new SpaceFillingCurve.LongRange(0L, curve.getValueWidth() / 4L - 1L));
            SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(q2), new SpaceFillingCurve.LongRange(curve.getValueWidth() / 4L, curve.getValueWidth() / 2L - 1L));
            SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(q3), new SpaceFillingCurve.LongRange(curve.getValueWidth() / 2L, 3L * curve.getValueWidth() / 4L - 1L));
            SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(q4), new SpaceFillingCurve.LongRange(3L * curve.getValueWidth() / 4L, curve.getValueWidth() - 1L));
        }
    }

    @Test
    void shouldHaveReasonableCoveredArea() {
        double minExtent = 1.0E-6;
        double maxAspect = 100.0;
        int xmin = -100;
        int xmax = 100;
        int ymin = -100;
        int ymax = 100;
        double rectangleStepsPerDimension = 9.789;
        double extensionFactor = 5.0;
        String formatHeader1 = "Level  Depth Limitation Configuration                  Area Ratio              Ranges                  Depth";
        String formatHeader2 = "                                                        avg    min    max       avg    min    max       avg    min    max";
        String formatBody = "%5d  %-42s   %7.2f%7.2f%7.2f   %7.2f%7d%7d   %7.2f%7d%7d";
        Envelope envelope = new Envelope(-100.0, 100.0, -100.0, 100.0);
        for (int level = 1; level <= 30; ++level) {
            for (SpaceFillingCurveConfiguration config : new SpaceFillingCurveConfiguration[]{new StandardConfiguration(1), new StandardConfiguration(2), new StandardConfiguration(3), new StandardConfiguration(4), new PartialOverlapConfiguration(1, 0.99, 0.1), new PartialOverlapConfiguration(1, 0.99, 0.5), new PartialOverlapConfiguration(2, 0.99, 0.1), new PartialOverlapConfiguration(2, 0.99, 0.5), new PartialOverlapConfiguration(3, 0.99, 0.1), new PartialOverlapConfiguration(3, 0.99, 0.5), new PartialOverlapConfiguration(4, 0.99, 0.1), new PartialOverlapConfiguration(4, 0.99, 0.5)}) {
                MonitorDoubleStats areaStats = new MonitorDoubleStats();
                MonitorStats rangeStats = new MonitorStats();
                MonitorStats maxDepthStats = new MonitorStats();
                HilbertSpaceFillingCurve2D curve = new HilbertSpaceFillingCurve2D(envelope, level);
                for (double xExtent = 1.0E-6; xExtent <= 100.0; xExtent *= 5.0) {
                    for (double yExtent = 1.0E-6; yExtent <= 100.0; yExtent *= 5.0) {
                        double aspect;
                        double d = aspect = xExtent > yExtent ? xExtent / yExtent : yExtent / xExtent;
                        if (!(aspect < 100.0)) continue;
                        double xOffset = 0.0;
                        while (-100.0 + xOffset + xExtent <= 100.0) {
                            double yOffset = 0.0;
                            while (-100.0 + yOffset + yExtent <= 100.0) {
                                HistogramMonitor monitor = new HistogramMonitor(curve.getMaxLevel());
                                double xStart = -100.0 + xOffset;
                                double xEnd = xStart + xExtent;
                                double yStart = -100.0 + yOffset;
                                double yEnd = yStart + yExtent;
                                Envelope searchEnvelope = new Envelope(xStart, xEnd, yStart, yEnd);
                                long start = System.currentTimeMillis();
                                List ranges = curve.getTilesIntersectingEnvelope(searchEnvelope, config, (SpaceFillingCurveMonitor)monitor);
                                MatcherAssert.assertThat((Object)ranges, (Matcher)Matchers.not((Matcher)Matchers.empty()));
                                MatcherAssert.assertThat((String)String.format("Search size was bigger than covered size for level %d, with x=[%a,%a] y=[%a,%a]", level, xStart, xEnd, yStart, yEnd), (Object)monitor.getSearchArea(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(monitor.getCoveredArea())));
                                yOffset += (200.0 - yExtent) / 9.789;
                            }
                            xOffset += (200.0 - xExtent) / 9.789;
                        }
                    }
                }
            }
        }
    }

    @Test
    void shouldHaveReasonableCoveredVolume() {
        double minExtent = 1.0E-6;
        double maxAspect = 100.0;
        Envelope envelope = new Envelope(new double[]{-100.0, -100.0, -100.0}, new double[]{100.0, 100.0, 100.0});
        double rectangleStepsPerDimension = 3.789;
        double extensionFactor = 8.0;
        String formatHeader1 = "Level  Depth Limitation Configuration                  Area Ratio              Ranges                  Depth";
        String formatHeader2 = "                                                        avg    min    max       avg    min    max       avg    min    max";
        String formatBody = "%5d  %-42s   %7.2f%7.2f%7.2f   %7.2f%7d%7d   %7.2f%7d%7d";
        for (int level = 7; level <= 20; level += 3) {
            for (SpaceFillingCurveConfiguration config : new SpaceFillingCurveConfiguration[]{new StandardConfiguration(1), new StandardConfiguration(2), new StandardConfiguration(3), new StandardConfiguration(4), new PartialOverlapConfiguration(1, 0.99, 0.1), new PartialOverlapConfiguration(1, 0.99, 0.5), new PartialOverlapConfiguration(2, 0.99, 0.1), new PartialOverlapConfiguration(2, 0.99, 0.5), new PartialOverlapConfiguration(3, 0.99, 0.1), new PartialOverlapConfiguration(3, 0.99, 0.5), new PartialOverlapConfiguration(4, 0.99, 0.1), new PartialOverlapConfiguration(4, 0.99, 0.5)}) {
                MonitorDoubleStats areaStats = new MonitorDoubleStats();
                MonitorStats rangeStats = new MonitorStats();
                MonitorStats maxDepthStats = new MonitorStats();
                HilbertSpaceFillingCurve3D curve = new HilbertSpaceFillingCurve3D(envelope, level);
                double[] extent = new double[3];
                extent[0] = 1.0E-6;
                while (extent[0] <= envelope.getMax(0)) {
                    extent[1] = 1.0E-6;
                    while (extent[1] <= envelope.getMax(1)) {
                        extent[2] = 1.0E-6;
                        while (extent[2] <= envelope.getMax(2)) {
                            double aspectZX;
                            double aspectXY = extent[0] > extent[1] ? extent[0] / extent[1] : extent[1] / extent[0];
                            double aspectYZ = extent[1] > extent[2] ? extent[1] / extent[2] : extent[2] / extent[1];
                            double d = aspectZX = extent[2] > extent[0] ? extent[2] / extent[0] : extent[0] / extent[2];
                            if (aspectXY < 100.0 && aspectYZ < 100.0 && aspectZX < 100.0) {
                                double[] offset = new double[3];
                                offset[0] = 0.0;
                                while (envelope.getMin(0) + offset[0] + extent[0] <= envelope.getMax(0)) {
                                    offset[1] = 0.0;
                                    while (envelope.getMin(1) + offset[1] + extent[1] <= envelope.getMax(1)) {
                                        offset[2] = 0.0;
                                        while (envelope.getMin(2) + offset[2] + extent[2] <= envelope.getMax(2)) {
                                            HistogramMonitor monitor = new HistogramMonitor(curve.getMaxLevel());
                                            double[] startPoint = Arrays.copyOf(envelope.getMin(), 3);
                                            double[] endPoint = Arrays.copyOf(extent, 3);
                                            for (int i = 0; i < 3; ++i) {
                                                int n = i;
                                                startPoint[n] = startPoint[n] + offset[i];
                                                int n2 = i;
                                                endPoint[n2] = endPoint[n2] + startPoint[i];
                                            }
                                            Envelope searchEnvelope = new Envelope(startPoint, endPoint);
                                            long start = System.currentTimeMillis();
                                            List ranges = curve.getTilesIntersectingEnvelope(searchEnvelope, config, (SpaceFillingCurveMonitor)monitor);
                                            MatcherAssert.assertThat((Object)ranges, (Matcher)Matchers.not((Matcher)Matchers.empty()));
                                            MatcherAssert.assertThat((String)String.format("Search size was bigger than covered size for level %d, with search %s", level, searchEnvelope.toString()), (Object)monitor.getSearchArea(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(monitor.getCoveredArea())));
                                            offset[2] = offset[2] + (envelope.getWidth(2) - extent[2]) / 3.789;
                                        }
                                        offset[1] = offset[1] + (envelope.getWidth(1) - extent[1]) / 3.789;
                                    }
                                    offset[0] = offset[0] + (envelope.getWidth(0) - extent[0]) / 3.789;
                                }
                            }
                            extent[2] = extent[2] * 8.0;
                        }
                        extent[1] = extent[1] * 8.0;
                    }
                    extent[0] = extent[0] * 8.0;
                }
            }
        }
    }

    @Disabled
    public void debugSingle() {
        int xmin = -100;
        int xmax = 100;
        int ymin = -100;
        int ymax = 100;
        boolean level = true;
        double xStart = -100.0;
        double xEnd = -99.99999;
        double yStart = 99.98999999999998;
        double yEnd = 99.99999999999999;
        Envelope envelope = new Envelope(-100.0, 100.0, -100.0, 100.0);
        HilbertSpaceFillingCurve2D curve = new HilbertSpaceFillingCurve2D(envelope, 1);
        Envelope searchEnvelope = new Envelope(-100.0, -99.99999, 99.98999999999998, 99.99999999999999);
        HistogramMonitor monitor = new HistogramMonitor(curve.getMaxLevel());
        List ranges = curve.getTilesIntersectingEnvelope(searchEnvelope, (SpaceFillingCurveConfiguration)new StandardConfiguration(), (SpaceFillingCurveMonitor)monitor);
        this.logger.debug(String.format("Results for level %d, with x=[%f,%f] y=[%f,%f]\n", 1, -100.0, -99.99999, 99.98999999999998, 99.99999999999999));
        this.logger.debug(String.format("Search size vs covered size: %d vs %d\n", monitor.getSearchArea(), monitor.getCoveredArea()));
        this.logger.debug("Ranges: " + ranges.size());
        int[] counts = monitor.getCounts();
        for (int i = 0; i <= curve.getMaxLevel(); ++i) {
            this.logger.debug("\t" + i + "\t" + counts[i]);
        }
    }

    @Test
    void shouldGet2DHilbertSearchTilesForCenterRangeAndTraverseToBottom() {
        TraverseToBottomConfiguration configuration = new TraverseToBottomConfiguration();
        Envelope envelope = new Envelope(-8.0, 8.0, -8.0, 8.0);
        for (int level = 2; level <= 11; ++level) {
            HilbertSpaceFillingCurve2D curve = new HilbertSpaceFillingCurve2D(envelope, level);
            double fullTile = curve.getTileWidth(0, level);
            double halfTile = fullTile / 2.0;
            Envelope centerWithoutOuterRing = new Envelope(envelope.getMin(0) + fullTile + halfTile, envelope.getMax(0) - fullTile - halfTile, envelope.getMin(1) + fullTile + halfTile, envelope.getMax(1) - fullTile - halfTile);
            long start = System.currentTimeMillis();
            List result = curve.getTilesIntersectingEnvelope(centerWithoutOuterRing, (SpaceFillingCurveConfiguration)configuration, null);
            this.logger.debug("Hilbert query at level " + level + " took " + (System.currentTimeMillis() - start) + "ms to produce " + result.size() + " tiles");
            SpaceFillingCurveTest.assertTiles(result, SpaceFillingCurveTest.tilesNotTouchingOuterRing((SpaceFillingCurve)curve).toArray(new SpaceFillingCurve.LongRange[0]));
        }
    }

    @Test
    void shouldGiveRangesWithinMaxValuesWhenMatchingWholeEnvelopeAtMaxLevel() {
        Envelope envelope = new Envelope(-8.0, 8.0, -8.0, 8.0);
        HilbertSpaceFillingCurve2D curve = new HilbertSpaceFillingCurve2D(envelope);
        List ranges = curve.getTilesIntersectingEnvelope(envelope);
        MatcherAssert.assertThat((Object)ranges.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)((SpaceFillingCurve.LongRange)ranges.get((int)0)).max, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(Long.MAX_VALUE)));
        MatcherAssert.assertThat((Object)((SpaceFillingCurve.LongRange)ranges.get((int)0)).min, (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(Long.MIN_VALUE)));
    }

    @Test
    void shouldRotate3DNPointsLeft() {
        MatcherAssert.assertThat((Object)HilbertSpaceFillingCurve3D.BinaryCoordinateRotationUtils3D.rotateNPointLeft((int)0), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)HilbertSpaceFillingCurve3D.BinaryCoordinateRotationUtils3D.rotateNPointLeft((int)1), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)HilbertSpaceFillingCurve3D.BinaryCoordinateRotationUtils3D.rotateNPointLeft((int)2), (Matcher)Matchers.equalTo((Object)4));
        MatcherAssert.assertThat((Object)HilbertSpaceFillingCurve3D.BinaryCoordinateRotationUtils3D.rotateNPointLeft((int)4), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)HilbertSpaceFillingCurve3D.BinaryCoordinateRotationUtils3D.rotateNPointLeft((int)3), (Matcher)Matchers.equalTo((Object)6));
        MatcherAssert.assertThat((Object)HilbertSpaceFillingCurve3D.BinaryCoordinateRotationUtils3D.rotateNPointLeft((int)6), (Matcher)Matchers.equalTo((Object)5));
        MatcherAssert.assertThat((Object)HilbertSpaceFillingCurve3D.BinaryCoordinateRotationUtils3D.rotateNPointLeft((int)5), (Matcher)Matchers.equalTo((Object)3));
        MatcherAssert.assertThat((Object)HilbertSpaceFillingCurve3D.BinaryCoordinateRotationUtils3D.rotateNPointLeft((int)7), (Matcher)Matchers.equalTo((Object)7));
    }

    @Test
    void shouldRotate3DNPointsRight() {
        MatcherAssert.assertThat((Object)HilbertSpaceFillingCurve3D.BinaryCoordinateRotationUtils3D.rotateNPointRight((int)0), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)HilbertSpaceFillingCurve3D.BinaryCoordinateRotationUtils3D.rotateNPointRight((int)1), (Matcher)Matchers.equalTo((Object)4));
        MatcherAssert.assertThat((Object)HilbertSpaceFillingCurve3D.BinaryCoordinateRotationUtils3D.rotateNPointRight((int)4), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)HilbertSpaceFillingCurve3D.BinaryCoordinateRotationUtils3D.rotateNPointRight((int)2), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)HilbertSpaceFillingCurve3D.BinaryCoordinateRotationUtils3D.rotateNPointRight((int)3), (Matcher)Matchers.equalTo((Object)5));
        MatcherAssert.assertThat((Object)HilbertSpaceFillingCurve3D.BinaryCoordinateRotationUtils3D.rotateNPointRight((int)5), (Matcher)Matchers.equalTo((Object)6));
        MatcherAssert.assertThat((Object)HilbertSpaceFillingCurve3D.BinaryCoordinateRotationUtils3D.rotateNPointRight((int)6), (Matcher)Matchers.equalTo((Object)3));
        MatcherAssert.assertThat((Object)HilbertSpaceFillingCurve3D.BinaryCoordinateRotationUtils3D.rotateNPointRight((int)7), (Matcher)Matchers.equalTo((Object)7));
    }

    @Test
    void shouldCreateSimple3DHilbertCurveAtLevel1() {
        Envelope envelope = new Envelope(new double[]{-8.0, -8.0, -8.0}, new double[]{8.0, 8.0, 8.0});
        HilbertSpaceFillingCurve3D curve = new HilbertSpaceFillingCurve3D(envelope, 1);
        SpaceFillingCurveTest.assertAtLevel(curve, envelope);
        SpaceFillingCurveTest.assertRange(2, 0L, curve, 0, 0, 0);
        SpaceFillingCurveTest.assertRange(2, 1L, curve, 0, 1, 0);
        SpaceFillingCurveTest.assertRange(2, 2L, curve, 0, 1, 1);
        SpaceFillingCurveTest.assertRange(2, 3L, curve, 0, 0, 1);
        SpaceFillingCurveTest.assertRange(2, 4L, curve, 1, 0, 1);
        SpaceFillingCurveTest.assertRange(2, 5L, curve, 1, 1, 1);
        SpaceFillingCurveTest.assertRange(2, 6L, curve, 1, 1, 0);
        SpaceFillingCurveTest.assertRange(2, 7L, curve, 1, 0, 0);
    }

    @Test
    void shouldCreateSimple3DHilbertCurveAtLevel2() {
        Envelope envelope = new Envelope(new double[]{-8.0, -8.0, -8.0}, new double[]{8.0, 8.0, 8.0});
        HilbertSpaceFillingCurve3D curve = new HilbertSpaceFillingCurve3D(envelope, 2);
        SpaceFillingCurveTest.assertAtLevel(curve, envelope);
        SpaceFillingCurveTest.assertRange(4, 0L, curve, 0, 0, 0);
        SpaceFillingCurveTest.assertRange(4, 1L, curve, 0, 0, 1);
        SpaceFillingCurveTest.assertRange(4, 2L, curve, 1, 0, 1);
        SpaceFillingCurveTest.assertRange(4, 3L, curve, 1, 0, 0);
        SpaceFillingCurveTest.assertRange(4, 4L, curve, 1, 1, 0);
        SpaceFillingCurveTest.assertRange(4, 5L, curve, 1, 1, 1);
        SpaceFillingCurveTest.assertRange(4, 6L, curve, 0, 1, 1);
        SpaceFillingCurveTest.assertRange(4, 7L, curve, 0, 1, 0);
        SpaceFillingCurveTest.assertRange(4, 8L, curve, 0, 2, 0);
        SpaceFillingCurveTest.assertRange(4, 9L, curve, 1, 2, 0);
        SpaceFillingCurveTest.assertRange(4, 10L, curve, 1, 3, 0);
        SpaceFillingCurveTest.assertRange(4, 11L, curve, 0, 3, 0);
        SpaceFillingCurveTest.assertRange(4, 12L, curve, 0, 3, 1);
        SpaceFillingCurveTest.assertRange(4, 13L, curve, 1, 3, 1);
        SpaceFillingCurveTest.assertRange(4, 14L, curve, 1, 2, 1);
        SpaceFillingCurveTest.assertRange(4, 15L, curve, 0, 2, 1);
        SpaceFillingCurveTest.assertRange(4, 63L, curve, 3, 0, 0);
    }

    @Test
    void shouldCreateSimple3DHilbertCurveAtLevel3() {
        Envelope envelope = new Envelope(new double[]{-8.0, -8.0, -8.0}, new double[]{8.0, 8.0, 8.0});
        HilbertSpaceFillingCurve3D curve = new HilbertSpaceFillingCurve3D(envelope, 3);
        SpaceFillingCurveTest.assertAtLevel(curve, envelope);
        SpaceFillingCurveTest.assertRange(8, 0L, curve, 0, 0, 0);
        SpaceFillingCurveTest.assertRange(8, (long)Math.pow(8.0, 3.0) - 1L, curve, 7, 0, 0);
    }

    @Test
    void shouldCreateSimple3DHilbertCurveAtLevel4() {
        Envelope envelope = new Envelope(new double[]{-8.0, -8.0, -8.0}, new double[]{8.0, 8.0, 8.0});
        HilbertSpaceFillingCurve3D curve = new HilbertSpaceFillingCurve3D(envelope, 4);
        SpaceFillingCurveTest.assertAtLevel(curve, envelope);
        SpaceFillingCurveTest.assertRange(16, 0L, curve, 0, 0, 0);
        SpaceFillingCurveTest.assertRange(16, (long)Math.pow(8.0, 4.0) - 1L, curve, 15, 0, 0);
    }

    @Test
    void shouldCreateSimple3DHilbertCurveAtLevel5() {
        Envelope envelope = new Envelope(new double[]{-8.0, -8.0, -8.0}, new double[]{8.0, 8.0, 8.0});
        HilbertSpaceFillingCurve3D curve = new HilbertSpaceFillingCurve3D(envelope, 5);
        SpaceFillingCurveTest.assertAtLevel(curve, envelope);
        SpaceFillingCurveTest.assertRange(32, 0L, curve, 0, 0, 0);
        SpaceFillingCurveTest.assertRange(32, (long)Math.pow(8.0, 5.0) - 1L, curve, 31, 0, 0);
    }

    @Test
    void shouldCreateSimple3DHilbertCurveAtLevel6() {
        Envelope envelope = new Envelope(new double[]{-8.0, -8.0, -8.0}, new double[]{8.0, 8.0, 8.0});
        HilbertSpaceFillingCurve3D curve = new HilbertSpaceFillingCurve3D(envelope, 6);
        SpaceFillingCurveTest.assertAtLevel(curve, envelope);
        SpaceFillingCurveTest.assertRange(64, 0L, curve, 0, 0, 0);
        SpaceFillingCurveTest.assertRange(64, (long)Math.pow(8.0, 6.0) - 1L, curve, 63, 0, 0);
    }

    @Test
    void shouldCreateSimple3DHilbertCurveAtLevel7() {
        Envelope envelope = new Envelope(new double[]{-8.0, -8.0, -8.0}, new double[]{8.0, 8.0, 8.0});
        HilbertSpaceFillingCurve3D curve = new HilbertSpaceFillingCurve3D(envelope, 7);
        SpaceFillingCurveTest.assertAtLevel(curve, envelope);
        SpaceFillingCurveTest.assertRange(128, 0L, curve, 0, 0, 0);
        SpaceFillingCurveTest.assertRange(128, (long)Math.pow(8.0, 7.0) - 1L, curve, 127, 0, 0);
    }

    @Test
    void shouldCreateSimple3DHilbertCurveAtManyLevels() {
        Envelope envelope = new Envelope(new double[]{-8.0, -8.0, -8.0}, new double[]{8.0, 8.0, 8.0});
        for (int level = 1; level <= 20; ++level) {
            HilbertSpaceFillingCurve3D curve = new HilbertSpaceFillingCurve3D(envelope, level);
            this.logger.debug("Max value at level " + level + ": " + curve.getValueWidth());
            SpaceFillingCurveTest.assertAtLevel(curve, envelope);
            SpaceFillingCurveTest.assertRange((int)curve.getWidth(), 0L, curve, 0, 0, 0);
            SpaceFillingCurveTest.assertRange((int)curve.getWidth(), curve.getValueWidth() - 1L, curve, (int)curve.getWidth() - 1, 0, 0);
        }
    }

    @Test
    void shouldCreateSimple3DHilbertCurveAtLevelDefault() {
        Envelope envelope = new Envelope(new double[]{-8.0, -8.0, -8.0}, new double[]{8.0, 8.0, 8.0});
        SpaceFillingCurveTest.assertAtLevel(new HilbertSpaceFillingCurve3D(envelope), envelope);
    }

    @Test
    void shouldCreate3DHilbertCurveWithRectangularEnvelope() {
        Envelope envelope = new Envelope(new double[]{-8.0, -20.0, -15.0}, new double[]{8.0, 0.0, 15.0});
        SpaceFillingCurveTest.assertAtLevel(new HilbertSpaceFillingCurve3D(envelope), envelope);
    }

    @Test
    void shouldCreate3DHilbertCurveWithNonCenteredEnvelope() {
        Envelope envelope = new Envelope(new double[]{2.0, 2.0, 2.0}, new double[]{7.0, 7.0, 7.0});
        SpaceFillingCurveTest.assertAtLevel(new HilbertSpaceFillingCurve3D(envelope), envelope);
    }

    @Test
    void shouldWorkWithNormalGPSCoordinatesAndHeight() {
        Envelope envelope = new Envelope(new double[]{-180.0, -90.0, 0.0}, new double[]{180.0, 90.0, 10000.0});
        HilbertSpaceFillingCurve3D curve = new HilbertSpaceFillingCurve3D(envelope);
        SpaceFillingCurveTest.assertAtLevel(curve, envelope);
    }

    @Test
    void shouldGet3DSearchTilesForLevel1() {
        Envelope envelope = new Envelope(new double[]{-8.0, -8.0, -8.0}, new double[]{8.0, 8.0, 8.0});
        HilbertSpaceFillingCurve3D curve = new HilbertSpaceFillingCurve3D(envelope, 1);
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(new double[]{-6.0, -6.0, -6.0}, new double[]{-5.0, -5.0, -5.0})), new SpaceFillingCurve.LongRange(0L, 0L));
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(new double[]{0.0, -6.0, -6.0}, new double[]{6.0, -5.0, -5.0})), new SpaceFillingCurve.LongRange(7L, 7L));
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(new double[]{-6.0, -5.0, -5.0}, new double[]{4.0, -2.0, -2.0})), new SpaceFillingCurve.LongRange(0L, 0L), new SpaceFillingCurve.LongRange(7L, 7L));
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(new double[]{-2.0, -6.0, -2.0}, new double[]{-1.0, 5.0, -1.0})), new SpaceFillingCurve.LongRange(0L, 1L));
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(new double[]{-2.0, -1.0, -1.0}, new double[]{-1.0, 1.0, 1.0})), new SpaceFillingCurve.LongRange(0L, 3L));
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(new double[]{-1.0, -1.0, -1.0}, new double[]{1.0, 1.0, 1.0})), new SpaceFillingCurve.LongRange(0L, 7L));
    }

    @Test
    void shouldGet3DSearchTilesForLevel2() {
        Envelope envelope = new Envelope(new double[]{-8.0, -8.0, -8.0}, new double[]{8.0, 8.0, 8.0});
        HilbertSpaceFillingCurve3D curve = new HilbertSpaceFillingCurve3D(envelope, 2);
        int[] mid = new int[]{5, 14, 17, 28, 35, 46, 49, 58};
        SpaceFillingCurve.LongRange[] midRanges = new SpaceFillingCurve.LongRange[mid.length];
        for (int i = 0; i < mid.length; ++i) {
            midRanges[i] = new SpaceFillingCurve.LongRange((long)mid[i], (long)mid[i]);
        }
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(new double[]{-6.0, -6.0, -6.0}, new double[]{-5.0, -5.0, -5.0})), new SpaceFillingCurve.LongRange(0L, 0L));
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(new double[]{4.0, -6.0, -6.0}, new double[]{6.0, -5.0, -5.0})), new SpaceFillingCurve.LongRange(63L, 63L));
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(new double[]{-6.0, -5.0, -5.0}, new double[]{4.0, -2.0, -2.0})), new SpaceFillingCurve.LongRange(0L, 7L), new SpaceFillingCurve.LongRange(56L, 63L));
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(new double[]{-2.0, -6.0, -2.0}, new double[]{-1.0, 5.0, -1.0})), new SpaceFillingCurve.LongRange(2L, 2L), new SpaceFillingCurve.LongRange(5L, 5L), new SpaceFillingCurve.LongRange(13L, 14L));
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(new double[]{-8.0, -3.0, -3.0}, new double[]{-1.0, 3.0, 3.0})), new SpaceFillingCurve.LongRange(5L, 6L), new SpaceFillingCurve.LongRange(14L, 17L), new SpaceFillingCurve.LongRange(27L, 28L));
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(new double[]{-1.0, -1.0, -1.0}, new double[]{1.0, 1.0, 1.0})), midRanges);
    }

    @Test
    void shouldGet3DSearchTilesForLevel3() {
        Envelope envelope = new Envelope(new double[]{-8.0, -8.0, -8.0}, new double[]{8.0, 8.0, 8.0});
        HilbertSpaceFillingCurve3D curve = new HilbertSpaceFillingCurve3D(envelope, 3);
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(new double[]{-8.0, -8.0, -8.0}, new double[]{-7.0, -7.0, -7.0})), new SpaceFillingCurve.LongRange(0L, 0L));
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(new double[]{7.0, -8.0, -8.0}, new double[]{8.0, -7.0, -7.0})), new SpaceFillingCurve.LongRange(511L, 511L));
        SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(new double[]{-8.0, -8.0, -8.0}, new double[]{7.0, 7.0, 7.0})), new SpaceFillingCurve.LongRange(0L, 511L));
    }

    @Test
    void shouldGet3DSearchTilesForManyLevels() {
        Envelope envelope = new Envelope(new double[]{-8.0, -8.0, -8.0}, new double[]{8.0, 8.0, 8.0});
        for (int level = 1; level <= 20; ++level) {
            HilbertSpaceFillingCurve3D curve = new HilbertSpaceFillingCurve3D(envelope, level);
            double halfTile = curve.getTileWidth(0, level) / 2.0;
            long start = System.currentTimeMillis();
            SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(new double[]{-8.0, -8.0, -8.0}, new double[]{-8.0 + halfTile, -8.0 + halfTile, -8.0 + halfTile})), new SpaceFillingCurve.LongRange(0L, 0L));
            SpaceFillingCurveTest.assertTiles(curve.getTilesIntersectingEnvelope(new Envelope(new double[]{8.0 - halfTile, -8.0, -8.0}, new double[]{8.0, -8.0 + halfTile, -8.0 + halfTile})), new SpaceFillingCurve.LongRange(curve.getValueWidth() - 1L, curve.getValueWidth() - 1L));
            this.logger.debug("Hilbert query at level " + level + " took " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    @Test
    void shouldStepMoreThanDistanceOneForZOrderOnlyHalfTime() {
        Envelope envelope = new Envelope(new double[]{-8.0, -8.0}, new double[]{8.0, 8.0});
        for (int level = 1; level < 8; ++level) {
            ZOrderSpaceFillingCurve2D curve = new ZOrderSpaceFillingCurve2D(envelope, level);
            this.shouldNeverStepMoreThanDistanceOne((SpaceFillingCurve)curve, level, 50);
        }
    }

    @Test
    void shouldNeverStepMoreThanDistanceOneForHilbert2D() {
        Envelope envelope = new Envelope(new double[]{-8.0, -8.0}, new double[]{8.0, 8.0});
        for (int level = 1; level < 8; ++level) {
            HilbertSpaceFillingCurve2D curve = new HilbertSpaceFillingCurve2D(envelope, level);
            this.shouldNeverStepMoreThanDistanceOne((SpaceFillingCurve)curve, level, 0);
        }
    }

    @Test
    void shouldNotStepMoreThanDistanceOneMoreThan10Percent() {
        Envelope envelope = new Envelope(new double[]{-8.0, -8.0, -8.0}, new double[]{8.0, 8.0, 8.0});
        for (int level = 1; level < 8; ++level) {
            HilbertSpaceFillingCurve3D curve = new HilbertSpaceFillingCurve3D(envelope, level);
            this.shouldNeverStepMoreThanDistanceOne((SpaceFillingCurve)curve, level, 10);
        }
    }

    private void shouldNeverStepMoreThanDistanceOne(SpaceFillingCurve curve, int level, int badnessThresholdPercentage) {
        int badCount = 0;
        long[] previous = null;
        for (long derivedValue = 0L; derivedValue < curve.getValueWidth(); ++derivedValue) {
            long[] point = curve.normalizedCoordinateFor(derivedValue, level);
            if (previous != null) {
                double distance = 0.0;
                for (int i = 0; i < point.length; ++i) {
                    distance += Math.pow(point[i] - previous[i], 2.0);
                }
                if ((distance = Math.sqrt(distance)) > 1.0) {
                    ++badCount;
                }
            }
            previous = point;
        }
        int badness = (int)((long)(100 * badCount) / (curve.getValueWidth() - 1L));
        MatcherAssert.assertThat((String)("Bad distance percentage should never be greater than " + badnessThresholdPercentage + "%"), (Object)badness, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(badnessThresholdPercentage)));
        this.logger.debug(String.format("Bad distance count for level: %d (%d/%d = %d%%)", level, badCount, curve.getValueWidth() - 1L, badness));
    }

    private static List<SpaceFillingCurve.LongRange> tilesNotTouchingOuterRing(SpaceFillingCurve curve) {
        ArrayList<SpaceFillingCurve.LongRange> expected = new ArrayList<SpaceFillingCurve.LongRange>();
        HashSet<Long> outerRing = new HashSet<Long>();
        int x = 0;
        while ((long)x < curve.getWidth()) {
            outerRing.add(curve.derivedValueFor(new long[]{x, 0L}));
            outerRing.add(curve.derivedValueFor(new long[]{x, curve.getWidth() - 1L}));
            ++x;
        }
        int y = 0;
        while ((long)y < curve.getWidth()) {
            outerRing.add(curve.derivedValueFor(new long[]{0L, y}));
            outerRing.add(curve.derivedValueFor(new long[]{curve.getWidth() - 1L, y}));
            ++y;
        }
        for (long derivedValue = 0L; derivedValue < curve.getValueWidth(); ++derivedValue) {
            SpaceFillingCurve.LongRange current;
            if (outerRing.contains(derivedValue)) continue;
            SpaceFillingCurve.LongRange longRange = current = expected.size() > 0 ? expected.get(expected.size() - 1) : null;
            if (current != null && current.max == derivedValue - 1L) {
                current.expandToMax(derivedValue);
                continue;
            }
            current = new SpaceFillingCurve.LongRange(derivedValue);
            expected.add(current);
        }
        return expected;
    }

    private static void assertTiles(List<SpaceFillingCurve.LongRange> results, SpaceFillingCurve.LongRange ... expected) {
        MatcherAssert.assertThat((String)("Result differ: " + results + " != " + Arrays.toString(expected)), (Object)results.size(), (Matcher)Matchers.equalTo((Object)expected.length));
        for (int i = 0; i < results.size(); ++i) {
            MatcherAssert.assertThat((String)("Result at " + i + " should be the same"), (Object)results.get(i), (Matcher)Matchers.equalTo((Object)expected[i]));
        }
    }

    private static Envelope getTileEnvelope(Envelope envelope, int divisor, int ... index) {
        double[] widths = envelope.getWidths(divisor);
        double[] min = Arrays.copyOf(envelope.getMin(), envelope.getDimension());
        double[] max = Arrays.copyOf(envelope.getMin(), envelope.getDimension());
        for (int i = 0; i < min.length; ++i) {
            int n = i;
            min[n] = min[n] + (double)index[i] * widths[i];
            int n2 = i;
            max[n2] = max[n2] + (double)(index[i] + 1) * widths[i];
        }
        return new Envelope(min, max);
    }

    private static void assertRange(String message, ZOrderSpaceFillingCurve2D curve, Envelope range, long value) {
        for (double x = range.getMinX(); x < range.getMaxX(); x += 1.0) {
            for (double y = range.getMinY(); y < range.getMaxY(); y += 1.0) {
                SpaceFillingCurveTest.assertCurveAt(message, (SpaceFillingCurve)curve, value, x, y);
            }
        }
    }

    private static void assertRange(String message, HilbertSpaceFillingCurve2D curve, Envelope range, long value) {
        for (double x = range.getMinX(); x < range.getMaxX(); x += 1.0) {
            for (double y = range.getMinY(); y < range.getMaxY(); y += 1.0) {
                SpaceFillingCurveTest.assertCurveAt(message, (SpaceFillingCurve)curve, value, x, y);
            }
        }
    }

    private static void assertRange(String message, HilbertSpaceFillingCurve3D curve, Envelope range, long value) {
        for (double x = range.getMin(0); x < range.getMax(0); x += 1.0) {
            for (double y = range.getMin(1); y < range.getMax(1); y += 1.0) {
                for (double z = range.getMin(2); z < range.getMax(2); z += 1.0) {
                    SpaceFillingCurveTest.assertCurveAt(message, (SpaceFillingCurve)curve, value, x, y, z);
                }
            }
        }
    }

    private static void assertRange(int divisor, long value, ZOrderSpaceFillingCurve2D curve, int ... index) {
        Envelope range = SpaceFillingCurveTest.getTileEnvelope(curve.getRange(), divisor, index);
        String message = Arrays.toString(index) + " should evaluate to " + value;
        SpaceFillingCurveTest.assertRange(message, curve, range, value);
    }

    private static void assertRange(int divisor, long value, HilbertSpaceFillingCurve2D curve, int ... index) {
        Envelope range = SpaceFillingCurveTest.getTileEnvelope(curve.getRange(), divisor, index);
        String message = Arrays.toString(index) + " should evaluate to " + value;
        SpaceFillingCurveTest.assertRange(message, curve, range, value);
    }

    private static void assertRange(int divisor, long value, HilbertSpaceFillingCurve3D curve, int ... index) {
        Envelope range = SpaceFillingCurveTest.getTileEnvelope(curve.getRange(), divisor, index);
        String message = Arrays.toString(index) + " should evaluate to " + value;
        SpaceFillingCurveTest.assertRange(message, curve, range, value);
    }

    private static void assertCurveAt(String message, SpaceFillingCurve curve, long value, double ... coord) {
        double[] halfTileWidths = new double[coord.length];
        for (int i = 0; i < coord.length; ++i) {
            halfTileWidths[i] = curve.getTileWidth(i, curve.getMaxLevel()) / 2.0;
        }
        long result = curve.derivedValueFor(coord);
        double[] coordinate = curve.centerPointFor(result);
        MatcherAssert.assertThat((String)(message + ": " + Arrays.toString(coord)), (Object)result, (Matcher)Matchers.equalTo((Object)value));
        for (int i = 0; i < coord.length; ++i) {
            MatcherAssert.assertThat((String)(message + ": " + Arrays.toString(coord)), (Object)Math.abs(coordinate[i] - coord[i]), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Double.valueOf(halfTileWidths[i])));
        }
    }

    private static void assert2DAtLevel(Envelope envelope, int level) {
        SpaceFillingCurveTest.assertAtLevel(new HilbertSpaceFillingCurve2D(envelope, level), envelope);
    }

    private static void assertAtLevel(ZOrderSpaceFillingCurve2D curve, Envelope envelope) {
        int level = curve.getMaxLevel();
        long width = (long)Math.pow(2.0, level);
        long valueWidth = width * width;
        double justInsideMaxX = envelope.getMaxX() - curve.getTileWidth(0, level) / 2.0;
        double justInsideMaxY = envelope.getMaxY() - curve.getTileWidth(1, level) / 2.0;
        double midX = (envelope.getMinX() + envelope.getMaxX()) / 2.0;
        double midY = (envelope.getMinY() + envelope.getMaxY()) / 2.0;
        long topRight = 1L;
        long topRightFactor = 2L;
        long topRightDiff = 1L;
        String topRightDescription = "1";
        for (int l = 0; l < level; ++l) {
            topRight = topRightFactor - topRightDiff;
            topRightDescription = String.valueOf(topRightFactor) + " - " + topRightDescription;
            topRightDiff = topRightFactor + topRightDiff;
            topRightFactor *= 4L;
        }
        MatcherAssert.assertThat((String)("Level " + level + " should have width of " + width), (Object)curve.getWidth(), (Matcher)Matchers.equalTo((Object)width));
        MatcherAssert.assertThat((String)("Level " + level + " should have max value of " + valueWidth), (Object)curve.getValueWidth(), (Matcher)Matchers.equalTo((Object)valueWidth));
        SpaceFillingCurveTest.assertCurveAt("Top-left should evaluate to zero", (SpaceFillingCurve)curve, 0L, envelope.getMinX(), envelope.getMaxY());
        SpaceFillingCurveTest.assertCurveAt("Just inside right edge on the bottom should evaluate to max-value", (SpaceFillingCurve)curve, curve.getValueWidth() - 1L, justInsideMaxX, envelope.getMinY());
        SpaceFillingCurveTest.assertCurveAt("Just inside top-right corner should evaluate to " + topRightDescription, (SpaceFillingCurve)curve, topRight, justInsideMaxX, justInsideMaxY);
        SpaceFillingCurveTest.assertCurveAt("Right on top-right corner should evaluate to " + topRightDescription, (SpaceFillingCurve)curve, topRight, envelope.getMaxX(), envelope.getMaxY());
        SpaceFillingCurveTest.assertCurveAt("Bottom-right should evaluate to max-value", (SpaceFillingCurve)curve, curve.getValueWidth() - 1L, envelope.getMaxX(), envelope.getMinY());
        SpaceFillingCurveTest.assertCurveAt("Max x-value, middle y-value should evaluate to (maxValue-1) / 2", (SpaceFillingCurve)curve, (curve.getValueWidth() - 1L) / 2L, envelope.getMaxX(), midY);
    }

    private static void assertAtLevel(HilbertSpaceFillingCurve2D curve, Envelope envelope) {
        int level = curve.getMaxLevel();
        long width = (long)Math.pow(2.0, level);
        long valueWidth = width * width;
        double justInsideMaxX = envelope.getMaxX() - curve.getTileWidth(0, level) / 2.0;
        double justInsideMaxY = envelope.getMaxY() - curve.getTileWidth(1, level) / 2.0;
        double midX = (envelope.getMinX() + envelope.getMaxX()) / 2.0;
        double midY = (envelope.getMinY() + envelope.getMaxY()) / 2.0;
        long topRight = 0L;
        long topRightFactor = 2L;
        StringBuilder topRightDescription = new StringBuilder();
        for (int l = 0; l < level; ++l) {
            topRight += topRightFactor;
            if (topRightDescription.length() == 0) {
                topRightDescription.append(topRightFactor);
            } else {
                topRightDescription.append(" + ").append(topRightFactor);
            }
            topRightFactor *= 4L;
        }
        MatcherAssert.assertThat((String)("Level " + level + " should have width of " + width), (Object)curve.getWidth(), (Matcher)Matchers.equalTo((Object)width));
        MatcherAssert.assertThat((String)("Level " + level + " should have max value of " + valueWidth), (Object)curve.getValueWidth(), (Matcher)Matchers.equalTo((Object)valueWidth));
        SpaceFillingCurveTest.assertCurveAt("Bottom-left should evaluate to zero", (SpaceFillingCurve)curve, 0L, envelope.getMinX(), envelope.getMinY());
        SpaceFillingCurveTest.assertCurveAt("Just inside right edge on the bottom should evaluate to max-value", (SpaceFillingCurve)curve, curve.getValueWidth() - 1L, justInsideMaxX, envelope.getMinY());
        SpaceFillingCurveTest.assertCurveAt("Just inside top-right corner should evaluate to " + topRightDescription, (SpaceFillingCurve)curve, topRight, justInsideMaxX, justInsideMaxY);
        SpaceFillingCurveTest.assertCurveAt("Right on top-right corner should evaluate to " + topRightDescription, (SpaceFillingCurve)curve, topRight, envelope.getMaxX(), envelope.getMaxY());
        SpaceFillingCurveTest.assertCurveAt("Bottom-right should evaluate to max-value", (SpaceFillingCurve)curve, curve.getValueWidth() - 1L, envelope.getMaxX(), envelope.getMinY());
        SpaceFillingCurveTest.assertCurveAt("Middle value should evaluate to (max-value+1) / 2", (SpaceFillingCurve)curve, curve.getValueWidth() / 2L, midX, midY);
    }

    private static void assertAtLevel(HilbertSpaceFillingCurve3D curve, Envelope envelope) {
        int level = curve.getMaxLevel();
        int dimension = curve.rootCurve().dimension;
        long width = (long)Math.pow(2.0, level);
        long valueWidth = (long)Math.pow(width, dimension);
        double midY = (envelope.getMax(1) + envelope.getMin(1)) / 2.0;
        double[] justInsideMax = new double[dimension];
        double[] midValY = new double[]{envelope.getMin(1), envelope.getMax(1)};
        for (int i = 0; i < level; ++i) {
            if (i % 2 == 0) {
                midValY[1] = (midValY[0] + midValY[1]) / 2.0;
                continue;
            }
            midValY[0] = (midValY[0] + midValY[1]) / 2.0;
        }
        double[] locationOfHalfCurve = new double[]{(envelope.getMin(0) + envelope.getMax(0)) / 2.0, (midValY[0] + midValY[1]) / 2.0, envelope.getMax(1) - curve.getTileWidth(2, level) / 2.0};
        for (int i = 0; i < dimension; ++i) {
            justInsideMax[i] = envelope.getMax(i) - curve.getTileWidth(i, level) / 2.0;
        }
        long frontRightMid = valueWidth / 2L + valueWidth / 8L + valueWidth / 256L;
        String fromRightMidDescription = String.valueOf(valueWidth) + "/2 + " + valueWidth + "/8";
        MatcherAssert.assertThat((String)("Level " + level + " should have width of " + width), (Object)curve.getWidth(), (Matcher)Matchers.equalTo((Object)width));
        MatcherAssert.assertThat((String)("Level " + level + " should have max value of " + valueWidth), (Object)curve.getValueWidth(), (Matcher)Matchers.equalTo((Object)valueWidth));
        SpaceFillingCurveTest.assertCurveAt("Bottom-left should evaluate to zero", (SpaceFillingCurve)curve, 0L, envelope.getMin());
        SpaceFillingCurveTest.assertCurveAt("Just inside right edge on the bottom back should evaluate to max-value", (SpaceFillingCurve)curve, curve.getValueWidth() - 1L, SpaceFillingCurveTest.replaceOne(envelope.getMin(), justInsideMax[0], 0));
        if (curve.getMaxLevel() < 5) {
            SpaceFillingCurveTest.assertCurveAt("Just above front-right-mid edge should evaluate to " + fromRightMidDescription, (SpaceFillingCurve)curve, frontRightMid, SpaceFillingCurveTest.replaceOne(justInsideMax, midY, 1));
            SpaceFillingCurveTest.assertCurveAt("Right on top-right-front corner should evaluate to " + fromRightMidDescription, (SpaceFillingCurve)curve, frontRightMid, SpaceFillingCurveTest.replaceOne(envelope.getMax(), midY, 1));
        }
        SpaceFillingCurveTest.assertCurveAt("Bottom-right-back should evaluate to max-value", (SpaceFillingCurve)curve, curve.getValueWidth() - 1L, SpaceFillingCurveTest.replaceOne(envelope.getMin(), envelope.getMax(0), 0));
        if (curve.getMaxLevel() < 3) {
            SpaceFillingCurveTest.assertCurveAt("Middle value should evaluate to (max-value+1) / 2", (SpaceFillingCurve)curve, curve.getValueWidth() / 2L, locationOfHalfCurve);
        }
    }

    private static double[] replaceOne(double[] values, double value, int index) {
        double[] newValues = Arrays.copyOf(values, values.length);
        newValues[index] = value;
        return newValues;
    }

    private static class MonitorDoubleStats {
        double total;
        double min = Double.MAX_VALUE;
        double max;
        int count;

        private MonitorDoubleStats() {
        }

        void add(double value) {
            this.total += value;
            this.min = Math.min(this.min, value);
            this.max = Math.max(this.max, value);
            ++this.count;
        }

        double avg() {
            return this.total / (double)this.count;
        }
    }

    private static class MonitorStats {
        long total;
        long min = Long.MAX_VALUE;
        long max;
        int count;

        private MonitorStats() {
        }

        void add(long value) {
            this.total += value;
            this.min = Math.min(this.min, value);
            this.max = Math.max(this.max, value);
            ++this.count;
        }

        double avg() {
            return (double)this.total / (double)this.count;
        }
    }
}

