/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.security.SecureRandom;
import java.util.Objects;
import java.util.Random;

public final class StoreId {
    public static final StoreId UNKNOWN = new StoreId(-1L, -1L, -1L, -1L, -1L);
    private static final Random r = new SecureRandom();
    private final long creationTime;
    private final long randomId;
    private final long storeVersion;
    private final long upgradeTime;
    private final long upgradeTxId;

    public StoreId(long storeVersion) {
        long currentTimeMillis = System.currentTimeMillis();
        long randomLong = r.nextLong();
        this.storeVersion = storeVersion;
        this.creationTime = currentTimeMillis;
        this.randomId = randomLong;
        this.upgradeTime = currentTimeMillis;
        this.upgradeTxId = randomLong;
    }

    public StoreId(long creationTime, long randomId, long storeVersion) {
        this(creationTime, randomId, storeVersion, creationTime, randomId);
    }

    public StoreId(long creationTime, long randomId, long storeVersion, long upgradeTime, long upgradeTxId) {
        this.creationTime = creationTime;
        this.randomId = randomId;
        this.storeVersion = storeVersion;
        this.upgradeTime = upgradeTime;
        this.upgradeTxId = upgradeTxId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getRandomId() {
        return this.randomId;
    }

    public long getUpgradeTime() {
        return this.upgradeTime;
    }

    public long getUpgradeTxId() {
        return this.upgradeTxId;
    }

    public long getStoreVersion() {
        return this.storeVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreId storeId = (StoreId)o;
        return this.creationTime == storeId.creationTime && this.randomId == storeId.randomId && this.storeVersion == storeId.storeVersion && this.upgradeTime == storeId.upgradeTime && this.upgradeTxId == storeId.upgradeTxId;
    }

    public boolean equalsIgnoringUpdate(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreId storeId = (StoreId)o;
        return this.creationTime == storeId.creationTime && this.randomId == storeId.randomId;
    }

    public int hashCode() {
        return Objects.hash(this.creationTime, this.randomId, this.storeVersion, this.upgradeTime, this.upgradeTxId);
    }

    public String toString() {
        return "StoreId{creationTime=" + this.creationTime + ", randomId=" + this.randomId + ", storeVersion=" + this.storeVersion + ", upgradeTime=" + this.upgradeTime + ", upgradeTxId=" + this.upgradeTxId + "}";
    }
}

