/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.internal.counts.CountUpdater;
import org.neo4j.internal.counts.CountsChanges;
import org.neo4j.internal.counts.CountsKey;
import org.neo4j.util.concurrent.OutOfOrderSequence;

public class MapWriter
implements CountUpdater.CountWriter {
    private final CountsChanges changes;
    private final OutOfOrderSequence idSequence;
    private final long txId;
    private final Function<CountsKey, AtomicLong> defaultToStoredCount;
    private final boolean closeSequence;

    MapWriter(ToLongFunction<CountsKey> storeLookup, CountsChanges changes, OutOfOrderSequence idSequence, long txId, boolean closeSequence) {
        this.changes = changes;
        this.idSequence = idSequence;
        this.txId = txId;
        this.defaultToStoredCount = k -> new AtomicLong(storeLookup.applyAsLong((CountsKey)k));
        this.closeSequence = closeSequence;
    }

    @Override
    public boolean write(CountsKey key, long delta) {
        return this.changes.add(key, delta, this.defaultToStoredCount);
    }

    @Override
    public void close() {
        if (this.closeSequence) {
            this.idSequence.offer(this.txId, ArrayUtils.EMPTY_LONG_ARRAY);
        }
    }
}

