/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.commons.lang3.mutable.MutableLong;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.internal.counts.CountsChanges;
import org.neo4j.internal.counts.CountsKey;
import org.neo4j.internal.counts.CountsLayout;
import org.neo4j.internal.counts.GBPTreeCountsStore;
import org.neo4j.internal.counts.MapCountsChanges;
import org.neo4j.test.Race;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
class CountsChangesTest {
    @Inject
    private RandomSupport random;
    private static final Function<CountsKey, AtomicLong> NOT_STORED = key -> new AtomicLong();

    CountsChangesTest() {
    }

    @Test
    void shouldReturnAbsentIfNoCountAndNotStored() {
        MapCountsChanges changes = new MapCountsChanges();
        long count = changes.get(GBPTreeCountsStore.nodeKey((int)1));
        Assertions.assertThat((long)count).isEqualTo(-1L);
        Assertions.assertThat((boolean)changes.containsChange(GBPTreeCountsStore.nodeKey((int)1))).isFalse();
    }

    @Test
    void shouldAddNewCountIfMissingAndNotStored() {
        MapCountsChanges changes = new MapCountsChanges();
        CountsKey key = GBPTreeCountsStore.nodeKey((int)2);
        long delta = 5L;
        changes.add(key, delta, NOT_STORED);
        Assertions.assertThat((long)changes.get(key)).isEqualTo(delta);
        Assertions.assertThat((boolean)changes.containsChange(key)).isTrue();
    }

    @Test
    void shouldAddNewCountFromStoreIfMissingAndStored() {
        MapCountsChanges changes = new MapCountsChanges();
        CountsKey key = GBPTreeCountsStore.nodeKey((int)2);
        long storedCount = 3L;
        long delta = 5L;
        changes.add(key, delta, CountsChangesTest.stored(storedCount));
        Assertions.assertThat((long)changes.get(key)).isEqualTo(storedCount + delta);
        Assertions.assertThat((boolean)changes.containsChange(key)).isTrue();
    }

    @Test
    void shouldUpdateExistingCountIfPresent() {
        MapCountsChanges changes = new MapCountsChanges();
        CountsKey key = GBPTreeCountsStore.nodeKey((int)99);
        long delta1 = 9L;
        long delta2 = 5L;
        changes.add(key, delta1, NOT_STORED);
        Assertions.assertThat((boolean)changes.containsChange(key)).isTrue();
        changes.add(key, delta2, NOT_STORED);
        Assertions.assertThat((long)changes.get(key)).isEqualTo(delta1 + delta2);
        Assertions.assertThat((boolean)changes.containsChange(key)).isTrue();
    }

    @Test
    void shouldNotReadFromStoreOnUpdate() {
        MapCountsChanges changes = new MapCountsChanges();
        CountsKey key = GBPTreeCountsStore.nodeKey((int)99);
        long storedCount = 2L;
        long delta1 = 9L;
        long delta2 = 5L;
        changes.add(key, delta1, CountsChangesTest.stored(storedCount));
        changes.add(key, delta2, CountsChangesTest.stored(storedCount));
        Assertions.assertThat((long)changes.get(key)).isEqualTo(storedCount + delta1 + delta2);
        Assertions.assertThat((boolean)changes.containsChange(key)).isTrue();
    }

    @Test
    void shouldUpdateWithNegativeDelta() {
        MapCountsChanges changes = new MapCountsChanges();
        CountsKey key = GBPTreeCountsStore.nodeKey((int)99);
        long delta1 = 9L;
        long delta2 = -5L;
        changes.add(key, delta1, NOT_STORED);
        changes.add(key, delta2, NOT_STORED);
        Assertions.assertThat((long)changes.get(key)).isEqualTo(delta1 + delta2);
        Assertions.assertThat((boolean)changes.containsChange(key)).isTrue();
    }

    @Test
    void shouldFailUpdateOnFrozenChanges() {
        MapCountsChanges changes = new MapCountsChanges();
        CountsKey key = GBPTreeCountsStore.relationshipKey((int)1, (long)2L, (int)3);
        changes.add(key, 10L, NOT_STORED);
        changes.freezeAndFork();
        Assertions.assertThatThrownBy(() -> CountsChangesTest.lambda$shouldFailUpdateOnFrozenChanges$1((CountsChanges)changes, key)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void shouldFindCountInOldChanges() {
        MapCountsChanges oldChanges = new MapCountsChanges();
        CountsKey key = GBPTreeCountsStore.relationshipKey((int)4, (long)99L, (int)21);
        long delta = 10L;
        oldChanges.add(key, delta, NOT_STORED);
        CountsChanges newChanges = oldChanges.freezeAndFork();
        Assertions.assertThat((long)newChanges.get(key)).isEqualTo(delta);
        Assertions.assertThat((boolean)newChanges.containsChange(key)).isTrue();
    }

    @Test
    void shouldUpdateNewChangesBasedOnOldChanges() {
        MapCountsChanges oldChanges = new MapCountsChanges();
        CountsKey key = GBPTreeCountsStore.relationshipKey((int)4, (long)99L, (int)21);
        long delta1 = 10L;
        oldChanges.add(key, delta1, NOT_STORED);
        CountsChanges newChanges = oldChanges.freezeAndFork();
        long delta2 = 23L;
        newChanges.add(key, delta2, CountsChangesTest.stored(999L));
        Assertions.assertThat((long)newChanges.get(key)).isEqualTo(delta1 + delta2);
        Assertions.assertThat((boolean)newChanges.containsChange(key)).isTrue();
        Assertions.assertThat((boolean)oldChanges.containsChange(key)).isTrue();
    }

    @Test
    void shouldReturnAbsentIfMissingFromNewAndOld() {
        MapCountsChanges oldChanges = new MapCountsChanges();
        CountsKey key = GBPTreeCountsStore.nodeKey((int)123);
        oldChanges.add(key, 10L, NOT_STORED);
        CountsChanges newChanges = oldChanges.freezeAndFork();
        CountsKey absentKey = GBPTreeCountsStore.nodeKey((int)101);
        long count = newChanges.get(absentKey);
        Assertions.assertThat((long)count).isEqualTo(-1L);
        Assertions.assertThat((boolean)newChanges.containsChange(absentKey)).isFalse();
    }

    @Test
    void shouldUpdateConcurrently() {
        MapCountsChanges changes = new MapCountsChanges();
        InMemoryCountsStore store = new InMemoryCountsStore();
        int numStoredCounts = this.random.nextInt(10, 100);
        for (int i = 0; i < numStoredCounts; ++i) {
            CountsKey key2;
            while (store.counts.containsKey(key2 = CountsChangesTest.randomKey(this.random.random()))) {
            }
            long count2 = this.random.nextLong(100L);
            store.store(key2, count2);
        }
        Race race = new Race();
        CopyOnWriteArrayList allThreadChanges = new CopyOnWriteArrayList();
        race.addContestants(4, arg_0 -> this.lambda$shouldUpdateConcurrently$4((CountsChanges)changes, store, allThreadChanges, arg_0));
        race.goUnchecked();
        HashMap<CountsKey, MutableLong> expectedCounts = new HashMap<CountsKey, MutableLong>();
        store.counts.forEach((key, count) -> expectedCounts.put((CountsKey)key, new MutableLong(count.longValue())));
        for (Map threadChanges : allThreadChanges) {
            threadChanges.forEach((key, delta) -> expectedCounts.computeIfAbsent((CountsKey)key, k -> new MutableLong()).add(delta.longValue()));
        }
        expectedCounts.forEach((arg_0, arg_1) -> CountsChangesTest.lambda$shouldUpdateConcurrently$8((CountsChanges)changes, arg_0, arg_1));
    }

    @Test
    void shouldSortChanges() {
        MapCountsChanges changes = new MapCountsChanges();
        HashSet<CountsKey> expectedChangesSet = new HashSet<CountsKey>();
        for (int i = 0; i < 100; ++i) {
            CountsKey key = CountsChangesTest.randomKey(this.random.random());
            changes.add(key, 1L, k -> new AtomicLong());
            expectedChangesSet.add(key);
        }
        CountsLayout comparator = new CountsLayout();
        ArrayList expectedChanges = new ArrayList(expectedChangesSet);
        expectedChanges.sort(comparator);
        Iterable sortedChanges = changes.sortedChanges((Comparator)comparator);
        Iterator expectedChangesIterator = expectedChanges.iterator();
        for (Map.Entry change : sortedChanges) {
            CountsKey expectedChange = (CountsKey)expectedChangesIterator.next();
            Assertions.assertThat((int)comparator.compare(expectedChange, (CountsKey)change.getKey())).isEqualTo(0);
        }
    }

    @Test
    void shouldReturnTrueWhenGoingToAndFromZero() {
        MapCountsChanges changes = new MapCountsChanges();
        CountsKey key = GBPTreeCountsStore.nodeKey((int)99);
        Assertions.assertThat((boolean)changes.add(key, 1L, NOT_STORED)).isTrue();
        Assertions.assertThat((boolean)changes.add(key, 1L, NOT_STORED)).isFalse();
        Assertions.assertThat((boolean)changes.add(key, -1L, NOT_STORED)).isFalse();
        Assertions.assertThat((boolean)changes.add(key, -1L, NOT_STORED)).isTrue();
    }

    private static CountsKey randomKey(Random random) {
        return random.nextBoolean() ? GBPTreeCountsStore.nodeKey((int)CountsChangesTest.randomToken(random)) : GBPTreeCountsStore.relationshipKey((int)CountsChangesTest.randomToken(random), (long)CountsChangesTest.randomToken(random), (int)CountsChangesTest.randomToken(random));
    }

    private static int randomToken(Random random) {
        return random.nextInt(20);
    }

    private static Function<CountsKey, AtomicLong> stored(long count) {
        return key -> new AtomicLong(count);
    }

    private static /* synthetic */ void lambda$shouldUpdateConcurrently$8(CountsChanges changes, CountsKey key, MutableLong expectedCount) {
        long expectedCountFromChanges = changes.containsChange(key) ? expectedCount.longValue() : -1L;
        ((AbstractLongAssert)Assertions.assertThat((long)changes.get(key)).as(key.toString(), new Object[0])).isEqualTo(expectedCountFromChanges);
    }

    private /* synthetic */ Runnable lambda$shouldUpdateConcurrently$4(CountsChanges changes, InMemoryCountsStore store, List allThreadChanges, int r) {
        return () -> {
            Random threadRandom = new Random(this.random.seed() + (long)r);
            HashMap<CountsKey, MutableLong> threadChanges = new HashMap<CountsKey, MutableLong>();
            for (int i = 0; i < 10000; ++i) {
                CountsKey key = CountsChangesTest.randomKey(threadRandom);
                long delta = threadRandom.nextInt(12) - 2;
                changes.add(key, delta, (Function)store);
                threadChanges.computeIfAbsent(key, k -> new MutableLong()).add(delta);
            }
            allThreadChanges.add(threadChanges);
        };
    }

    private static /* synthetic */ void lambda$shouldFailUpdateOnFrozenChanges$1(CountsChanges changes, CountsKey key) throws Throwable {
        changes.add(key, 99L, NOT_STORED);
    }

    private static class InMemoryCountsStore
    implements Function<CountsKey, AtomicLong> {
        private final ConcurrentHashMap<CountsKey, Long> counts = new ConcurrentHashMap();

        private InMemoryCountsStore() {
        }

        void store(CountsKey key, long count) {
            this.counts.put(key, count);
        }

        @Override
        public AtomicLong apply(CountsKey countsKey) {
            return new AtomicLong(this.counts.getOrDefault(countsKey, 0L));
        }
    }
}

