/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.factory.Sets;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.counts.CountsUpdater;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.internal.counts.CountsKey;
import org.neo4j.internal.counts.GBPTreeCountsStore;
import org.neo4j.internal.counts.GBPTreeGenericCountsStore;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.FixedVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.utils.TestDirectory;

@PageCacheExtension
class GBPTreeCountsStoreTest {
    private static final int LABEL_ID_1 = 1;
    private static final int LABEL_ID_2 = 2;
    private static final int RELATIONSHIP_TYPE_ID_1 = 1;
    private static final int RELATIONSHIP_TYPE_ID_2 = 2;
    @Inject
    private TestDirectory directory;
    @Inject
    private PageCache pageCache;
    @Inject
    private FileSystemAbstraction fs;
    private GBPTreeCountsStore countsStore;

    GBPTreeCountsStoreTest() {
    }

    @BeforeEach
    void openCountsStore() throws Exception {
        this.openCountsStore(CountsBuilder.EMPTY);
    }

    @AfterEach
    void closeCountsStore() {
        this.countsStore.close();
    }

    @Test
    void failToApplySameTransactionTwice() {
        long txId = 2L;
        try (CountsUpdater updater = this.countsStore.updater(txId, true, CursorContext.NULL_CONTEXT);){
            updater.incrementNodeCount(1, 10L);
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            try (CountsUpdater updater = this.countsStore.updater(txId, true, CursorContext.NULL_CONTEXT);){
                updater.incrementNodeCount(1, 10L);
            }
        }).isInstanceOf(IllegalStateException.class)).hasMessageContaining("but highest gap-free is");
    }

    @Test
    void applySeveralChunksOfSameTransaction() {
        long txId = 2L;
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> {
            for (int i = 0; i < 100; ++i) {
                try (CountsUpdater updater = this.countsStore.updater(txId, false, CursorContext.NULL_CONTEXT);){
                    updater.incrementNodeCount(1, 10L);
                    continue;
                }
            }
            try (CountsUpdater updater = this.countsStore.updater(txId, true, CursorContext.NULL_CONTEXT);){
                updater.incrementNodeCount(1, 10L);
            }
        });
    }

    @Test
    void shouldUpdateAndReadSomeCounts() throws IOException {
        long txId = 1L;
        try (CountsUpdater updater = this.countsStore.updater(++txId, true, CursorContext.NULL_CONTEXT);){
            updater.incrementNodeCount(1, 10L);
            updater.incrementRelationshipCount(1, 1, 2, 3L);
            updater.incrementRelationshipCount(1, 2, 2, 7L);
        }
        updater = this.countsStore.updater(++txId, true, CursorContext.NULL_CONTEXT);
        try {
            updater.incrementNodeCount(1, 5L);
            updater.incrementRelationshipCount(1, 1, 2, 2L);
        }
        finally {
            if (updater != null) {
                updater.close();
            }
        }
        this.countsStore.checkpoint(FileFlushEvent.NULL, CursorContext.NULL_CONTEXT);
        org.junit.jupiter.api.Assertions.assertEquals((long)15L, (long)this.countsStore.nodeCount(1, CursorContext.NULL_CONTEXT));
        org.junit.jupiter.api.Assertions.assertEquals((long)5L, (long)this.countsStore.relationshipCount(1, 1, 2, CursorContext.NULL_CONTEXT));
        org.junit.jupiter.api.Assertions.assertEquals((long)7L, (long)this.countsStore.relationshipCount(1, 2, 2, CursorContext.NULL_CONTEXT));
        updater = this.countsStore.updater(++txId, true, CursorContext.NULL_CONTEXT);
        try {
            updater.incrementNodeCount(1, -7L);
            updater.incrementRelationshipCount(1, 1, 2, -5L);
            updater.incrementRelationshipCount(1, 2, 2, -2L);
        }
        finally {
            if (updater != null) {
                updater.close();
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)8L, (long)this.countsStore.nodeCount(1, CursorContext.NULL_CONTEXT));
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.countsStore.relationshipCount(1, 1, 2, CursorContext.NULL_CONTEXT));
        org.junit.jupiter.api.Assertions.assertEquals((long)5L, (long)this.countsStore.relationshipCount(1, 2, 2, CursorContext.NULL_CONTEXT));
    }

    @Test
    void shouldEstimateSomeCounts() throws IOException {
        long txId = 1L;
        try (CountsUpdater updater = this.countsStore.updater(++txId, true, CursorContext.NULL_CONTEXT);){
            updater.incrementNodeCount(1, 10L);
            updater.incrementRelationshipCount(1, 1, 2, 3L);
            updater.incrementRelationshipCount(1, 2, 2, 7L);
        }
        updater = this.countsStore.updater(++txId, true, CursorContext.NULL_CONTEXT);
        try {
            updater.incrementNodeCount(1, 5L);
            updater.incrementRelationshipCount(1, 1, 2, 2L);
        }
        finally {
            if (updater != null) {
                updater.close();
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)15L, (long)this.countsStore.estimateNodeCount(1, CursorContext.NULL_CONTEXT));
        org.junit.jupiter.api.Assertions.assertEquals((long)5L, (long)this.countsStore.estimateRelationshipCount(1, 1, 2, CursorContext.NULL_CONTEXT));
        org.junit.jupiter.api.Assertions.assertEquals((long)7L, (long)this.countsStore.estimateRelationshipCount(1, 2, 2, CursorContext.NULL_CONTEXT));
    }

    @Test
    void shouldUseCountsBuilderOnCreation() throws Exception {
        long rebuiltAtTransactionId = 5L;
        final int labelId = 3;
        final int labelId2 = 6;
        final int relationshipTypeId = 7;
        this.closeCountsStore();
        this.deleteCountsStore();
        TestableCountsBuilder builder = new TestableCountsBuilder(rebuiltAtTransactionId){

            @Override
            public void initialize(CountsUpdater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
                super.initialize(updater, cursorContext, memoryTracker);
                updater.incrementNodeCount(labelId, 10L);
                updater.incrementRelationshipCount(labelId, relationshipTypeId, labelId2, 14L);
            }
        };
        this.openCountsStore(builder);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.lastCommittedTxIdCalled);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.initializeCalled);
        org.junit.jupiter.api.Assertions.assertEquals((long)10L, (long)this.countsStore.nodeCount(labelId, CursorContext.NULL_CONTEXT));
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.countsStore.nodeCount(labelId2, CursorContext.NULL_CONTEXT));
        org.junit.jupiter.api.Assertions.assertEquals((long)14L, (long)this.countsStore.relationshipCount(labelId, relationshipTypeId, labelId2, CursorContext.NULL_CONTEXT));
        this.checkpointAndRestartCountsStore();
        this.incrementNodeCount(rebuiltAtTransactionId - 1L, labelId, 100);
        org.junit.jupiter.api.Assertions.assertEquals((long)10L, (long)this.countsStore.nodeCount(labelId, CursorContext.NULL_CONTEXT));
        this.incrementNodeCount(rebuiltAtTransactionId, labelId, 100);
        org.junit.jupiter.api.Assertions.assertEquals((long)10L, (long)this.countsStore.nodeCount(labelId, CursorContext.NULL_CONTEXT));
        this.incrementNodeCount(rebuiltAtTransactionId + 1L, labelId, 100);
        org.junit.jupiter.api.Assertions.assertEquals((long)110L, (long)this.countsStore.nodeCount(labelId, CursorContext.NULL_CONTEXT));
    }

    @Test
    void shouldDumpCountsStore() throws IOException {
        long txId = 2L;
        try (CountsUpdater updater = this.countsStore.updater(txId, true, CursorContext.NULL_CONTEXT);){
            updater.incrementNodeCount(1, 10L);
            updater.incrementRelationshipCount(1, 1, 2, 3L);
            updater.incrementRelationshipCount(1, 2, 2, 7L);
        }
        this.countsStore.checkpoint(FileFlushEvent.NULL, CursorContext.NULL_CONTEXT);
        this.closeCountsStore();
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        PageCacheTracer cacheTracer = PageCacheTracer.NULL;
        GBPTreeCountsStore.dump((PageCache)this.pageCache, (FileSystemAbstraction)this.fs, (Path)this.countsStoreFile(), (PrintStream)new PrintStream(out), (CursorContextFactory)new CursorContextFactory(cacheTracer, FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER), (PageCacheTracer)cacheTracer, (ImmutableSet)org.eclipse.collections.api.factory.Sets.immutable.empty());
        String dump = out.toString();
        Assertions.assertThat((String)dump).contains(new CharSequence[]{GBPTreeCountsStore.keyToString((CountsKey)GBPTreeCountsStore.nodeKey((int)1)) + " = 10"});
        Assertions.assertThat((String)dump).contains(new CharSequence[]{GBPTreeCountsStore.keyToString((CountsKey)GBPTreeCountsStore.relationshipKey((int)1, (long)1L, (int)2)) + " = 3"});
        Assertions.assertThat((String)dump).contains(new CharSequence[]{GBPTreeCountsStore.keyToString((CountsKey)GBPTreeCountsStore.relationshipKey((int)1, (long)2L, (int)2)) + " = 7"});
        Assertions.assertThat((String)dump).contains(new CharSequence[]{"Highest gap-free txId: " + txId});
    }

    private void incrementNodeCount(long txId, int labelId, int delta) {
        try (CountsUpdater updater = this.countsStore.updater(txId, true, CursorContext.NULL_CONTEXT);){
            updater.incrementNodeCount(labelId, (long)delta);
        }
    }

    private void checkpointAndRestartCountsStore() throws Exception {
        this.countsStore.checkpoint(FileFlushEvent.NULL, CursorContext.NULL_CONTEXT);
        this.closeCountsStore();
        this.openCountsStore();
    }

    private void deleteCountsStore() throws IOException {
        this.directory.getFileSystem().deleteFile(this.countsStoreFile());
    }

    private Path countsStoreFile() {
        return this.directory.file("counts.db");
    }

    private void openCountsStore(CountsBuilder builder) throws IOException {
        this.instantiateCountsStore(builder, false, GBPTreeCountsStore.NO_MONITOR);
        this.countsStore.start(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private void instantiateCountsStore(CountsBuilder builder, boolean readOnly, GBPTreeGenericCountsStore.Monitor monitor) throws IOException {
        PageCacheTracer cacheTracer = PageCacheTracer.NULL;
        this.countsStore = new GBPTreeCountsStore(this.pageCache, this.countsStoreFile(), this.fs, RecoveryCleanupWorkCollector.immediate(), builder, readOnly, monitor, "neo4j", 10, (InternalLogProvider)NullLogProvider.getInstance(), new CursorContextFactory(cacheTracer, FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER), cacheTracer, Sets.immutable.empty());
    }

    private static class TestableCountsBuilder
    implements CountsBuilder {
        private final long rebuiltAtTransactionId;
        boolean lastCommittedTxIdCalled;
        boolean initializeCalled;

        TestableCountsBuilder(long rebuiltAtTransactionId) {
            this.rebuiltAtTransactionId = rebuiltAtTransactionId;
        }

        public void initialize(CountsUpdater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
            this.initializeCalled = true;
        }

        public long lastCommittedTxId() {
            this.lastCommittedTxIdCalled = true;
            return this.rebuiltAtTransactionId;
        }
    }
}

