/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.counts;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.ImmutableSet;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.counts.InvalidCountException;
import org.neo4j.index.internal.gbptree.MultiRootGBPTree;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.counts.CountUpdater;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.internal.counts.CountsKey;
import org.neo4j.internal.counts.GBPTreeCountsStore;
import org.neo4j.internal.counts.GBPTreeGenericCountsStore;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.FixedVersionContextSupplier;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.Race;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;
import org.neo4j.test.extension.pagecache.PageCacheExtension;
import org.neo4j.test.utils.TestDirectory;
import org.neo4j.util.concurrent.ArrayQueueOutOfOrderSequence;
import org.neo4j.util.concurrent.BinaryLatch;
import org.neo4j.util.concurrent.OutOfOrderSequence;

@PageCacheExtension
@ExtendWith(value={RandomExtension.class})
class GBPTreeGenericCountsStoreTest {
    private static final int HIGH_TOKEN_ID = 30;
    private static final int LABEL_ID_1 = 1;
    private static final int LABEL_ID_2 = 2;
    private static final int RELATIONSHIP_TYPE_ID_1 = 1;
    private static final int RELATIONSHIP_TYPE_ID_2 = 2;
    private static final CursorContextFactory CONTEXT_FACTORY = new CursorContextFactory(PageCacheTracer.NULL, FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER);
    @Inject
    private TestDirectory directory;
    @Inject
    private PageCache pageCache;
    @Inject
    private FileSystemAbstraction fs;
    @Inject
    private RandomSupport random;
    private GBPTreeGenericCountsStore countsStore;

    GBPTreeGenericCountsStoreTest() {
    }

    @BeforeEach
    void openCountsStore() throws Exception {
        this.openCountsStore(GBPTreeGenericCountsStore.EMPTY_REBUILD);
    }

    @AfterEach
    void closeCountsStore() {
        this.countsStore.close();
    }

    @Test
    void tracePageCacheAccessOnCountStoreOpen() throws IOException {
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        Path file = this.directory.file("another.file");
        GBPTreeGenericCountsStoreTest.assertZeroGlobalTracer((PageCacheTracer)pageCacheTracer);
        CursorContextFactory cursorContextFactory = new CursorContextFactory((PageCacheTracer)pageCacheTracer, FixedVersionContextSupplier.EMPTY_CONTEXT_SUPPLIER);
        try (GBPTreeCountsStore counts = new GBPTreeCountsStore(this.pageCache, file, this.directory.getFileSystem(), RecoveryCleanupWorkCollector.immediate(), CountsBuilder.EMPTY, false, GBPTreeCountsStore.NO_MONITOR, "neo4j", this.randomMaxCacheSize(), (InternalLogProvider)NullLogProvider.getInstance(), cursorContextFactory, (PageCacheTracer)pageCacheTracer, this.getOpenOptions());){
            Assertions.assertThat((long)pageCacheTracer.pins()).isEqualTo(4L);
            Assertions.assertThat((long)pageCacheTracer.unpins()).isEqualTo(4L);
            Assertions.assertThat((long)pageCacheTracer.hits()).isEqualTo(1L);
            Assertions.assertThat((long)pageCacheTracer.faults()).isEqualTo(3L);
        }
        Assertions.assertThat((long)pageCacheTracer.pins()).isEqualTo(4L);
        Assertions.assertThat((long)pageCacheTracer.unpins()).isEqualTo(4L);
        Assertions.assertThat((long)pageCacheTracer.hits()).isEqualTo(1L);
        Assertions.assertThat((long)pageCacheTracer.faults()).isEqualTo(3L);
    }

    @Test
    void tracePageCacheAccessOnNodeCount() {
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        CursorContext cursorContext = CONTEXT_FACTORY.create(pageCacheTracer.createPageCursorTracer("tracePageCacheAccessOnNodeCount"));
        GBPTreeGenericCountsStoreTest.assertZeroTracer(cursorContext);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.countsStore.read(GBPTreeCountsStore.nodeKey((int)0), cursorContext));
        Assertions.assertThat((long)cursorContext.getCursorTracer().pins()).isEqualTo(1L);
        Assertions.assertThat((long)cursorContext.getCursorTracer().unpins()).isEqualTo(1L);
        Assertions.assertThat((long)cursorContext.getCursorTracer().hits()).isEqualTo(1L);
    }

    @Test
    void tracePageCacheAccessOnRelationshipCount() {
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        CursorContext cursorContext = CONTEXT_FACTORY.create(pageCacheTracer.createPageCursorTracer("tracePageCacheAccessOnRelationshipCount"));
        GBPTreeGenericCountsStoreTest.assertZeroTracer(cursorContext);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.countsStore.read(GBPTreeCountsStore.relationshipKey((int)-1, (long)-1L, (int)-1), cursorContext));
        Assertions.assertThat((long)cursorContext.getCursorTracer().pins()).isEqualTo(1L);
        Assertions.assertThat((long)cursorContext.getCursorTracer().unpins()).isEqualTo(1L);
        Assertions.assertThat((long)cursorContext.getCursorTracer().hits()).isEqualTo(1L);
    }

    @Test
    void tracePageCacheAccessOnApply() {
        DefaultPageCacheTracer pageCacheTracer = new DefaultPageCacheTracer();
        CursorContext cursorContext = CONTEXT_FACTORY.create(pageCacheTracer.createPageCursorTracer("tracePageCacheAccessOnApply"));
        GBPTreeGenericCountsStoreTest.assertZeroTracer(cursorContext);
        try (CountUpdater updater = this.countsStore.updaterImpl(2L, true, cursorContext);){
            updater.increment(GBPTreeCountsStore.nodeKey((int)1), 10L);
            updater.increment(GBPTreeCountsStore.relationshipKey((int)1, (long)1L, (int)2), 3L);
            updater.increment(GBPTreeCountsStore.relationshipKey((int)1, (long)2L, (int)2), 7L);
        }
        Assertions.assertThat((long)cursorContext.getCursorTracer().pins()).isEqualTo(3L);
        Assertions.assertThat((long)cursorContext.getCursorTracer().unpins()).isEqualTo(3L);
        Assertions.assertThat((long)cursorContext.getCursorTracer().hits()).isEqualTo(3L);
    }

    @Test
    void failToApplySameTransactionTwice() {
        long txId = 2L;
        try (CountUpdater updater = this.countsStore.updaterImpl(txId, true, CursorContext.NULL_CONTEXT);){
            updater.increment(GBPTreeCountsStore.nodeKey((int)1), 10L);
        }
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            try (CountUpdater updater = this.countsStore.updaterImpl(txId, true, CursorContext.NULL_CONTEXT);){
                updater.increment(GBPTreeCountsStore.nodeKey((int)1), 10L);
            }
        }).isInstanceOf(IllegalStateException.class)).hasMessageContaining("but highest gap-free is");
    }

    @Test
    void applySeveralChunksOfSameTransaction() {
        long txId = 2L;
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> {
            for (int i = 0; i < 100; ++i) {
                try (CountUpdater updater = this.countsStore.updaterImpl(txId, false, CursorContext.NULL_CONTEXT);){
                    updater.increment(GBPTreeCountsStore.nodeKey((int)1), 10L);
                    continue;
                }
            }
            try (CountUpdater updater = this.countsStore.updaterImpl(txId, true, CursorContext.NULL_CONTEXT);){
                updater.increment(GBPTreeCountsStore.nodeKey((int)1), 10L);
            }
        });
    }

    @Test
    void shouldUpdateAndReadSomeCounts() throws IOException {
        long txId = 1L;
        try (CountUpdater updater = this.countsStore.updaterImpl(++txId, true, CursorContext.NULL_CONTEXT);){
            updater.increment(GBPTreeCountsStore.nodeKey((int)1), 10L);
            updater.increment(GBPTreeCountsStore.relationshipKey((int)1, (long)1L, (int)2), 3L);
            updater.increment(GBPTreeCountsStore.relationshipKey((int)1, (long)2L, (int)2), 7L);
        }
        updater = this.countsStore.updaterImpl(++txId, true, CursorContext.NULL_CONTEXT);
        try {
            updater.increment(GBPTreeCountsStore.nodeKey((int)1), 5L);
            updater.increment(GBPTreeCountsStore.relationshipKey((int)1, (long)1L, (int)2), 2L);
        }
        finally {
            if (updater != null) {
                updater.close();
            }
        }
        this.countsStore.checkpoint(FileFlushEvent.NULL, CursorContext.NULL_CONTEXT);
        org.junit.jupiter.api.Assertions.assertEquals((long)15L, (long)this.countsStore.read(GBPTreeCountsStore.nodeKey((int)1), CursorContext.NULL_CONTEXT));
        org.junit.jupiter.api.Assertions.assertEquals((long)5L, (long)this.countsStore.read(GBPTreeCountsStore.relationshipKey((int)1, (long)1L, (int)2), CursorContext.NULL_CONTEXT));
        org.junit.jupiter.api.Assertions.assertEquals((long)7L, (long)this.countsStore.read(GBPTreeCountsStore.relationshipKey((int)1, (long)2L, (int)2), CursorContext.NULL_CONTEXT));
        updater = this.countsStore.updaterImpl(++txId, true, CursorContext.NULL_CONTEXT);
        try {
            updater.increment(GBPTreeCountsStore.nodeKey((int)1), -7L);
            updater.increment(GBPTreeCountsStore.relationshipKey((int)1, (long)1L, (int)2), -5L);
            updater.increment(GBPTreeCountsStore.relationshipKey((int)1, (long)2L, (int)2), -2L);
        }
        finally {
            if (updater != null) {
                updater.close();
            }
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)8L, (long)this.countsStore.read(GBPTreeCountsStore.nodeKey((int)1), CursorContext.NULL_CONTEXT));
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.countsStore.read(GBPTreeCountsStore.relationshipKey((int)1, (long)1L, (int)2), CursorContext.NULL_CONTEXT));
        org.junit.jupiter.api.Assertions.assertEquals((long)5L, (long)this.countsStore.read(GBPTreeCountsStore.relationshipKey((int)1, (long)2L, (int)2), CursorContext.NULL_CONTEXT));
    }

    @Test
    void shouldReturnTrueWhenGoingToAndFromZero() {
        long txId = 1L;
        CountsKey key = GBPTreeCountsStore.nodeKey((int)1);
        try (CountUpdater updater = this.countsStore.updaterImpl(++txId, true, CursorContext.NULL_CONTEXT);){
            Assertions.assertThat((boolean)updater.increment(key, 1L)).isTrue();
            Assertions.assertThat((boolean)updater.increment(key, 1L)).isFalse();
        }
        updater = this.countsStore.updaterImpl(++txId, true, CursorContext.NULL_CONTEXT);
        try {
            Assertions.assertThat((boolean)updater.increment(key, -1L)).isFalse();
            Assertions.assertThat((boolean)updater.increment(key, -1L)).isTrue();
        }
        finally {
            if (updater != null) {
                updater.close();
            }
        }
    }

    @Test
    void shouldCheckpointAndRecoverConsistentlyUnderStressfulLoad() throws Throwable {
        int threads = 50;
        int numberOfRounds = 5;
        int roundTimeMillis = 300;
        ConcurrentHashMap<CountsKey, AtomicLong> expected = new ConcurrentHashMap<CountsKey, AtomicLong>();
        AtomicLong nextTxId = new AtomicLong(1L);
        AtomicLong lastCheckPointedTxId = new AtomicLong(nextTxId.longValue());
        long lastRoundClosedAt = 1L;
        long baseCount = 10000L;
        try (CountUpdater initialApplier = this.countsStore.updaterImpl(nextTxId.incrementAndGet(), true, CursorContext.NULL_CONTEXT);){
            for (int s = -1; s < 30; ++s) {
                initialApplier.increment(GBPTreeCountsStore.nodeKey((int)s), baseCount);
                for (int t = -1; t < 30; ++t) {
                    for (int e = -1; e < 30; ++e) {
                        initialApplier.increment(GBPTreeCountsStore.relationshipKey((int)s, (long)t, (int)e), baseCount);
                    }
                }
            }
        }
        ArrayQueueOutOfOrderSequence lastClosedTxId = new ArrayQueueOutOfOrderSequence(nextTxId.get(), 200, OutOfOrderSequence.EMPTY_META);
        for (int r = 0; r < numberOfRounds; ++r) {
            Race race = new Race().withMaxDuration((long)roundTimeMillis, TimeUnit.MILLISECONDS);
            race.addContestants(threads, Race.throwing(() -> this.lambda$shouldCheckpointAndRecoverConsistentlyUnderStressfulLoad$2(nextTxId, expected, (OutOfOrderSequence)lastClosedTxId)));
            race.addContestant(Race.throwing(() -> this.lambda$shouldCheckpointAndRecoverConsistentlyUnderStressfulLoad$3((OutOfOrderSequence)lastClosedTxId, lastCheckPointedTxId, roundTimeMillis)));
            race.go();
            this.crashAndRestartCountsStore();
            this.recover(lastCheckPointedTxId.get(), nextTxId.get());
            Assertions.assertThat((long)nextTxId.get()).isGreaterThan(lastRoundClosedAt);
            lastRoundClosedAt = nextTxId.get();
            this.assertCountsMatchesExpected(expected, baseCount);
        }
    }

    @Test
    void shouldNotReapplyAlreadyAppliedTransactionBelowHighestGapFree() throws Exception {
        long txId;
        int labelId = 5;
        long expectedCount = 0L;
        int delta = 3;
        for (txId = 2L; txId < 10L; ++txId) {
            this.incrementNodeCount(txId, labelId, delta);
            expectedCount += (long)delta;
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedCount, (long)this.countsStore.read(GBPTreeCountsStore.nodeKey((int)labelId), CursorContext.NULL_CONTEXT));
        this.checkpointAndRestartCountsStore();
        for (txId = 2L; txId < 10L; ++txId) {
            this.incrementNodeCount(txId, labelId, delta);
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)expectedCount, (long)this.countsStore.read(GBPTreeCountsStore.nodeKey((int)labelId), CursorContext.NULL_CONTEXT));
    }

    @Test
    void shouldNotReapplyAlreadyAppliedTransactionAmongStrayTxIds() throws Exception {
        int labelId = 20;
        this.incrementNodeCount(2L, labelId, 5);
        this.incrementNodeCount(4L, labelId, 7);
        this.checkpointAndRestartCountsStore();
        this.incrementNodeCount(4L, labelId, 7);
        org.junit.jupiter.api.Assertions.assertEquals((long)12L, (long)this.countsStore.read(GBPTreeCountsStore.nodeKey((int)labelId), CursorContext.NULL_CONTEXT));
        this.incrementNodeCount(3L, labelId, 3);
        org.junit.jupiter.api.Assertions.assertEquals((long)15L, (long)this.countsStore.read(GBPTreeCountsStore.nodeKey((int)labelId), CursorContext.NULL_CONTEXT));
    }

    @Test
    void shouldUseCountsBuilderOnCreation() throws Exception {
        long rebuiltAtTransactionId = 5L;
        final int labelId = 3;
        final int labelId2 = 6;
        final int relationshipTypeId = 7;
        this.closeCountsStore();
        this.deleteCountsStore();
        TestableCountsBuilder builder = new TestableCountsBuilder(rebuiltAtTransactionId){

            @Override
            public void rebuild(CountUpdater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
                super.rebuild(updater, cursorContext, memoryTracker);
                updater.increment(GBPTreeCountsStore.nodeKey((int)labelId), 10L);
                updater.increment(GBPTreeCountsStore.relationshipKey((int)labelId, (long)relationshipTypeId, (int)labelId2), 14L);
            }
        };
        this.openCountsStore(builder);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.lastCommittedTxIdCalled);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)builder.rebuildCalled);
        org.junit.jupiter.api.Assertions.assertEquals((long)10L, (long)this.countsStore.read(GBPTreeCountsStore.nodeKey((int)labelId), CursorContext.NULL_CONTEXT));
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)this.countsStore.read(GBPTreeCountsStore.nodeKey((int)labelId2), CursorContext.NULL_CONTEXT));
        org.junit.jupiter.api.Assertions.assertEquals((long)14L, (long)this.countsStore.read(GBPTreeCountsStore.relationshipKey((int)labelId, (long)relationshipTypeId, (int)labelId2), CursorContext.NULL_CONTEXT));
        this.checkpointAndRestartCountsStore();
        this.incrementNodeCount(rebuiltAtTransactionId - 1L, labelId, 100);
        org.junit.jupiter.api.Assertions.assertEquals((long)10L, (long)this.countsStore.read(GBPTreeCountsStore.nodeKey((int)labelId), CursorContext.NULL_CONTEXT));
        this.incrementNodeCount(rebuiltAtTransactionId, labelId, 100);
        org.junit.jupiter.api.Assertions.assertEquals((long)10L, (long)this.countsStore.read(GBPTreeCountsStore.nodeKey((int)labelId), CursorContext.NULL_CONTEXT));
        this.incrementNodeCount(rebuiltAtTransactionId + 1L, labelId, 100);
        org.junit.jupiter.api.Assertions.assertEquals((long)110L, (long)this.countsStore.read(GBPTreeCountsStore.nodeKey((int)labelId), CursorContext.NULL_CONTEXT));
    }

    @Test
    void shouldNotApplyTransactionOnCreatedCountsStoreDuringRecovery() throws IOException {
        final int labelId = 123;
        this.incrementNodeCount(2L, labelId, 4);
        this.countsStore.checkpoint(FileFlushEvent.NULL, CursorContext.NULL_CONTEXT);
        this.incrementNodeCount(3L, labelId, -2);
        this.closeCountsStore();
        this.deleteCountsStore();
        GBPTreeGenericCountsStore.Monitor monitor = (GBPTreeGenericCountsStore.Monitor)Mockito.mock(GBPTreeGenericCountsStore.Monitor.class);
        this.instantiateCountsStore(new GBPTreeGenericCountsStore.Rebuilder(){

            public void rebuild(CountUpdater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
                updater.increment(GBPTreeCountsStore.nodeKey((int)labelId), 2L);
            }

            public long lastCommittedTxId() {
                return 3L;
            }
        }, false, monitor);
        this.incrementNodeCount(3L, labelId, -2);
        ((GBPTreeGenericCountsStore.Monitor)Mockito.verify((Object)monitor)).ignoredTransaction(3L);
        this.countsStore.start(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)this.countsStore.read(GBPTreeCountsStore.nodeKey((int)labelId), CursorContext.NULL_CONTEXT));
    }

    @Test
    void checkpointShouldWaitForApplyingTransactionsToClose() throws Exception {
        CountUpdater updater1 = this.countsStore.updaterImpl(2L, true, CursorContext.NULL_CONTEXT);
        CountUpdater updater2 = this.countsStore.updaterImpl(3L, true, CursorContext.NULL_CONTEXT);
        try (OtherThreadExecutor checkpointer = new OtherThreadExecutor("Checkpointer", 1L, TimeUnit.MINUTES);){
            Future checkpoint = checkpointer.executeDontWait(OtherThreadExecutor.command(() -> this.countsStore.checkpoint(FileFlushEvent.NULL, CursorContext.NULL_CONTEXT)));
            checkpointer.waitUntilWaiting();
            updater1.close();
            checkpointer.waitUntilWaiting();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)checkpoint.isDone());
            updater2.close();
            checkpoint.get();
        }
    }

    @Test
    void checkpointShouldBlockApplyingNewTransactions() throws Exception {
        CountUpdater updaterBeforeCheckpoint = this.countsStore.updaterImpl(2L, true, CursorContext.NULL_CONTEXT);
        AtomicReference updater = new AtomicReference();
        try (OtherThreadExecutor checkpointer = new OtherThreadExecutor("Checkpointer", 1L, TimeUnit.MINUTES);
             OtherThreadExecutor applier = new OtherThreadExecutor("Applier", 1L, TimeUnit.MINUTES);){
            Future checkpoint = checkpointer.executeDontWait(OtherThreadExecutor.command(() -> this.countsStore.checkpoint(FileFlushEvent.NULL, CursorContext.NULL_CONTEXT)));
            checkpointer.waitUntilWaiting();
            Future applierAfterCheckpoint = applier.executeDontWait(() -> {
                updater.set(this.countsStore.updaterImpl(3L, true, CursorContext.NULL_CONTEXT));
                return null;
            });
            applier.waitUntilWaiting();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)checkpoint.isDone());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)applierAfterCheckpoint.isDone());
            updaterBeforeCheckpoint.close();
            checkpoint.get();
            applierAfterCheckpoint.get();
            applier.execute(() -> {
                ((CountUpdater)updater.get()).close();
                return null;
            });
        }
    }

    @Test
    void shouldNotStartWithoutFileIfReadOnly() {
        Path file = this.directory.file("non-existing");
        IllegalStateException e = (IllegalStateException)org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> new GBPTreeCountsStore(this.pageCache, file, this.fs, RecoveryCleanupWorkCollector.immediate(), CountsBuilder.EMPTY, true, GBPTreeCountsStore.NO_MONITOR, "neo4j", this.randomMaxCacheSize(), (InternalLogProvider)NullLogProvider.getInstance(), CONTEXT_FACTORY, PageCacheTracer.NULL, this.getOpenOptions()));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)Exceptions.contains((Throwable)e, t -> t instanceof IllegalStateException));
    }

    @Test
    void shouldAllowToCreateUpdatedEvenInReadOnlyMode() throws IOException {
        this.countsStore.checkpoint(FileFlushEvent.NULL, CursorContext.NULL_CONTEXT);
        this.closeCountsStore();
        this.instantiateCountsStore(GBPTreeGenericCountsStore.EMPTY_REBUILD, true, GBPTreeCountsStore.NO_MONITOR);
        this.countsStore.start(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> this.countsStore.updaterImpl(2L, true, CursorContext.NULL_CONTEXT));
    }

    @Test
    void shouldNotCheckpointInReadOnlyMode() throws IOException {
        this.countsStore.checkpoint(FileFlushEvent.NULL, CursorContext.NULL_CONTEXT);
        this.closeCountsStore();
        this.instantiateCountsStore(GBPTreeGenericCountsStore.EMPTY_REBUILD, true, GBPTreeCountsStore.NO_MONITOR);
        this.countsStore.start(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        this.countsStore.checkpoint(FileFlushEvent.NULL, CursorContext.NULL_CONTEXT);
    }

    @Test
    void shouldNotSeeOutdatedCountsOnCheckpoint() throws Throwable {
        try (CountUpdater updater = this.countsStore.updaterImpl(2L, true, CursorContext.NULL_CONTEXT);){
            updater.increment(GBPTreeCountsStore.nodeKey((int)1), 10L);
            updater.increment(GBPTreeCountsStore.relationshipKey((int)1, (long)1L, (int)2), 3L);
            updater.increment(GBPTreeCountsStore.relationshipKey((int)1, (long)2L, (int)2), 7L);
        }
        Race race = new Race();
        race.addContestant(Race.throwing(() -> this.countsStore.checkpoint(FileFlushEvent.NULL, CursorContext.NULL_CONTEXT)), 1);
        race.addContestants(10, Race.throwing(() -> {
            org.junit.jupiter.api.Assertions.assertEquals((long)10L, (long)this.countsStore.read(GBPTreeCountsStore.nodeKey((int)1), CursorContext.NULL_CONTEXT));
            org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)this.countsStore.read(GBPTreeCountsStore.relationshipKey((int)1, (long)1L, (int)2), CursorContext.NULL_CONTEXT));
            org.junit.jupiter.api.Assertions.assertEquals((long)7L, (long)this.countsStore.read(GBPTreeCountsStore.relationshipKey((int)1, (long)2L, (int)2), CursorContext.NULL_CONTEXT));
        }), 1);
        race.go();
    }

    @Test
    void shouldNotCreateFileOnDumpingNonExistentCountsStore() {
        Path file = this.directory.file("abcd");
        org.junit.jupiter.api.Assertions.assertThrows(NoSuchFileException.class, () -> GBPTreeCountsStore.dump((PageCache)this.pageCache, (FileSystemAbstraction)this.fs, (Path)file, (PrintStream)System.out, (CursorContextFactory)CONTEXT_FACTORY, (PageCacheTracer)PageCacheTracer.NULL, (ImmutableSet)Sets.immutable.empty()));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.fs.fileExists(file));
    }

    @Test
    void shouldDeleteAndMarkForRebuildOnCorruptStore() throws Exception {
        try (CountUpdater updater = this.countsStore.updaterImpl(2L, true, CursorContext.NULL_CONTEXT);){
            updater.increment(GBPTreeCountsStore.nodeKey((int)1), 9L);
        }
        this.closeCountsStore();
        try (StoreChannel channel = this.fs.open(this.countsStoreFile(), Set.of(StandardOpenOption.WRITE));){
            ByteBuffer buffer = ByteBuffer.wrap(new byte[8192]);
            int i = 0;
            while (buffer.hasRemaining()) {
                buffer.put((byte)i);
                ++i;
            }
            buffer.flip();
            channel.writeAll(buffer, 0L);
        }
        GBPTreeGenericCountsStore.Rebuilder countsBuilder = (GBPTreeGenericCountsStore.Rebuilder)Mockito.mock(GBPTreeGenericCountsStore.Rebuilder.class);
        Mockito.when((Object)countsBuilder.lastCommittedTxId()).thenReturn((Object)1L);
        ((GBPTreeGenericCountsStore.Rebuilder)Mockito.doAnswer(invocationOnMock -> {
            CountUpdater updater = (CountUpdater)invocationOnMock.getArgument(0, CountUpdater.class);
            updater.increment(GBPTreeCountsStore.nodeKey((int)1), 3L);
            return null;
        }).when((Object)countsBuilder)).rebuild((CountUpdater)ArgumentMatchers.any(), (CursorContext)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any());
        this.openCountsStore(countsBuilder);
        ((GBPTreeGenericCountsStore.Rebuilder)Mockito.verify((Object)countsBuilder)).rebuild((CountUpdater)ArgumentMatchers.any(), (CursorContext)ArgumentMatchers.any(), (MemoryTracker)ArgumentMatchers.any());
        org.junit.jupiter.api.Assertions.assertEquals((long)3L, (long)this.countsStore.read(GBPTreeCountsStore.nodeKey((int)1), CursorContext.NULL_CONTEXT));
    }

    @Test
    void shouldWriteAbsoluteCountsWithDirectUpdater() throws IOException {
        HashMap<CountsKey, Long> expected = new HashMap<CountsKey, Long>();
        for (int i = 0; i < 100; ++i) {
            expected.put(this.randomKey(), this.random.nextLong(1L, Long.MAX_VALUE));
        }
        try (CountUpdater countUpdater = this.countsStore.createDirectUpdater(false, CursorContext.NULL_CONTEXT);){
            expected.forEach((arg_0, arg_1) -> ((CountUpdater)countUpdater).increment(arg_0, arg_1));
        }
        expected.forEach((key, count) -> Assertions.assertThat((long)this.countsStore.read(key, CursorContext.NULL_CONTEXT)).isEqualTo(count));
    }

    @Test
    void shouldWriteDeltaCountsWithDirectUpdater() throws IOException {
        int i;
        HashMap<CountsKey, Long> expected = new HashMap<CountsKey, Long>();
        for (i = 0; i < 1000; ++i) {
            expected.put(this.randomKey(), this.random.nextLong(1L, Integer.MAX_VALUE));
        }
        for (i = 0; i < 2; ++i) {
            try (CountUpdater countUpdater = this.countsStore.createDirectUpdater(true, CursorContext.NULL_CONTEXT);){
                expected.forEach((arg_0, arg_1) -> ((CountUpdater)countUpdater).increment(arg_0, arg_1));
                continue;
            }
        }
        expected.forEach((key, count) -> Assertions.assertThat((long)this.countsStore.read(key, CursorContext.NULL_CONTEXT)).isEqualTo(count * 2L));
    }

    @Test
    void shouldHandleInvalidCountValues() throws IOException {
        long txId = 1L;
        try (CountUpdater updater = this.countsStore.updaterImpl(++txId, true, CursorContext.NULL_CONTEXT);){
            updater.increment(GBPTreeCountsStore.nodeKey((int)1), -5L);
            updater.increment(GBPTreeCountsStore.nodeKey((int)2), 10L);
        }
        this.countsStore.checkpoint(FileFlushEvent.NULL, CursorContext.NULL_CONTEXT);
        updater = this.countsStore.updaterImpl(++txId, true, CursorContext.NULL_CONTEXT);
        try {
            updater.increment(GBPTreeCountsStore.nodeKey((int)1), 10L);
            updater.increment(GBPTreeCountsStore.nodeKey((int)2), 5L);
        }
        finally {
            if (updater != null) {
                updater.close();
            }
        }
        InvalidCountException e1 = (InvalidCountException)org.junit.jupiter.api.Assertions.assertThrows(InvalidCountException.class, () -> this.countsStore.read(GBPTreeCountsStore.nodeKey((int)1), CursorContext.NULL_CONTEXT));
        Assertions.assertThat((Throwable)e1).hasMessageContaining("The count value for key 'CountsKey[type:1, first:1, second:0]' is invalid. This is a serious error which is typically caused by a store corruption");
        org.junit.jupiter.api.Assertions.assertEquals((long)15L, (long)this.countsStore.read(GBPTreeCountsStore.nodeKey((int)2), CursorContext.NULL_CONTEXT));
        this.countsStore.checkpoint(FileFlushEvent.NULL, CursorContext.NULL_CONTEXT);
        InvalidCountException e2 = (InvalidCountException)org.junit.jupiter.api.Assertions.assertThrows(InvalidCountException.class, () -> this.countsStore.read(GBPTreeCountsStore.nodeKey((int)1), CursorContext.NULL_CONTEXT));
        Assertions.assertThat((Throwable)e2).hasMessageContaining("The count value for key 'CountsKey[type:1, first:1, second:0]' is invalid.");
        org.junit.jupiter.api.Assertions.assertEquals((long)15L, (long)this.countsStore.read(GBPTreeCountsStore.nodeKey((int)2), CursorContext.NULL_CONTEXT));
    }

    @Test
    void shouldRebuildOnMismatchingLastCommittedTxId() throws IOException {
        final long countsStoreTxId = 2L;
        try (CountUpdater updater = this.countsStore.updaterImpl(countsStoreTxId, true, CursorContext.NULL_CONTEXT);){
            updater.increment(GBPTreeCountsStore.nodeKey((int)1), 1L);
        }
        this.countsStore.checkpoint(FileFlushEvent.NULL, CursorContext.NULL_CONTEXT);
        this.closeCountsStore();
        final MutableBoolean rebuildTriggered = new MutableBoolean();
        this.openCountsStore(new GBPTreeGenericCountsStore.Rebuilder(){

            public long lastCommittedTxId() {
                return countsStoreTxId + 1L;
            }

            public void rebuild(CountUpdater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
                rebuildTriggered.setTrue();
            }
        });
        Assertions.assertThat((boolean)rebuildTriggered.booleanValue()).isTrue();
    }

    @Test
    void shouldNotRebuildOnMismatchingLastCommittedTxIdButMatchingAfterRecovery() throws IOException {
        final long countsStoreTxId = 2L;
        CountsKey key = GBPTreeCountsStore.nodeKey((int)1);
        try (CountUpdater updater = this.countsStore.updaterImpl(countsStoreTxId, true, CursorContext.NULL_CONTEXT);){
            updater.increment(key, 1L);
        }
        updater = this.countsStore.updaterImpl(countsStoreTxId + 2L, true, CursorContext.NULL_CONTEXT);
        try {
            updater.increment(key, 3L);
        }
        finally {
            if (updater != null) {
                updater.close();
            }
        }
        this.countsStore.checkpoint(FileFlushEvent.NULL, CursorContext.NULL_CONTEXT);
        this.closeCountsStore();
        final MutableBoolean rebuildTriggered = new MutableBoolean();
        this.instantiateCountsStore(new GBPTreeGenericCountsStore.Rebuilder(){

            public long lastCommittedTxId() {
                return countsStoreTxId + 2L;
            }

            public void rebuild(CountUpdater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
                rebuildTriggered.setTrue();
            }
        }, false, GBPTreeCountsStore.NO_MONITOR);
        try (CountUpdater updater = this.countsStore.updaterImpl(countsStoreTxId + 1L, true, CursorContext.NULL_CONTEXT);){
            updater.increment(key, 7L);
        }
        Assertions.assertThat((Object)this.countsStore.updaterImpl(countsStoreTxId + 2L, true, CursorContext.NULL_CONTEXT)).isNull();
        this.countsStore.start(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        Assertions.assertThat((boolean)rebuildTriggered.booleanValue()).isFalse();
        Assertions.assertThat((long)this.countsStore.read(key, CursorContext.NULL_CONTEXT)).isEqualTo(11L);
    }

    @Test
    void checkpointShouldAllowCacheSwitchesWhileFlushingTheTree() throws Exception {
        AtomicLong txId = new AtomicLong(1L);
        try (CountUpdater updaterBeforeCheckpoint = this.countsStore.updaterImpl(txId.incrementAndGet(), true, CursorContext.NULL_CONTEXT);){
            updaterBeforeCheckpoint.increment(GBPTreeCountsStore.nodeKey((int)251), 1L);
        }
        try (OtherThreadExecutor checkpointer = new OtherThreadExecutor("Checkpointer", 1L, TimeUnit.MINUTES);
             OtherThreadExecutor applier = new OtherThreadExecutor("Applier", 1L, TimeUnit.MINUTES);){
            FileFlushEvent fileFlushEvent = (FileFlushEvent)Mockito.spy((Object)FileFlushEvent.NULL);
            BinaryLatch latch = new BinaryLatch();
            ((FileFlushEvent)Mockito.doAnswer(invocationOnMock -> {
                latch.await();
                return 0;
            }).when((Object)fileFlushEvent)).startFlush((int[][])ArgumentMatchers.any());
            Future checkpoint = checkpointer.executeDontWait(OtherThreadExecutor.command(() -> this.countsStore.checkpoint(fileFlushEvent, CursorContext.NULL_CONTEXT)));
            checkpointer.waitUntilWaiting(location -> location.isAt(MultiRootGBPTree.class, "checkpoint"));
            for (int i = 0; i < 250; ++i) {
                long id = txId.incrementAndGet();
                try (CountUpdater countUpdater = this.countsStore.updaterImpl(id, true, CursorContext.NULL_CONTEXT);){
                    countUpdater.increment(GBPTreeCountsStore.nodeKey((int)((int)id)), 1L);
                    continue;
                }
            }
            latch.release();
            checkpoint.get();
        }
    }

    private CountsKey randomKey() {
        CountsKey key = new CountsKey();
        key.initialize((byte)this.random.nextInt(1, 5), this.random.nextLong(), this.random.nextInt());
        return key;
    }

    private void incrementNodeCount(long txId, int labelId, int delta) {
        try (CountUpdater updater = this.countsStore.updaterImpl(txId, true, CursorContext.NULL_CONTEXT);){
            if (updater != null) {
                updater.increment(GBPTreeCountsStore.nodeKey((int)labelId), (long)delta);
            }
        }
    }

    private void assertCountsMatchesExpected(ConcurrentMap<CountsKey, AtomicLong> source, long baseCount) {
        ConcurrentHashMap expected = new ConcurrentHashMap();
        source.entrySet().stream().filter(entry -> ((AtomicLong)entry.getValue()).get() != 0L).forEach(entry -> expected.put((CountsKey)entry.getKey(), (AtomicLong)entry.getValue()));
        this.countsStore.visitAllCounts((key, count) -> {
            AtomicLong expectedCount = (AtomicLong)expected.remove(key);
            if (expectedCount == null) {
                org.junit.jupiter.api.Assertions.assertEquals((long)baseCount, (long)count, () -> String.format("Counts store has wrong count for (absent) %s", key));
            } else {
                org.junit.jupiter.api.Assertions.assertEquals((long)(baseCount + expectedCount.get()), (long)count, () -> String.format("Counts store has wrong count for %s", key));
            }
        }, CursorContext.NULL_CONTEXT);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)expected.isEmpty(), expected::toString);
    }

    private void recover(long lastCheckPointedTxId, long lastCommittedTxId) {
        ConcurrentHashMap<CountsKey, AtomicLong> throwAwayMap = new ConcurrentHashMap<CountsKey, AtomicLong>();
        for (long txId = lastCheckPointedTxId + 1L; txId <= lastCommittedTxId; ++txId) {
            this.generateAndApplyTransaction(throwAwayMap, txId);
        }
    }

    private void generateAndApplyTransaction(ConcurrentMap<CountsKey, AtomicLong> expected, long txId) {
        Random rng = new Random(this.random.seed() + txId);
        try (CountUpdater updater = this.countsStore.updaterImpl(txId, true, CursorContext.NULL_CONTEXT);){
            if (updater != null) {
                int numberOfKeys = rng.nextInt(10);
                for (int j = 0; j < numberOfKeys; ++j) {
                    CountsKey expectedKey;
                    long delta = rng.nextInt(11) - 1;
                    if (rng.nextBoolean()) {
                        int labelId = GBPTreeGenericCountsStoreTest.randomTokenId(rng);
                        updater.increment(GBPTreeCountsStore.nodeKey((int)labelId), delta);
                        expectedKey = GBPTreeCountsStore.nodeKey((int)labelId);
                    } else {
                        int startLabelId = GBPTreeGenericCountsStoreTest.randomTokenId(rng);
                        int type = GBPTreeGenericCountsStoreTest.randomTokenId(rng);
                        int endLabelId = GBPTreeGenericCountsStoreTest.randomTokenId(rng);
                        updater.increment(GBPTreeCountsStore.relationshipKey((int)startLabelId, (long)type, (int)endLabelId), delta);
                        expectedKey = GBPTreeCountsStore.relationshipKey((int)startLabelId, (long)type, (int)endLabelId);
                    }
                    expected.computeIfAbsent(expectedKey, k -> new AtomicLong()).addAndGet(delta);
                }
            }
        }
    }

    private static int randomTokenId(Random rng) {
        return rng.nextInt(31) - 1;
    }

    private void checkpointAndRestartCountsStore() throws Exception {
        this.countsStore.checkpoint(FileFlushEvent.NULL, CursorContext.NULL_CONTEXT);
        this.closeCountsStore();
        this.openCountsStore();
    }

    private void crashAndRestartCountsStore() throws Exception {
        this.closeCountsStore();
        this.openCountsStore();
    }

    private void deleteCountsStore() throws IOException {
        this.directory.getFileSystem().deleteFile(this.countsStoreFile());
    }

    private Path countsStoreFile() {
        return this.directory.file("counts.db");
    }

    private void openCountsStore(GBPTreeGenericCountsStore.Rebuilder builder) throws IOException {
        this.instantiateCountsStore(builder, false, GBPTreeCountsStore.NO_MONITOR);
        this.countsStore.start(CursorContext.NULL_CONTEXT, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private void instantiateCountsStore(GBPTreeGenericCountsStore.Rebuilder builder, boolean readOnly, GBPTreeGenericCountsStore.Monitor monitor) throws IOException {
        this.countsStore = new GBPTreeGenericCountsStore(this.pageCache, this.countsStoreFile(), this.fs, RecoveryCleanupWorkCollector.immediate(), builder, readOnly, "test", monitor, "neo4j", this.randomMaxCacheSize(), (InternalLogProvider)NullLogProvider.getInstance(), CONTEXT_FACTORY, PageCacheTracer.NULL, this.getOpenOptions());
    }

    protected ImmutableSet<OpenOption> getOpenOptions() {
        return Sets.immutable.empty();
    }

    private static void assertZeroGlobalTracer(PageCacheTracer pageCacheTracer) {
        Assertions.assertThat((long)pageCacheTracer.faults()).isZero();
        Assertions.assertThat((long)pageCacheTracer.pins()).isZero();
        Assertions.assertThat((long)pageCacheTracer.unpins()).isZero();
        Assertions.assertThat((long)pageCacheTracer.hits()).isZero();
    }

    private static void assertZeroTracer(CursorContext cursorContext) {
        PageCursorTracer cursorTracer = cursorContext.getCursorTracer();
        Assertions.assertThat((long)cursorTracer.faults()).isZero();
        Assertions.assertThat((long)cursorTracer.pins()).isZero();
        Assertions.assertThat((long)cursorTracer.unpins()).isZero();
        Assertions.assertThat((long)cursorTracer.hits()).isZero();
    }

    private int randomMaxCacheSize() {
        return this.random.nextInt(10, 100);
    }

    private /* synthetic */ void lambda$shouldCheckpointAndRecoverConsistentlyUnderStressfulLoad$3(OutOfOrderSequence lastClosedTxId, AtomicLong lastCheckPointedTxId, int roundTimeMillis) throws Throwable {
        long checkpointTxId = lastClosedTxId.getHighestGapFreeNumber();
        this.countsStore.checkpoint(FileFlushEvent.NULL, CursorContext.NULL_CONTEXT);
        lastCheckPointedTxId.set(checkpointTxId);
        Thread.sleep(ThreadLocalRandom.current().nextInt(roundTimeMillis / 5));
    }

    private /* synthetic */ void lambda$shouldCheckpointAndRecoverConsistentlyUnderStressfulLoad$2(AtomicLong nextTxId, ConcurrentMap expected, OutOfOrderSequence lastClosedTxId) throws Throwable {
        long txId = nextTxId.incrementAndGet();
        Thread.sleep(ThreadLocalRandom.current().nextInt(5));
        this.generateAndApplyTransaction(expected, txId);
        lastClosedTxId.offer(txId, OutOfOrderSequence.EMPTY_META);
    }

    private static class TestableCountsBuilder
    implements GBPTreeGenericCountsStore.Rebuilder {
        private final long rebuiltAtTransactionId;
        boolean lastCommittedTxIdCalled;
        boolean rebuildCalled;

        TestableCountsBuilder(long rebuiltAtTransactionId) {
            this.rebuiltAtTransactionId = rebuiltAtTransactionId;
        }

        public void rebuild(CountUpdater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
            this.rebuildCalled = true;
        }

        public long lastCommittedTxId() {
            this.lastCommittedTxIdCalled = true;
            return this.rebuiltAtTransactionId;
        }
    }
}

