/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.primitive.IntSets;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.set.primitive.ImmutableIntSet;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.common.EntityType;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.ConstraintType;
import org.neo4j.internal.schema.FulltextSchemaDescriptor;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexQuery;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaCache;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.ExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.KeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.storageengine.api.ConstraintRuleAccessor;
import org.neo4j.storageengine.api.StandardConstraintRuleAccessor;
import org.neo4j.test.Race;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.ValueCategory;

class SchemaCacheTest {
    private final SchemaRule hans = SchemaCacheTest.newIndexRule(1L, 0, 5);
    private final SchemaRule witch = SchemaCacheTest.nodePropertyExistenceConstraint(2L, 3, 6);
    private final SchemaRule gretel = SchemaCacheTest.newIndexRule(3L, 0, 7);
    private final ConstraintDescriptor robot = SchemaCacheTest.relPropertyExistenceConstraint(7L, 8, 9);
    private final IndexConfigCompleter indexConfigCompleter = (index, indexingBehaviour) -> index;
    private static final int[] noEntityToken = ArrayUtils.EMPTY_INT_ARRAY;
    private final IndexDescriptor schema3_4 = SchemaCacheTest.newIndexRule(10L, 3, 4);
    private final IndexDescriptor schema5_6_7 = SchemaCacheTest.newIndexRule(11L, 5, 6, 7);
    private final IndexDescriptor schema5_8 = SchemaCacheTest.newIndexRule(12L, 5, 8);
    private final IndexDescriptor node35_8 = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.fulltext((EntityType)EntityType.NODE, (int[])new int[]{3, 5}, (int[])new int[]{8})).withName("index_13").materialise(13L);
    private final IndexDescriptor rel35_8 = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])new int[]{3, 5}, (int[])new int[]{8})).withName("index_14").materialise(14L);

    SchemaCacheTest() {
    }

    @Test
    void shouldConstructSchemaCache() {
        SchemaCache cache = this.newSchemaCache(new SchemaRule[]{this.hans, this.witch, this.gretel, this.robot});
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new SchemaRule[]{this.hans, this.gretel}), (Object)Iterables.asSet((Iterable)cache.indexes()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new SchemaRule[]{this.witch, this.robot}), (Object)Iterables.asSet((Iterable)cache.constraints()));
    }

    @Test
    void addRemoveIndexes() {
        SchemaCache cache = this.newSchemaCache(new SchemaRule[]{this.hans, this.witch, this.gretel, this.robot});
        IndexDescriptor rule1 = SchemaCacheTest.newIndexRule(10L, 11, 12);
        IndexDescriptor rule2 = SchemaCacheTest.newIndexRule(13L, 14, 15);
        cache.addSchemaRule((SchemaRule)rule1);
        cache.addSchemaRule((SchemaRule)rule2);
        cache.removeSchemaRule(this.hans.getId());
        cache.removeSchemaRule(this.witch.getId());
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new SchemaRule[]{this.gretel, rule1, rule2}), (Object)Iterables.asSet((Iterable)cache.indexes()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{this.robot}), (Object)Iterables.asSet((Iterable)cache.constraints()));
    }

    @Test
    void addSchemaRules() {
        SchemaCache cache = this.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule(this.hans);
        cache.addSchemaRule(this.gretel);
        cache.addSchemaRule(this.witch);
        cache.addSchemaRule((SchemaRule)this.robot);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new SchemaRule[]{this.hans, this.gretel}), (Object)Iterables.asSet((Iterable)cache.indexes()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new SchemaRule[]{this.witch, this.robot}), (Object)Iterables.asSet((Iterable)cache.constraints()));
    }

    @Test
    void shouldListConstraints() {
        SchemaCache cache = this.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.uniquenessConstraint(0L, 1, 2, 133L));
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.uniquenessConstraint(1L, 3, 4, 133L));
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.relPropertyExistenceConstraint(2L, 5, 6));
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.nodePropertyExistenceConstraint(3L, 7, 8));
        UniquenessConstraintDescriptor unique1 = ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{2});
        UniquenessConstraintDescriptor unique2 = ConstraintDescriptorFactory.uniqueForLabel((int)3, (int[])new int[]{4});
        ExistenceConstraintDescriptor existsRel = ConstraintDescriptorFactory.existsForRelType((int)5, (int[])new int[]{6});
        ExistenceConstraintDescriptor existsNode = ConstraintDescriptorFactory.existsForLabel((int)7, (int[])new int[]{8});
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{unique1, unique2, existsRel, existsNode}), (Object)Iterables.asSet((Iterable)cache.constraints()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{unique1}), (Object)Iterators.asSet((Iterator)cache.constraintsForLabel(1)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{unique1}), (Object)Iterators.asSet((Iterator)cache.constraintsForSchema(unique1.schema())));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new Object[0]), (Object)Iterators.asSet((Iterator)cache.constraintsForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{3}))));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{existsRel}), (Object)Iterators.asSet((Iterator)cache.constraintsForRelationshipType(5)));
    }

    @Test
    void shouldRemoveConstraints() {
        SchemaCache cache = this.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.uniquenessConstraint(0L, 1, 2, 133L));
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.uniquenessConstraint(1L, 3, 4, 133L));
        cache.removeSchemaRule(0L);
        UniquenessConstraintDescriptor dropped = ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{1});
        UniquenessConstraintDescriptor unique = ConstraintDescriptorFactory.uniqueForLabel((int)3, (int[])new int[]{4});
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{unique}), (Object)Iterables.asSet((Iterable)cache.constraints()));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new Object[0]), (Object)Iterators.asSet((Iterator)cache.constraintsForLabel(1)));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new Object[0]), (Object)Iterators.asSet((Iterator)cache.constraintsForSchema(dropped.schema())));
    }

    @Test
    void addingConstraintsShouldBeIdempotent() {
        SchemaCache cache = this.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.uniquenessConstraint(0L, 1, 2, 133L));
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.uniquenessConstraint(0L, 1, 2, 133L));
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singletonList(ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{2})), (Object)Iterables.asList((Iterable)cache.constraints()));
    }

    @Test
    void shouldResolveIndexDescriptor() {
        SchemaCache cache = this.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.newIndexRule(1L, 1, 2));
        IndexDescriptor expected = SchemaCacheTest.newIndexRule(2L, 1, 3);
        cache.addSchemaRule((SchemaRule)expected);
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.newIndexRule(3L, 2, 2));
        IndexDescriptor actual = (IndexDescriptor)Iterators.single((Iterator)cache.indexesForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{3})));
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }

    @Test
    void shouldResolveIndexDescriptorBySchemaAndType() {
        SchemaCache cache = this.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.newIndexRule(1L, 1, 2));
        IndexDescriptor expected = SchemaCacheTest.newIndexRule(2L, IndexType.TEXT, 1, 3);
        cache.addSchemaRule((SchemaRule)expected);
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.newIndexRule(3L, 2, 2));
        IndexDescriptor actual = cache.indexForSchemaAndType((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{3}), IndexType.TEXT);
        IndexDescriptor wrongType = cache.indexForSchemaAndType((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{3}), IndexType.RANGE);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
        Assertions.assertThat((Object)wrongType).isNull();
    }

    @Test
    void shouldResolveMultipleIndexDescriptorsForSameSchema() {
        SchemaCache cache = this.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.newIndexRule(1L, 1, 2));
        IndexDescriptor expected = SchemaCacheTest.newIndexRule(2L, IndexType.RANGE, 1, 3);
        cache.addSchemaRule((SchemaRule)expected);
        IndexDescriptor expected2 = SchemaCacheTest.newIndexRule(3L, IndexType.TEXT, 1, 3);
        cache.addSchemaRule((SchemaRule)expected2);
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.newIndexRule(4L, 2, 2));
        IndexDescriptor actual = cache.indexForSchemaAndType((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{3}), IndexType.RANGE);
        IndexDescriptor actual2 = cache.indexForSchemaAndType((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{3}), IndexType.TEXT);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
        Assertions.assertThat((Object)actual2).isEqualTo((Object)expected2);
    }

    @Test
    void shouldStoreMultipleIndexDescriptorsForSameSchema() {
        SchemaCache cache = this.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.newIndexRule(1L, 1, 2));
        IndexDescriptor expected = SchemaCacheTest.newIndexRule(2L, IndexType.RANGE, 1, 3);
        cache.addSchemaRule((SchemaRule)expected);
        IndexDescriptor expected2 = SchemaCacheTest.newIndexRule(3L, IndexType.TEXT, 1, 3);
        cache.addSchemaRule((SchemaRule)expected2);
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.newIndexRule(4L, 2, 2));
        Iterator actual = cache.indexesForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{3}));
        Assertions.assertThat((Iterator)actual).toIterable().containsExactlyInAnyOrder((Object[])new IndexDescriptor[]{expected, expected2});
    }

    @Test
    void shouldStoreMultipleConstraintDescriptorsForSameSchema() {
        SchemaCache cache = this.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.uniquenessConstraint(1L, 1, 2, 3L));
        ConstraintDescriptor expected = SchemaCacheTest.uniquenessConstraint(2L, 1, 3, 4L, IndexType.TEXT);
        cache.addSchemaRule((SchemaRule)expected);
        ConstraintDescriptor expected2 = SchemaCacheTest.uniquenessConstraint(3L, 1, 3, 5L, IndexType.RANGE);
        cache.addSchemaRule((SchemaRule)expected2);
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.uniquenessConstraint(4L, 1, 2, 6L));
        Iterator actual = cache.constraintsForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{3}));
        Assertions.assertThat((Iterator)actual).toIterable().containsExactlyInAnyOrder((Object[])new ConstraintDescriptor[]{expected, expected2});
    }

    @Test
    void shouldReturnImmutableIteratorFromIndexesForSchema() {
        SchemaCache cache = this.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.newIndexRule(2L, IndexType.RANGE, 1, 3));
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.newIndexRule(3L, IndexType.TEXT, 1, 3));
        Iterator actual = cache.indexesForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{3}));
        actual.next();
        Assertions.assertThatThrownBy(actual::remove).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void shouldRelpaceEquialentIndex() {
        SchemaCache cache = this.newSchemaCache(new SchemaRule[0]);
        LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)1, (int[])new int[]{3});
        IndexDescriptor index = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema).withName("index_id").withIndexType(IndexType.TEXT).materialise(2L);
        cache.addSchemaRule((SchemaRule)index);
        IndexDescriptor updated = index.withOwningConstraintId(6L);
        cache.addSchemaRule((SchemaRule)updated);
        Assertions.assertThat((Iterator)cache.indexesForSchema((SchemaDescriptor)schema)).toIterable().containsOnly((Object[])new IndexDescriptor[]{updated});
        Assertions.assertThat((Object)cache.indexForSchemaAndType((SchemaDescriptor)schema, IndexType.TEXT)).isEqualTo((Object)updated);
    }

    @Test
    void shouldRemoveWhenMultipeIndexDescriptorsForSameSchema() {
        int label = 2;
        SchemaCache cache = this.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.newIndexRule(1L, 2, 2));
        IndexDescriptor expected = SchemaCacheTest.newIndexRule(2L, IndexType.RANGE, 2, 3);
        cache.addSchemaRule((SchemaRule)expected);
        IndexDescriptor expected2 = SchemaCacheTest.newIndexRule(3L, IndexType.TEXT, 2, 3);
        cache.addSchemaRule((SchemaRule)expected2);
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.newIndexRule(4L, 3, 2));
        cache.removeSchemaRule(expected.getId());
        LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)2, (int[])new int[]{3});
        Assertions.assertThat((Iterator)cache.indexesForSchema((SchemaDescriptor)schema)).toIterable().containsExactlyInAnyOrder((Object[])new IndexDescriptor[]{expected2});
        Assertions.assertThat((Object)cache.indexForSchemaAndType((SchemaDescriptor)schema, IndexType.TEXT)).isEqualTo((Object)expected2);
    }

    @Test
    void schemaCacheSnapshotsShouldBeReadOnly() {
        SchemaCache cache = this.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.newIndexRule(1L, 1, 2));
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.newIndexRule(2L, 2, 3));
        SchemaCache snapshot = cache.snapshot();
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.newIndexRule(3L, 1, 4));
        Set indexes = Iterators.asSet((Iterator)snapshot.indexesForLabel(1));
        Set expected = Iterators.asSet((Object[])new IndexDescriptor[]{SchemaCacheTest.newIndexRule(1L, 1, 2)});
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)indexes);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> snapshot.addSchemaRule((SchemaRule)SchemaCacheTest.newIndexRule(3L, 1, 4))).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Schema cache snapshots are read-only");
    }

    @Test
    void shouldReturnEmptyWhenNoIndexExists() {
        SchemaCache schemaCache = this.newSchemaCache(new SchemaRule[0]);
        Iterator iterator = schemaCache.indexesForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{1}));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    void shouldListConstraintsForLabel() {
        ConstraintDescriptor rule1 = SchemaCacheTest.uniquenessConstraint(0L, 1, 1, 0L);
        ConstraintDescriptor rule2 = SchemaCacheTest.uniquenessConstraint(1L, 2, 1, 0L);
        ConstraintDescriptor rule3 = SchemaCacheTest.nodePropertyExistenceConstraint(2L, 1, 2);
        SchemaCache cache = this.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)rule1);
        cache.addSchemaRule((SchemaRule)rule2);
        cache.addSchemaRule((SchemaRule)rule3);
        Set listed = Iterators.asSet((Iterator)cache.constraintsForLabel(1));
        Set expected = Iterators.asSet((Object[])new ConstraintDescriptor[]{rule1, rule3});
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)listed);
    }

    @Test
    void shouldListConstraintsForSchema() {
        ConstraintDescriptor rule1 = SchemaCacheTest.uniquenessConstraint(0L, 1, 1, 0L);
        ConstraintDescriptor rule2 = SchemaCacheTest.uniquenessConstraint(1L, 2, 1, 0L);
        ConstraintDescriptor rule3 = SchemaCacheTest.nodePropertyExistenceConstraint(2L, 1, 2);
        SchemaCache cache = this.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)rule1);
        cache.addSchemaRule((SchemaRule)rule2);
        cache.addSchemaRule((SchemaRule)rule3);
        Set listed = Iterators.asSet((Iterator)cache.constraintsForSchema(rule3.schema()));
        org.junit.jupiter.api.Assertions.assertEquals(Collections.singleton(rule3), (Object)listed);
    }

    @Test
    void shouldListConstraintsForRelationshipType() {
        ConstraintDescriptor rule1 = SchemaCacheTest.relPropertyExistenceConstraint(0L, 1, 1);
        ConstraintDescriptor rule2 = SchemaCacheTest.relPropertyExistenceConstraint(1L, 2, 1);
        ConstraintDescriptor rule3 = SchemaCacheTest.relPropertyExistenceConstraint(2L, 1, 2);
        SchemaCache cache = this.newSchemaCache(new SchemaRule[0]);
        cache.addSchemaRule((SchemaRule)rule1);
        cache.addSchemaRule((SchemaRule)rule2);
        cache.addSchemaRule((SchemaRule)rule3);
        Set listed = Iterators.asSet((Iterator)cache.constraintsForRelationshipType(1));
        Set expected = Iterators.asSet((Object[])new ConstraintDescriptor[]{rule1, rule3});
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)listed);
    }

    @Test
    void concurrentSchemaRuleAdd() throws Throwable {
        SchemaCache cache = this.newSchemaCache(new SchemaRule[0]);
        Race race = new Race();
        int indexNumber = 10;
        int i = 0;
        while (i < indexNumber) {
            int id = i++;
            race.addContestant(() -> cache.addSchemaRule((SchemaRule)SchemaCacheTest.newIndexRule((long)id, id, id)));
        }
        race.go();
        org.junit.jupiter.api.Assertions.assertEquals((long)indexNumber, (long)Iterables.count((Iterable)cache.indexes()));
        for (int labelId = 0; labelId < indexNumber; ++labelId) {
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)Iterators.count((Iterator)cache.indexesForLabel(labelId)));
        }
    }

    @Test
    void concurrentSchemaRuleRemove() throws Throwable {
        SchemaCache cache = this.newSchemaCache(new SchemaRule[0]);
        int indexNumber = 20;
        for (int i = 0; i < indexNumber; ++i) {
            cache.addSchemaRule((SchemaRule)SchemaCacheTest.newIndexRule((long)i, i, i));
        }
        Race race = new Race();
        int numberOfDeletions = 10;
        int i = 0;
        while (i < numberOfDeletions) {
            int indexId = i++;
            race.addContestant(() -> cache.removeSchemaRule((long)indexId));
        }
        race.go();
        org.junit.jupiter.api.Assertions.assertEquals((long)(indexNumber - numberOfDeletions), (long)Iterables.count((Iterable)cache.indexes()));
        for (int labelId = numberOfDeletions; labelId < indexNumber; ++labelId) {
            org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)Iterators.count((Iterator)cache.indexesForLabel(labelId)));
        }
    }

    @Test
    void removeSchemaWithRepeatedLabel() {
        SchemaCache cache = this.newSchemaCache(new SchemaRule[0]);
        boolean id = true;
        int[] repeatedLabels = new int[]{0, 1, 0};
        FulltextSchemaDescriptor schema = SchemaDescriptors.fulltext((EntityType)EntityType.NODE, (int[])repeatedLabels, (int[])new int[]{1});
        IndexDescriptor index = SchemaCacheTest.newIndexRule((SchemaDescriptor)schema, 1L);
        cache.addSchemaRule((SchemaRule)index);
        cache.removeSchemaRule(1L);
    }

    @Test
    void removeSchemaWithRepeatedRelType() {
        SchemaCache cache = this.newSchemaCache(new SchemaRule[0]);
        boolean id = true;
        int[] repeatedRelTypes = new int[]{0, 1, 0};
        FulltextSchemaDescriptor schema = SchemaDescriptors.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])repeatedRelTypes, (int[])new int[]{1});
        IndexDescriptor index = SchemaCacheTest.newIndexRule((SchemaDescriptor)schema, 1L);
        cache.addSchemaRule((SchemaRule)index);
        cache.removeSchemaRule(1L);
    }

    @Test
    void shouldGetRelatedIndexForLabel() {
        SchemaCache cache = this.newSchemaCacheWithRulesForRelatedToCalls();
        Assertions.assertThat((Collection)cache.getValueIndexesRelatedTo(SchemaCacheTest.entityTokens(3), noEntityToken, SchemaCacheTest.properties(new int[0]), false, EntityType.NODE)).contains((Object[])new IndexDescriptor[]{this.schema3_4, this.node35_8});
    }

    @Test
    void shouldGetRelatedIndexForProperty() {
        SchemaCache cache = this.newSchemaCacheWithRulesForRelatedToCalls();
        Assertions.assertThat((Collection)cache.getValueIndexesRelatedTo(noEntityToken, SchemaCacheTest.entityTokens(3, 4, 5), SchemaCacheTest.properties(4), false, EntityType.NODE)).contains((Object[])new IndexDescriptor[]{this.schema3_4});
    }

    @Test
    void shouldGetRelatedIndexesForLabel() {
        SchemaCache cache = this.newSchemaCacheWithRulesForRelatedToCalls();
        Assertions.assertThat((Collection)cache.getValueIndexesRelatedTo(SchemaCacheTest.entityTokens(5), SchemaCacheTest.entityTokens(3, 4), SchemaCacheTest.properties(new int[0]), false, EntityType.NODE)).contains((Object[])new IndexDescriptor[]{this.schema5_6_7, this.schema5_8, this.node35_8});
    }

    @Test
    void shouldGetRelatedIndexes() {
        SchemaCache cache = this.newSchemaCacheWithRulesForRelatedToCalls();
        Assertions.assertThat((Collection)cache.getValueIndexesRelatedTo(SchemaCacheTest.entityTokens(3), SchemaCacheTest.entityTokens(4, 5), SchemaCacheTest.properties(7), false, EntityType.NODE)).contains((Object[])new IndexDescriptor[]{this.schema3_4, this.schema5_6_7, this.node35_8});
    }

    @Test
    void shouldGetRelatedIndexOnce() {
        SchemaCache cache = this.newSchemaCacheWithRulesForRelatedToCalls();
        Assertions.assertThat((Collection)cache.getValueIndexesRelatedTo(SchemaCacheTest.entityTokens(3), noEntityToken, SchemaCacheTest.properties(4), false, EntityType.NODE)).contains((Object[])new IndexDescriptor[]{this.schema3_4, this.node35_8});
        Assertions.assertThat((Collection)cache.getValueIndexesRelatedTo(noEntityToken, SchemaCacheTest.entityTokens(5), SchemaCacheTest.properties(6, 7), false, EntityType.NODE)).contains((Object[])new IndexDescriptor[]{this.schema5_6_7});
    }

    @Test
    void shouldHandleUnrelated() {
        SchemaCache cache = this.newSchemaCacheWithRulesForRelatedToCalls();
        Assertions.assertThat((Collection)cache.getValueIndexesRelatedTo(noEntityToken, noEntityToken, SchemaCacheTest.properties(new int[0]), false, EntityType.NODE)).isEmpty();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)cache.getValueIndexesRelatedTo(SchemaCacheTest.entityTokens(2), noEntityToken, SchemaCacheTest.properties(new int[0]), false, EntityType.NODE).isEmpty());
        Assertions.assertThat((Collection)cache.getValueIndexesRelatedTo(noEntityToken, SchemaCacheTest.entityTokens(2), SchemaCacheTest.properties(1), false, EntityType.NODE)).isEmpty();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)cache.getValueIndexesRelatedTo(SchemaCacheTest.entityTokens(2), SchemaCacheTest.entityTokens(2), SchemaCacheTest.properties(1), false, EntityType.NODE).isEmpty());
    }

    @Test
    void shouldGetMultiLabelForAnyOfTheLabels() {
        SchemaCache cache = this.newSchemaCacheWithRulesForRelatedToCalls();
        Assertions.assertThat((Collection)cache.getValueIndexesRelatedTo(SchemaCacheTest.entityTokens(3), noEntityToken, SchemaCacheTest.properties(new int[0]), false, EntityType.NODE)).contains((Object[])new IndexDescriptor[]{this.schema3_4, this.node35_8});
        Assertions.assertThat((Collection)cache.getValueIndexesRelatedTo(SchemaCacheTest.entityTokens(5), noEntityToken, SchemaCacheTest.properties(new int[0]), false, EntityType.NODE)).contains((Object[])new IndexDescriptor[]{this.schema5_8, this.schema5_6_7, this.node35_8});
    }

    @Test
    void shouldOnlyGetRelIndexesForRelUpdates() {
        SchemaCache cache = this.newSchemaCacheWithRulesForRelatedToCalls();
        Assertions.assertThat((Collection)cache.getValueIndexesRelatedTo(SchemaCacheTest.entityTokens(3), noEntityToken, SchemaCacheTest.properties(new int[0]), false, EntityType.RELATIONSHIP)).contains((Object[])new IndexDescriptor[]{this.rel35_8});
        Assertions.assertThat((Collection)cache.getValueIndexesRelatedTo(SchemaCacheTest.entityTokens(5), noEntityToken, SchemaCacheTest.properties(new int[0]), false, EntityType.RELATIONSHIP)).contains((Object[])new IndexDescriptor[]{this.rel35_8});
    }

    @Test
    void removalsShouldOnlyRemoveCorrectProxy() {
        SchemaCache cache = this.newSchemaCacheWithRulesForRelatedToCalls();
        cache.removeSchemaRule(this.node35_8.getId());
        Assertions.assertThat((Collection)cache.getValueIndexesRelatedTo(SchemaCacheTest.entityTokens(3), noEntityToken, SchemaCacheTest.properties(new int[0]), false, EntityType.NODE)).contains((Object[])new IndexDescriptor[]{this.schema3_4});
        Assertions.assertThat((Collection)cache.getValueIndexesRelatedTo(SchemaCacheTest.entityTokens(3), noEntityToken, SchemaCacheTest.properties(new int[0]), false, EntityType.RELATIONSHIP)).contains((Object[])new IndexDescriptor[]{this.rel35_8});
        cache.removeSchemaRule(7L);
        Assertions.assertThat((Collection)cache.getValueIndexesRelatedTo(SchemaCacheTest.entityTokens(5), noEntityToken, SchemaCacheTest.properties(new int[0]), false, EntityType.NODE)).contains((Object[])new IndexDescriptor[]{this.schema5_8, this.schema5_6_7});
        Assertions.assertThat((Collection)cache.getValueIndexesRelatedTo(SchemaCacheTest.entityTokens(5), noEntityToken, SchemaCacheTest.properties(new int[0]), false, EntityType.RELATIONSHIP)).contains((Object[])new IndexDescriptor[]{this.rel35_8});
    }

    @Test
    void shouldGetRelatedNodeConstraints() {
        SchemaCache cache = new SchemaCache((ConstraintRuleAccessor)new ConstraintSemantics(), this.indexConfigCompleter, StorageEngineIndexingBehaviour.EMPTY);
        UniquenessConstraintDescriptor constraint1 = ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{5, 6}).withId(1L);
        UniquenessConstraintDescriptor constraint2 = ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{5}).withId(2L);
        UniquenessConstraintDescriptor constraint3 = ConstraintDescriptorFactory.uniqueForLabel((int)2, (int[])new int[]{5}).withId(3L);
        cache.addSchemaRule((SchemaRule)constraint1);
        cache.addSchemaRule((SchemaRule)constraint2);
        cache.addSchemaRule((SchemaRule)constraint3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{constraint2}), (Object)cache.getUniquenessConstraintsRelatedTo(SchemaCacheTest.entityTokens(1), SchemaCacheTest.entityTokens(new int[0]), SchemaCacheTest.properties(5), true, EntityType.NODE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{constraint1, constraint2}), (Object)cache.getUniquenessConstraintsRelatedTo(SchemaCacheTest.entityTokens(1), SchemaCacheTest.entityTokens(new int[0]), SchemaCacheTest.properties(5), false, EntityType.NODE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{constraint1, constraint2}), (Object)cache.getUniquenessConstraintsRelatedTo(SchemaCacheTest.entityTokens(1), SchemaCacheTest.entityTokens(new int[0]), SchemaCacheTest.properties(5, 6), true, EntityType.NODE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{constraint1, constraint2}), (Object)cache.getUniquenessConstraintsRelatedTo(SchemaCacheTest.entityTokens(new int[0]), SchemaCacheTest.entityTokens(1), SchemaCacheTest.properties(5), false, EntityType.NODE));
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{constraint1, constraint2, constraint3}), (Object)cache.getUniquenessConstraintsRelatedTo(SchemaCacheTest.entityTokens(1, 2), SchemaCacheTest.entityTokens(new int[0]), SchemaCacheTest.properties(new int[0]), false, EntityType.NODE));
    }

    @Test
    void shouldRemoveNodeConstraints() {
        SchemaCache cache = new SchemaCache((ConstraintRuleAccessor)new ConstraintSemantics(), this.indexConfigCompleter, StorageEngineIndexingBehaviour.EMPTY);
        UniquenessConstraintDescriptor constraint1 = ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{5, 6}).withId(1L);
        UniquenessConstraintDescriptor constraint2 = ConstraintDescriptorFactory.uniqueForLabel((int)1, (int[])new int[]{5}).withId(2L);
        UniquenessConstraintDescriptor constraint3 = ConstraintDescriptorFactory.uniqueForLabel((int)2, (int[])new int[]{5}).withId(3L);
        cache.addSchemaRule((SchemaRule)constraint1);
        cache.addSchemaRule((SchemaRule)constraint2);
        cache.addSchemaRule((SchemaRule)constraint3);
        org.junit.jupiter.api.Assertions.assertEquals((Object)Iterators.asSet((Object[])new ConstraintDescriptor[]{constraint2}), (Object)cache.getUniquenessConstraintsRelatedTo(SchemaCacheTest.entityTokens(1), SchemaCacheTest.entityTokens(new int[0]), SchemaCacheTest.properties(5), true, EntityType.NODE));
        cache.removeSchemaRule(constraint1.getId());
        cache.removeSchemaRule(constraint2.getId());
        cache.removeSchemaRule(constraint3.getId());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)cache.getUniquenessConstraintsRelatedTo(SchemaCacheTest.entityTokens(1), SchemaCacheTest.entityTokens(new int[0]), SchemaCacheTest.properties(5), true, EntityType.NODE).isEmpty());
    }

    @Test
    void shouldCompleteConfigurationOfIndexesAddedToCache() {
        IndexCapability capability = new IndexCapability(){

            public boolean supportsOrdering() {
                return false;
            }

            public boolean supportsReturningValues() {
                return false;
            }

            public boolean areValueCategoriesAccepted(ValueCategory ... valueCategories) {
                Preconditions.requireNonEmpty((Object[])valueCategories);
                Preconditions.requireNoNullElements((Object[])valueCategories);
                return true;
            }

            public boolean isQuerySupported(IndexQuery.IndexQueryType queryType, ValueCategory valueCategory) {
                return true;
            }

            public double getCostMultiplier(IndexQuery.IndexQueryType ... queryTypes) {
                return 1.0;
            }

            public boolean supportPartitionedScan(IndexQuery ... queries) {
                Preconditions.requireNonEmpty((Object[])queries);
                Preconditions.requireNoNullElements((Object[])queries);
                return false;
            }
        };
        ArrayList completed = new ArrayList();
        IndexConfigCompleter completer = (index, indexingBehaviour) -> {
            completed.add(index);
            return index.withIndexCapability(capability);
        };
        SchemaCache cache = new SchemaCache((ConstraintRuleAccessor)new ConstraintSemantics(), completer, StorageEngineIndexingBehaviour.EMPTY);
        IndexDescriptor index1 = SchemaCacheTest.newIndexRule(1L, 2, 3);
        ConstraintDescriptor constraint1 = SchemaCacheTest.uniquenessConstraint(2L, 2, 3, 1L);
        IndexDescriptor index2 = SchemaCacheTest.newIndexRule(3L, 4, 5);
        ConstraintDescriptor constraint2 = SchemaCacheTest.uniquenessConstraint(4L, 4, 5, 3L);
        IndexDescriptor index3 = SchemaCacheTest.newIndexRule(5L, 5, 5);
        cache.load(Arrays.asList(index1, constraint1));
        cache.addSchemaRule((SchemaRule)index2);
        cache.addSchemaRule((SchemaRule)constraint2);
        cache.addSchemaRule((SchemaRule)index3);
        org.junit.jupiter.api.Assertions.assertEquals(List.of(index1, index2, index3), completed);
        org.junit.jupiter.api.Assertions.assertEquals((Object)capability, (Object)cache.getIndex(index1.getId()).getCapability());
        org.junit.jupiter.api.Assertions.assertEquals((Object)capability, (Object)cache.getIndex(index2.getId()).getCapability());
        org.junit.jupiter.api.Assertions.assertEquals((Object)capability, (Object)cache.getIndex(index3.getId()).getCapability());
    }

    @Test
    void shouldHaveAddedConstraintsAndIndexes() {
        long constraintId = 1L;
        long indexId = 4L;
        IndexDescriptor index = SchemaCacheTest.newIndexRule(indexId, 2, 3);
        ConstraintDescriptor constraint = SchemaCacheTest.uniquenessConstraint(constraintId, 2, 3, indexId);
        SchemaCache cache = this.newSchemaCache(new SchemaRule[]{index, constraint});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)cache.hasConstraintRule(Long.valueOf(constraintId)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)cache.hasConstraintRule(constraint));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)cache.hasConstraintRule(Long.valueOf(indexId)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)cache.hasIndex(index));
    }

    @Test
    void hasConstraintRuleShouldMatchBySchemaAndTypeAndIndexType() {
        ConstraintDescriptor existing = SchemaCacheTest.uniquenessConstraint(1L, 2, 3, 4L, IndexType.RANGE);
        ConstraintDescriptor checked = SchemaCacheTest.uniquenessConstraint(0L, 2, 3, 4L, IndexType.RANGE);
        SchemaCache cache = this.newSchemaCache(new SchemaRule[]{existing});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)cache.hasConstraintRule(checked));
    }

    @Test
    void hasConstraintRuleShouldNotMatchOnDifferentIndexType() {
        ConstraintDescriptor existing = SchemaCacheTest.uniquenessConstraint(1L, 2, 4, 5L, IndexType.TEXT);
        ConstraintDescriptor checked = SchemaCacheTest.uniquenessConstraint(0L, 2, 4, 5L, IndexType.RANGE);
        SchemaCache cache = this.newSchemaCache(new SchemaRule[]{existing});
        org.junit.jupiter.api.Assertions.assertFalse((boolean)cache.hasConstraintRule(checked));
    }

    @Test
    void shouldCacheDependentState() {
        SchemaCache cache = this.newSchemaCache(new SchemaRule[0]);
        MutableInt mint = (MutableInt)cache.getOrCreateDependantState(MutableInt.class, MutableInt::new, (Object)1);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (Integer)mint.getValue());
        mint.setValue(2);
        mint = (MutableInt)cache.getOrCreateDependantState(MutableInt.class, MutableInt::new, (Object)1);
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (Integer)mint.getValue());
    }

    @Test
    void shouldFindIndexDescriptorsByRelationshipType() {
        IndexDescriptor first = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forRelType((int)2, (int[])new int[]{3})).withName("index_1").materialise(1L);
        IndexDescriptor second = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)2, (int[])new int[]{3})).withName("index_2").materialise(2L);
        SchemaCache cache = this.newSchemaCache(new SchemaRule[]{first, second});
        org.junit.jupiter.api.Assertions.assertEquals((Object)first, (Object)Iterators.single((Iterator)cache.indexesForRelationshipType(2)));
        org.junit.jupiter.api.Assertions.assertEquals((long)first.getId(), (long)((IndexDescriptor)Iterators.single((Iterator)cache.indexesForRelationshipType(2))).getId());
    }

    @Test
    void shouldFindIndexDescriptorsByIndexName() {
        IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)2, (int[])new int[]{3})).withName("index name").materialise(1L);
        SchemaCache cache = this.newSchemaCache(new SchemaRule[]{index});
        org.junit.jupiter.api.Assertions.assertEquals((Object)index, (Object)cache.indexForName("index name"));
        cache.removeSchemaRule(index.getId());
        org.junit.jupiter.api.Assertions.assertNull((Object)cache.indexForName("index name"));
    }

    @Test
    void shouldFindConstraintByName() {
        ConstraintDescriptor constraint = SchemaCacheTest.nodePropertyExistenceConstraint(1L, 2, 3).withName("constraint name");
        SchemaCache cache = this.newSchemaCache(new SchemaRule[]{constraint});
        org.junit.jupiter.api.Assertions.assertEquals((Object)constraint, (Object)cache.constraintForName("constraint name"));
        cache.removeSchemaRule(constraint.getId());
        org.junit.jupiter.api.Assertions.assertNull((Object)cache.constraintForName("constraint name"));
    }

    @Test
    void shouldFindConstraintAndIndexByName() {
        IndexDescriptor index = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)2, (int[])new int[]{3})).withName("schema name").materialise(1L);
        ConstraintDescriptor constraint = SchemaCacheTest.uniquenessConstraint(4L, 2, 3, 1L).withName("schema name");
        SchemaCache cache = this.newSchemaCache(new SchemaRule[]{index, constraint});
        org.junit.jupiter.api.Assertions.assertEquals((Object)index, (Object)cache.indexForName("schema name"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)constraint, (Object)cache.constraintForName("schema name"));
    }

    @Test
    void logicalKeyConstraintsForNodeKey() {
        String schemaName = "schema name";
        int labelId = 2;
        int propertyId = 3;
        LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)2, (int[])new int[]{3});
        IndexDescriptor index = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema).withName("schema name").materialise(1L);
        KeyConstraintDescriptor constraint = ConstraintDescriptorFactory.keyForSchema((SchemaDescriptor)schema).withId(42L).withOwnedIndexId(index.getId()).withName("schema name");
        SchemaCache cache = this.newSchemaCache(new SchemaRule[]{index, constraint});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])cache.constraintsGetPropertyTokensForLogicalKey(2, EntityType.NODE)).as("should find the property that makes up the logical key for the node/label", new Object[0])).isEqualTo((Object)SchemaCacheTest.logicalKeys(3));
        ((ObjectArrayAssert)Assertions.assertThat((Object[])cache.constraintsGetPropertyTokensForLogicalKey(3, EntityType.NODE)).as("should NOT find any logical key for the node/label", new Object[0])).isEqualTo((Object)SchemaCache.NO_LOGICAL_KEYS);
    }

    @Test
    void logicalKeysWithMultipleConstraintsForNodeKey() {
        int labelId = 2;
        int propertyId1 = 3;
        int propertyId2 = 4;
        int propertyId3 = 5;
        LabelSchemaDescriptor schema1 = SchemaDescriptors.forLabel((int)2, (int[])new int[]{3});
        LabelSchemaDescriptor schema2 = SchemaDescriptors.forLabel((int)2, (int[])new int[]{4, 5});
        IndexDescriptor index1 = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema1).withName("i1").materialise(1L);
        IndexDescriptor index2 = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema2).withName("i2").materialise(2L);
        KeyConstraintDescriptor c1 = ConstraintDescriptorFactory.keyForSchema((SchemaDescriptor)schema1).withName("c1").withId(42L).withOwnedIndexId(index1.getId());
        KeyConstraintDescriptor c2 = ConstraintDescriptorFactory.keyForSchema((SchemaDescriptor)schema2).withName("c2").withId(43L).withOwnedIndexId(index2.getId());
        ImmutableIntSet[] expected = new ImmutableIntSet[]{IntSets.immutable.of(new int[]{4, 5}), IntSets.immutable.of(3)};
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.newSchemaCache(new SchemaRule[]{index1, c1, c2}).constraintsGetPropertyTokensForLogicalKey(2, EntityType.NODE)).as("should find the properties that makes up the logical keys for the node/label", new Object[0])).isEqualTo((Object)expected);
    }

    @Test
    void logicalKeyConstraintsForNodeKeyWithMultipleProperties() {
        String schemaName = "schema name";
        int labelId = 2;
        int propertyId1 = 3;
        int propertyId2 = 4;
        LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)2, (int[])new int[]{3, 4});
        IndexDescriptor index = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema).withName("schema name").materialise(1L);
        KeyConstraintDescriptor constraint = ConstraintDescriptorFactory.keyForSchema((SchemaDescriptor)schema).withId(42L).withOwnedIndexId(index.getId()).withName("schema name");
        SchemaCache cache = this.newSchemaCache(new SchemaRule[]{index, constraint});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])cache.constraintsGetPropertyTokensForLogicalKey(2, EntityType.NODE)).as("should find the properties that makes up the logical key for the node/label", new Object[0])).isEqualTo((Object)SchemaCacheTest.logicalKeys(3, 4));
    }

    @Test
    void logicalKeyConstraintsForRelationshipKey() {
        String schemaName = "schema name";
        int relType = 2;
        int propertyId = 3;
        RelationTypeSchemaDescriptor schema = SchemaDescriptors.forRelType((int)2, (int[])new int[]{3});
        IndexDescriptor index = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema).withName("schema name").materialise(1L);
        KeyConstraintDescriptor constraint = ConstraintDescriptorFactory.keyForSchema((SchemaDescriptor)schema).withId(42L).withOwnedIndexId(index.getId()).withName("schema name");
        SchemaCache cache = this.newSchemaCache(new SchemaRule[]{index, constraint});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])cache.constraintsGetPropertyTokensForLogicalKey(2, EntityType.RELATIONSHIP)).as("should find the property that makes up the logical key for the relationship", new Object[0])).isEqualTo((Object)SchemaCacheTest.logicalKeys(3));
        ((ObjectArrayAssert)Assertions.assertThat((Object[])cache.constraintsGetPropertyTokensForLogicalKey(3, EntityType.RELATIONSHIP)).as("should NOT find any logical key for the relationship", new Object[0])).isEqualTo((Object)SchemaCache.NO_LOGICAL_KEYS);
    }

    @Test
    void logicalKeysWithMultipleConstraintsForRelationshipKey() {
        int relType = 2;
        int propertyId1 = 3;
        int propertyId2 = 4;
        int propertyId3 = 5;
        RelationTypeSchemaDescriptor schema1 = SchemaDescriptors.forRelType((int)2, (int[])new int[]{3});
        RelationTypeSchemaDescriptor schema2 = SchemaDescriptors.forRelType((int)2, (int[])new int[]{4, 5});
        IndexDescriptor index1 = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema1).withName("i1").materialise(1L);
        IndexDescriptor index2 = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema2).withName("i2").materialise(2L);
        KeyConstraintDescriptor c1 = ConstraintDescriptorFactory.keyForSchema((SchemaDescriptor)schema1).withName("c1").withId(42L).withOwnedIndexId(index1.getId());
        KeyConstraintDescriptor c2 = ConstraintDescriptorFactory.keyForSchema((SchemaDescriptor)schema2).withName("c2").withId(43L).withOwnedIndexId(index2.getId());
        ImmutableIntSet[] expected = new ImmutableIntSet[]{IntSets.immutable.of(new int[]{4, 5}), IntSets.immutable.of(3)};
        ((ObjectArrayAssert)Assertions.assertThat((Object[])this.newSchemaCache(new SchemaRule[]{index1, c1, c2}).constraintsGetPropertyTokensForLogicalKey(2, EntityType.RELATIONSHIP)).as("should find the properties that makes up the logical keys for the relationship", new Object[0])).isEqualTo((Object)expected);
    }

    @Test
    void logicalKeyConstraintsForRelationshipKeyWithMultipleProperties() {
        String schemaName = "schema name";
        int relType = 2;
        int propertyId1 = 3;
        int propertyId2 = 4;
        RelationTypeSchemaDescriptor schema = SchemaDescriptors.forRelType((int)2, (int[])new int[]{3, 4});
        IndexDescriptor index = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema).withName("schema name").materialise(1L);
        KeyConstraintDescriptor constraint = ConstraintDescriptorFactory.keyForSchema((SchemaDescriptor)schema).withId(42L).withOwnedIndexId(index.getId()).withName("schema name");
        SchemaCache cache = this.newSchemaCache(new SchemaRule[]{index, constraint});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])cache.constraintsGetPropertyTokensForLogicalKey(2, EntityType.RELATIONSHIP)).as("should find the property that makes up the logical key for the relationship", new Object[0])).isEqualTo((Object)SchemaCacheTest.logicalKeys(3, 4));
    }

    @Test
    void logicalKeyConstraintsForNodeInSeparateSchemaRules() {
        String schemaName = "schema name";
        int labelId = 2;
        int propertyId1 = 3;
        int propertyId2 = 4;
        LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)2, (int[])new int[]{3, 4});
        IndexDescriptor index = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema).withName("schema name").materialise(1L);
        UniquenessConstraintDescriptor uniquenessConstraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)schema).withId(42L).withOwnedIndexId(index.getId());
        SchemaCache cache = this.newSchemaCache(new SchemaRule[]{index, uniquenessConstraint});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])cache.constraintsGetPropertyTokensForLogicalKey(2, EntityType.NODE)).as("should not find the logical key for the node/label yet", new Object[0])).isEqualTo((Object)SchemaCache.NO_LOGICAL_KEYS);
        ConstraintDescriptor existenceConstraint = SchemaCacheTest.nodePropertyExistenceConstraint(43L, 2, 3);
        cache.addSchemaRule((SchemaRule)existenceConstraint);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])cache.constraintsGetPropertyTokensForLogicalKey(2, EntityType.NODE)).as("not all properties exist to make up the logical key for the node/label", new Object[0])).isEqualTo((Object)SchemaCache.NO_LOGICAL_KEYS);
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.nodePropertyExistenceConstraint(44L, 2, 4));
        ((ObjectArrayAssert)Assertions.assertThat((Object[])cache.constraintsGetPropertyTokensForLogicalKey(2, EntityType.NODE)).as("All properties exist that make up the logical key for the node/label", new Object[0])).isEqualTo((Object)SchemaCacheTest.logicalKeys(3, 4));
        cache.removeSchemaRule(existenceConstraint.getId());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])cache.constraintsGetPropertyTokensForLogicalKey(2, EntityType.NODE)).as("logical key requires both the uniqueness and existence constraints", new Object[0])).isEqualTo((Object)SchemaCache.NO_LOGICAL_KEYS);
    }

    @Test
    void logicalKeyConstraintsForRelationshipInSeparateSchemaRules() {
        String schemaName = "schema name";
        int relType = 2;
        int propertyId1 = 3;
        int propertyId2 = 4;
        IndexDescriptor index = IndexPrototype.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forRelType((int)2, (int[])new int[]{3, 4})).withName("schema name").materialise(1L);
        UniquenessConstraintDescriptor uniquenessConstraint = ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)SchemaDescriptors.forRelType((int)2, (int[])new int[]{3})).withId(42L).withOwnedIndexId(index.getId()).withName("schema name");
        SchemaCache cache = this.newSchemaCache(new SchemaRule[]{index, uniquenessConstraint});
        ((ObjectArrayAssert)Assertions.assertThat((Object[])cache.constraintsGetPropertyTokensForLogicalKey(2, EntityType.RELATIONSHIP)).as("should not find the logical key for the relationship yet", new Object[0])).isEqualTo((Object)SchemaCache.NO_LOGICAL_KEYS);
        ConstraintDescriptor existenceConstraint = SchemaCacheTest.relPropertyExistenceConstraint(43L, 2, 3);
        cache.addSchemaRule((SchemaRule)existenceConstraint);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])cache.constraintsGetPropertyTokensForLogicalKey(2, EntityType.RELATIONSHIP)).as("should now find the property that makes up the logical key for the relationship", new Object[0])).isEqualTo((Object)SchemaCacheTest.logicalKeys(3));
        cache.addSchemaRule((SchemaRule)SchemaCacheTest.uniquenessConstraint(44L, 2, 4, index.getId()));
        ((ObjectArrayAssert)Assertions.assertThat((Object[])cache.constraintsGetPropertyTokensForLogicalKey(2, EntityType.RELATIONSHIP)).as("should still be the one property that makes up the logical key for the relationship", new Object[0])).isEqualTo((Object)SchemaCacheTest.logicalKeys(3));
        cache.removeSchemaRule(existenceConstraint.getId());
        ((ObjectArrayAssert)Assertions.assertThat((Object[])cache.constraintsGetPropertyTokensForLogicalKey(2, EntityType.RELATIONSHIP)).as("logical key requires both the uniqueness and existence constraints", new Object[0])).isEqualTo((Object)SchemaCache.NO_LOGICAL_KEYS);
    }

    @ParameterizedTest
    @MethodSource(value={"descriptorPositions"})
    void logicalKeyConstraintsForNodeKeyAndExistenceInAnyOrderSchemaRules(int constraint1, int constraint2, int constraint3) {
        String schemaName = "schema name";
        int labelId = 2;
        int propertyId1 = 3;
        int propertyId2 = 4;
        LabelSchemaDescriptor schema = SchemaDescriptors.forLabel((int)2, (int[])new int[]{3, 4});
        IndexDescriptor index = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema).withName("schema name").materialise(1L);
        ImmutableList descriptors = Lists.immutable.of((Object)ConstraintDescriptorFactory.keyForSchema((SchemaDescriptor)schema).withId(42L).withOwnedIndexId(index.getId()).withName("schema name"), (Object)SchemaCacheTest.nodePropertyExistenceConstraint(43L, 2, 3), (Object)SchemaCacheTest.nodePropertyExistenceConstraint(44L, 2, 4));
        SchemaCache cache = this.newSchemaCache(new SchemaRule[]{index, (SchemaRule)descriptors.get(constraint1)});
        cache.addSchemaRule((SchemaRule)descriptors.get(constraint2));
        cache.addSchemaRule((SchemaRule)descriptors.get(constraint3));
        ((ObjectArrayAssert)Assertions.assertThat((Object[])cache.constraintsGetPropertyTokensForLogicalKey(2, EntityType.NODE)).as("should find the properties that makes up the logical key for the node/label", new Object[0])).isEqualTo((Object)SchemaCacheTest.logicalKeys(3, 4));
    }

    @ParameterizedTest
    @MethodSource(value={"descriptorPositions"})
    void logicalKeyConstraintsForRelationshipKeyAndExistenceInAnyOrderSchemaRules(int constraint1, int constraint2, int constraint3) {
        String schemaName = "schema name";
        int relType = 2;
        int propertyId1 = 3;
        int propertyId2 = 4;
        RelationTypeSchemaDescriptor schema = SchemaDescriptors.forRelType((int)2, (int[])new int[]{3, 4});
        IndexDescriptor index = IndexPrototype.uniqueForSchema((SchemaDescriptor)schema).withName("schema name").materialise(1L);
        ImmutableList descriptors = Lists.immutable.of((Object)ConstraintDescriptorFactory.keyForSchema((SchemaDescriptor)schema).withId(42L).withOwnedIndexId(index.getId()).withName("schema name"), (Object)SchemaCacheTest.relPropertyExistenceConstraint(43L, 2, 3), (Object)SchemaCacheTest.relPropertyExistenceConstraint(44L, 2, 4));
        SchemaCache cache = this.newSchemaCache(new SchemaRule[]{index, (SchemaRule)descriptors.get(constraint1)});
        cache.addSchemaRule((SchemaRule)descriptors.get(constraint2));
        cache.addSchemaRule((SchemaRule)descriptors.get(constraint3));
        ((ObjectArrayAssert)Assertions.assertThat((Object[])cache.constraintsGetPropertyTokensForLogicalKey(2, EntityType.RELATIONSHIP)).as("should find the properties that makes up the logical key for the rel/type", new Object[0])).isEqualTo((Object)SchemaCacheTest.logicalKeys(3, 4));
    }

    private static Stream<Arguments> descriptorPositions() {
        return Stream.of(Arguments.of((Object[])new Object[]{0, 1, 2}), Arguments.of((Object[])new Object[]{0, 2, 1}), Arguments.of((Object[])new Object[]{1, 0, 2}), Arguments.of((Object[])new Object[]{1, 2, 0}), Arguments.of((Object[])new Object[]{2, 1, 0}), Arguments.of((Object[])new Object[]{2, 0, 1}));
    }

    private static int[] entityTokens(int ... entityTokenIds) {
        return entityTokenIds;
    }

    private static int[] properties(int ... propertyIds) {
        return propertyIds;
    }

    private static IndexDescriptor newIndexRule(long id, IndexType type, int label, int ... propertyKeys) {
        return IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)label, (int[])propertyKeys)).withName("index_id").withIndexType(type).materialise(id);
    }

    private static IndexDescriptor newIndexRule(long id, int label, int ... propertyKeys) {
        return SchemaCacheTest.newIndexRule((SchemaDescriptor)SchemaDescriptors.forLabel((int)label, (int[])propertyKeys), id);
    }

    private static IndexDescriptor newIndexRule(SchemaDescriptor schema, long id) {
        return IndexPrototype.forSchema((SchemaDescriptor)schema).withName("index_id").materialise(id);
    }

    private static ConstraintDescriptor nodePropertyExistenceConstraint(long ruleId, int labelId, int propertyId) {
        return ConstraintDescriptorFactory.existsForLabel((int)labelId, (int[])new int[]{propertyId}).withId(ruleId);
    }

    private static ConstraintDescriptor relPropertyExistenceConstraint(long ruleId, int relTypeId, int propertyId) {
        return ConstraintDescriptorFactory.existsForRelType((int)relTypeId, (int[])new int[]{propertyId}).withId(ruleId);
    }

    private static ConstraintDescriptor uniquenessConstraint(long ruleId, int labelId, int propertyId, long indexId) {
        return ConstraintDescriptorFactory.uniqueForLabel((int)labelId, (int[])new int[]{propertyId}).withId(ruleId).withOwnedIndexId(indexId);
    }

    private static ConstraintDescriptor uniquenessConstraint(long ruleId, int labelId, int propertyId, long indexId, IndexType type) {
        return ConstraintDescriptorFactory.uniqueForLabel((IndexType)type, (int)labelId, (int[])new int[]{propertyId}).withId(ruleId).withOwnedIndexId(indexId);
    }

    private SchemaCache newSchemaCache(SchemaRule ... rules) {
        SchemaCache cache = new SchemaCache((ConstraintRuleAccessor)new ConstraintSemantics(), this.indexConfigCompleter, StorageEngineIndexingBehaviour.EMPTY);
        cache.load(rules == null || rules.length == 0 ? Collections.emptyList() : Arrays.asList(rules));
        return cache;
    }

    private SchemaCache newSchemaCacheWithRulesForRelatedToCalls() {
        return this.newSchemaCache(new SchemaRule[]{this.schema3_4, this.schema5_6_7, this.schema5_8, this.node35_8, this.rel35_8});
    }

    private static IntSet[] logicalKeys(int ... props) {
        return new IntSet[]{IntSets.immutable.of(props)};
    }

    private static class ConstraintSemantics
    extends StandardConstraintRuleAccessor {
        private ConstraintSemantics() {
        }

        public ConstraintDescriptor readConstraint(ConstraintDescriptor constraint) {
            if (!(constraint.type() != ConstraintType.EXISTS && constraint.type() != ConstraintType.UNIQUE_EXISTS || constraint.enforcesPropertyExistence())) {
                throw new IllegalStateException("Unsupported constraint type: " + constraint);
            }
            return super.readConstraint(constraint);
        }
    }
}

