/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.util;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.Direction;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.util.EagerDegrees;
import org.neo4j.test.RandomSupport;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.RandomExtension;

@ExtendWith(value={RandomExtension.class})
class EagerDegreesTest {
    @Inject
    private RandomSupport random;

    EagerDegreesTest() {
    }

    @Test
    void shouldReplyZeroOnEmptyDegrees() {
        EagerDegrees degrees = new EagerDegrees();
        Assertions.assertThat((int)degrees.degree(0, Direction.OUTGOING)).isZero();
        Assertions.assertThat((int)degrees.degree(Direction.OUTGOING)).isZero();
        Assertions.assertThat((int)degrees.totalDegree()).isZero();
    }

    @Test
    void shouldReplyZeroForUnknownTypeOrDirection() {
        int type = 10;
        EagerDegrees degrees = new EagerDegrees();
        degrees.add(type, 20, 21, 22);
        Assertions.assertThat((int)degrees.degree(5, Direction.OUTGOING)).isZero();
        Assertions.assertThat((int)degrees.degree(3, Direction.INCOMING)).isZero();
        Assertions.assertThat((int)degrees.degree(2, Direction.BOTH)).isZero();
        Assertions.assertThat((int)degrees.outgoingDegree(2)).isZero();
        Assertions.assertThat((int)degrees.incomingDegree(1)).isZero();
        Assertions.assertThat((int)degrees.totalDegree(0)).isZero();
        Assertions.assertThat((boolean)degrees.hasType(type)).isTrue();
        Assertions.assertThat((boolean)degrees.hasType(type + 1)).isFalse();
    }

    @Test
    void shouldGetDegreeForSingleType() {
        int type = 10;
        EagerDegrees degrees = new EagerDegrees();
        degrees.add(type, 20, 21, 22);
        Assertions.assertThat((int)degrees.outgoingDegree(type)).isEqualTo(42);
        Assertions.assertThat((int)degrees.incomingDegree(type)).isEqualTo(43);
        Assertions.assertThat((int)degrees.totalDegree(type)).isEqualTo(63);
        Assertions.assertThat((int)degrees.totalDegree()).isEqualTo(63);
    }

    @Test
    void shouldAddWithDirectionMethod() {
        int type = 99;
        int outgoing = 5;
        int incoming = 6;
        int loop = 7;
        EagerDegrees degrees = new EagerDegrees();
        degrees.add(type, RelationshipDirection.OUTGOING, outgoing);
        degrees.add(type, RelationshipDirection.INCOMING, incoming);
        degrees.add(type, RelationshipDirection.LOOP, loop);
        Assertions.assertThat((int)degrees.rawOutgoingDegree(type)).isEqualTo(outgoing);
        Assertions.assertThat((int)degrees.rawIncomingDegree(type)).isEqualTo(incoming);
        Assertions.assertThat((int)degrees.rawLoopDegree(type)).isEqualTo(loop);
        Assertions.assertThat((int)degrees.outgoingDegree()).isEqualTo(outgoing + loop);
        Assertions.assertThat((int)degrees.incomingDegree()).isEqualTo(incoming + loop);
    }

    @Test
    void shouldGetDegreeForMultipleType() {
        int i;
        int numberOfTypes = this.random.nextInt(3, 10);
        int[][] expectedDegrees = new int[numberOfTypes][];
        int[] types = new int[numberOfTypes];
        int prevType = 0;
        for (int i2 = 0; i2 < expectedDegrees.length; ++i2) {
            expectedDegrees[i2] = new int[3];
            types[i2] = prevType + this.random.nextInt(1, 100);
            prevType = types[i2];
        }
        EagerDegrees degrees = new EagerDegrees();
        block6: for (i = 0; i < 100; ++i) {
            int typeIndex = this.random.nextInt(numberOfTypes);
            int type = types[typeIndex];
            int outgoing = this.random.nextInt(1, 10);
            int incoming = this.random.nextInt(1, 10);
            int loop = this.random.nextInt(1, 10);
            switch (this.random.nextInt(4)) {
                case 0: {
                    degrees.add(type, outgoing, incoming, loop);
                    int[] nArray = expectedDegrees[typeIndex];
                    nArray[0] = nArray[0] + outgoing;
                    int[] nArray2 = expectedDegrees[typeIndex];
                    nArray2[1] = nArray2[1] + incoming;
                    int[] nArray3 = expectedDegrees[typeIndex];
                    nArray3[2] = nArray3[2] + loop;
                    continue block6;
                }
                case 1: {
                    degrees.addOutgoing(type, outgoing);
                    int[] nArray = expectedDegrees[typeIndex];
                    nArray[0] = nArray[0] + outgoing;
                    continue block6;
                }
                case 2: {
                    degrees.addIncoming(type, incoming);
                    int[] nArray = expectedDegrees[typeIndex];
                    nArray[1] = nArray[1] + incoming;
                    continue block6;
                }
                default: {
                    degrees.addLoop(type, loop);
                    int[] nArray = expectedDegrees[typeIndex];
                    nArray[2] = nArray[2] + loop;
                }
            }
        }
        for (i = 0; i < numberOfTypes; ++i) {
            int type = types[i];
            Assertions.assertThat((int)degrees.outgoingDegree(type)).isEqualTo(expectedDegrees[i][0] + expectedDegrees[i][2]);
            Assertions.assertThat((int)degrees.incomingDegree(type)).isEqualTo(expectedDegrees[i][1] + expectedDegrees[i][2]);
            Assertions.assertThat((int)degrees.totalDegree(type)).isEqualTo(expectedDegrees[i][0] + expectedDegrees[i][1] + expectedDegrees[i][2]);
        }
    }
}

