/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.util.HighestTransactionId;
import org.neo4j.test.Race;

class HighestTransactionIdTest {
    HighestTransactionIdTest() {
    }

    @Test
    void shouldHardSetHighest() {
        HighestTransactionId highest = new HighestTransactionId(new TransactionId(10L, 12L, KernelVersion.DEFAULT_BOOTSTRAP_VERSION, 10, 10L, 11L));
        highest.set(8L, 9L, KernelVersion.DEFAULT_BOOTSTRAP_VERSION, 1299128, 42L, 43L);
        Assertions.assertEquals((Object)new TransactionId(8L, 9L, KernelVersion.DEFAULT_BOOTSTRAP_VERSION, 1299128, 42L, 43L), (Object)highest.get());
    }

    @Test
    void shouldOnlyKeepTheHighestOffered() {
        HighestTransactionId highest = new HighestTransactionId(new TransactionId(-1L, 2L, KernelVersion.DEFAULT_BOOTSTRAP_VERSION, -1, -1L, -1L));
        HighestTransactionIdTest.assertAccepted(highest, 2L);
        HighestTransactionIdTest.assertAccepted(highest, 5L);
        HighestTransactionIdTest.assertRejected(highest, 3L);
        HighestTransactionIdTest.assertRejected(highest, 4L);
        HighestTransactionIdTest.assertAccepted(highest, 10L);
    }

    @Test
    void shouldKeepHighestDuringConcurrentOfferings() throws Throwable {
        HighestTransactionId highest = new HighestTransactionId(new TransactionId(-1L, 3L, KernelVersion.DEFAULT_BOOTSTRAP_VERSION, -1, -1L, -1L));
        Race race = new Race();
        int updaters = Math.max(2, Runtime.getRuntime().availableProcessors());
        AtomicInteger accepted = new AtomicInteger();
        for (int i = 0; i < updaters; ++i) {
            long id = i + 1;
            race.addContestant(() -> {
                if (highest.offer(id, id + 2L, KernelVersion.DEFAULT_BOOTSTRAP_VERSION, (int)id, id, id)) {
                    accepted.incrementAndGet();
                }
            });
        }
        race.go();
        Assertions.assertTrue((accepted.get() > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((long)updaters, (long)highest.get().id());
    }

    private static void assertAccepted(HighestTransactionId highest, long txId) {
        TransactionId current = highest.get();
        Assertions.assertTrue((boolean)highest.offer(txId, txId + 7L, KernelVersion.DEFAULT_BOOTSTRAP_VERSION, -1, -1L, -1L));
        Assertions.assertTrue((txId > current.id() ? 1 : 0) != 0);
    }

    private static void assertRejected(HighestTransactionId highest, long txId) {
        TransactionId current = highest.get();
        Assertions.assertFalse((boolean)highest.offer(txId, txId + 5L, KernelVersion.DEFAULT_BOOTSTRAP_VERSION, -1, -1L, -1L));
        Assertions.assertEquals((Object)current, (Object)highest.get());
    }
}

