/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.util;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.tuple.Pair;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.storageengine.util.IdGeneratorUpdatesWorkSync;

class IdGeneratorUpdatesWorkSyncTest {
    IdGeneratorUpdatesWorkSyncTest() {
    }

    @Test
    void shouldGatherChangedIds() throws ExecutionException {
        IdGeneratorUpdatesWorkSync workSync = new IdGeneratorUpdatesWorkSync();
        IdGenerator idGenerator = (IdGenerator)Mockito.mock(IdGenerator.class);
        RecordingMarker marker = new RecordingMarker();
        Mockito.when((Object)idGenerator.transactionalMarker((CursorContext)ArgumentMatchers.any())).thenReturn((Object)marker);
        workSync.add(idGenerator);
        IdGeneratorUpdatesWorkSync.Batch batch = workSync.newBatch(CursorContext.NULL_CONTEXT);
        batch.markIdAsUsed(idGenerator, 10L, 1, CursorContext.NULL_CONTEXT);
        batch.markIdAsUnused(idGenerator, 11L, 1, CursorContext.NULL_CONTEXT);
        batch.markIdAsUsed(idGenerator, 270L, 4, CursorContext.NULL_CONTEXT);
        batch.markIdAsUnused(idGenerator, 513L, 7, CursorContext.NULL_CONTEXT);
        batch.apply();
        Assertions.assertThat((boolean)marker.used(10L, 1)).isTrue();
        Assertions.assertThat((boolean)marker.deleted(11L, 1)).isTrue();
        Assertions.assertThat((boolean)marker.used(270L, 4)).isTrue();
        Assertions.assertThat((boolean)marker.deleted(513L, 7)).isTrue();
    }

    private static class RecordingMarker
    implements IdGenerator.TransactionalMarker {
        private final Set<Pair<Long, Integer>> used = new HashSet<Pair<Long, Integer>>();
        private final Set<Pair<Long, Integer>> deleted = new HashSet<Pair<Long, Integer>>();

        private RecordingMarker() {
        }

        public void markUsed(long id, int numberOfIds) {
            this.used.add((Pair<Long, Integer>)Pair.of((Object)id, (Object)numberOfIds));
        }

        public void markDeleted(long id, int numberOfIds) {
            this.deleted.add((Pair<Long, Integer>)Pair.of((Object)id, (Object)numberOfIds));
        }

        public void markDeletedAndFree(long id, int numberOfIds) {
        }

        public void markUnallocated(long id, int numberOfIds) {
        }

        public void close() {
        }

        boolean used(long id, int numberOfIds) {
            return this.used.contains(Pair.of((Object)id, (Object)numberOfIds));
        }

        boolean deleted(long id, int numberOfIds) {
            return this.deleted.contains(Pair.of((Object)id, (Object)numberOfIds));
        }
    }
}

