/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.util;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.storageengine.util.IndexUpdatesWorkSync;
import org.neo4j.test.Race;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class IndexUpdatesWorkSyncTest {
    private final CursorContextFactory contextFactory = CursorContextFactory.NULL_CONTEXT_FACTORY;

    IndexUpdatesWorkSyncTest() {
    }

    @RepeatedTest(value=10)
    void shouldApplyIndexUpdatesSingleThreadedIfToldTo() {
        Assertions.assertThat((Object)CursorContextFactory.NULL_CONTEXT_FACTORY.create("0")).isNotEqualTo((Object)this.contextFactory.create("1"));
        IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{2})).withName("index").materialise(1L);
        int threads = 10;
        final Set appliedUpdates = Collections.newSetFromMap(new ConcurrentHashMap());
        final AtomicInteger concurrentlyApplyingThreads = new AtomicInteger();
        IndexUpdateListener.Adapter updateListener = new IndexUpdateListener.Adapter(){

            public void applyUpdates(Iterable<IndexEntryUpdate<IndexDescriptor>> updates, CursorContext cursorContext, boolean parallel) {
                Assertions.assertThat((int)concurrentlyApplyingThreads.incrementAndGet()).isOne();
                Assertions.assertThat((boolean)parallel).isFalse();
                updates.forEach(u -> appliedUpdates.add(new UpdateAndContext((IndexEntryUpdate<IndexDescriptor>)u, cursorContext)));
                concurrentlyApplyingThreads.decrementAndGet();
            }
        };
        IndexUpdatesWorkSync workSync = new IndexUpdatesWorkSync((IndexUpdateListener)updateListener, false);
        Set<UpdateAndContext> sentUpdates = this.queueUpdatesInParallel(index, threads, workSync, this.contextFactory);
        Assertions.assertThat(appliedUpdates).isEqualTo(sentUpdates);
        Assertions.assertThat((int)concurrentlyApplyingThreads.get()).isZero();
    }

    @Test
    void shouldApplyIndexUpdatesInParallelIfToldTo() {
        IndexDescriptor index = IndexPrototype.forSchema((SchemaDescriptor)SchemaDescriptors.forLabel((int)1, (int[])new int[]{2})).withName("index").materialise(1L);
        int threads = 4;
        final CountDownLatch latch = new CountDownLatch(threads);
        final Set appliedUpdates = Collections.newSetFromMap(new ConcurrentHashMap());
        final Set applyingThreads = Collections.newSetFromMap(new ConcurrentHashMap());
        IndexUpdateListener.Adapter updateListener = new IndexUpdateListener.Adapter(){

            public void applyUpdates(Iterable<IndexEntryUpdate<IndexDescriptor>> updates, CursorContext cursorContext, boolean parallel) {
                Assertions.assertThat((boolean)parallel).isTrue();
                applyingThreads.add(Thread.currentThread());
                updates.forEach(u -> appliedUpdates.add(new UpdateAndContext((IndexEntryUpdate<IndexDescriptor>)u, cursorContext)));
                latch.countDown();
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        };
        IndexUpdatesWorkSync workSync = new IndexUpdatesWorkSync((IndexUpdateListener)updateListener, true);
        Set<UpdateAndContext> sentUpdates = this.queueUpdatesInParallel(index, threads, workSync, this.contextFactory);
        Assertions.assertThat(appliedUpdates).isEqualTo(sentUpdates);
        Assertions.assertThat((int)applyingThreads.size()).isEqualTo(threads);
    }

    private Set<UpdateAndContext> queueUpdatesInParallel(IndexDescriptor index, int threads, IndexUpdatesWorkSync workSync, CursorContextFactory contextFactory) {
        Set<UpdateAndContext> sentUpdates = Collections.newSetFromMap(new ConcurrentHashMap());
        Race race = new Race();
        race.addContestants(threads, i -> Race.throwing(() -> {
            IndexUpdatesWorkSync.Batch batch = workSync.newBatch();
            ValueIndexEntryUpdate update = IndexEntryUpdate.add((long)i, (SchemaDescriptorSupplier)index, (Value[])new Value[]{Values.intValue((int)(10 + i))});
            CursorContext cursorContext = contextFactory.create(Integer.toString(i));
            sentUpdates.add(new UpdateAndContext((IndexEntryUpdate<IndexDescriptor>)update, cursorContext));
            batch.add((IndexEntryUpdate)update);
            batch.apply(cursorContext);
        }), 1);
        race.goUnchecked();
        return sentUpdates;
    }

    record UpdateAndContext(IndexEntryUpdate<IndexDescriptor> update, CursorContext context) {
    }
}

