/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.function.Predicate;
import org.neo4j.backup.BackupResult;
import org.neo4j.backup.impl.BackupClient;
import org.neo4j.backup.impl.BackupOutcome;
import org.neo4j.backup.impl.BackupProtocolService;
import org.neo4j.backup.impl.ConsistencyCheck;
import org.neo4j.function.Predicates;
import org.neo4j.helper.IsChannelClosedException;
import org.neo4j.helper.IsConnectionException;
import org.neo4j.helper.IsConnectionResetByPeer;
import org.neo4j.helper.IsStoreClosed;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.configuration.Config;

public class BackupHelper {
    private static final Predicate<Throwable> isTransientError = Predicates.any((Predicate[])new Predicate[]{new IsConnectionException(), new IsConnectionResetByPeer(), new IsChannelClosedException(), new IsStoreClosed()});

    private BackupHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BackupResult backup(String host, int port, Path targetDirectory) {
        boolean transientFailure;
        boolean consistent;
        ByteArrayOutputStream outputStream;
        block6: {
            outputStream = new ByteArrayOutputStream();
            consistent = true;
            transientFailure = false;
            boolean failure = false;
            try {
                BackupProtocolService backupProtocolService = new BackupProtocolService((OutputStream)outputStream);
                BackupOutcome backupOutcome = backupProtocolService.doIncrementalBackupOrFallbackToFull(host, port, targetDirectory, ConsistencyCheck.FULL, Config.defaults(), BackupClient.BIG_READ_TIMEOUT, false);
                consistent = backupOutcome.isConsistent();
                if (consistent && !failure) break block6;
            }
            catch (Throwable t) {
                block7: {
                    try {
                        if (!isTransientError.test(t)) {
                            failure = true;
                            throw t;
                        }
                        transientFailure = true;
                        if (consistent && !failure) break block7;
                    }
                    catch (Throwable throwable) {
                        if (!consistent || failure) {
                            BackupHelper.flushToStandardOutput(outputStream);
                        }
                        IOUtils.closeAllSilently((AutoCloseable[])new ByteArrayOutputStream[]{outputStream});
                        throw throwable;
                    }
                    BackupHelper.flushToStandardOutput(outputStream);
                }
                IOUtils.closeAllSilently((AutoCloseable[])new ByteArrayOutputStream[]{outputStream});
            }
            BackupHelper.flushToStandardOutput(outputStream);
        }
        IOUtils.closeAllSilently((AutoCloseable[])new ByteArrayOutputStream[]{outputStream});
        return new BackupResult(consistent, transientFailure);
    }

    private static void flushToStandardOutput(ByteArrayOutputStream outputStream) {
        try {
            outputStream.writeTo(System.out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

