/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.stresstests;

import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.neo4j.backup.BackupHelper;
import org.neo4j.backup.BackupResult;
import org.neo4j.causalclustering.stresstests.Control;
import org.neo4j.helper.Workload;

class BackupLoad
extends Workload {
    private final String backupHostname;
    private final int backupPort;
    private final Path backupDir;

    BackupLoad(Control control, String backupHostname, int backupPort, Path backupDir) {
        super(control);
        this.backupHostname = backupHostname;
        this.backupPort = backupPort;
        this.backupDir = backupDir;
    }

    @Override
    protected void doWork() {
        BackupResult backupResult = BackupHelper.backup(this.backupHostname, this.backupPort, this.backupDir);
        if (!backupResult.isConsistent()) {
            throw new RuntimeException("Inconsistent backup");
        }
        if (backupResult.isTransientErrorOnBackup()) {
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
        }
    }
}

