/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.stresstests;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.backup.stresstests.BackupLoad;
import org.neo4j.backup.stresstests.StartStop;
import org.neo4j.backup.stresstests.TransactionalWorkload;
import org.neo4j.causalclustering.stresstests.Config;
import org.neo4j.causalclustering.stresstests.Control;
import org.neo4j.concurrent.Futures;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.helper.DatabaseConfiguration;
import org.neo4j.helper.StressTestingHelper;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.test.ThreadTestUtils;

public class BackupServiceStressTesting {
    private static final String DEFAULT_DURATION_IN_MINUTES = "30";
    private static final String DEFAULT_WORKING_DIR = new File(System.getProperty("java.io.tmpdir")).getPath();
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final String DEFAULT_PORT = "8200";
    private static final String DEFAULT_ENABLE_INDEXES = "false";
    private static final String DEFAULT_TX_PRUNE = "50 files";

    @Test
    public void shouldBehaveCorrectlyUnderStress() throws Exception {
        long durationInMinutes = Long.parseLong(StressTestingHelper.fromEnv("BACKUP_SERVICE_STRESS_DURATION", DEFAULT_DURATION_IN_MINUTES));
        String directory = StressTestingHelper.fromEnv("BACKUP_SERVICE_STRESS_WORKING_DIRECTORY", DEFAULT_WORKING_DIR);
        String backupHostname = StressTestingHelper.fromEnv("BACKUP_SERVICE_STRESS_BACKUP_HOSTNAME", DEFAULT_HOSTNAME);
        int backupPort = Integer.parseInt(StressTestingHelper.fromEnv("BACKUP_SERVICE_STRESS_BACKUP_PORT", DEFAULT_PORT));
        String txPrune = StressTestingHelper.fromEnv("BACKUP_SERVICE_STRESS_TX_PRUNE", DEFAULT_TX_PRUNE);
        boolean enableIndexes = Boolean.parseBoolean(StressTestingHelper.fromEnv("BACKUP_SERVICE_STRESS_ENABLE_INDEXES", DEFAULT_ENABLE_INDEXES));
        File store = new File(directory, "store");
        File work = new File(directory, "work");
        FileUtils.deleteRecursively((File)store);
        FileUtils.deleteRecursively((File)work);
        File storeDirectory = StressTestingHelper.ensureExistsAndEmpty(store);
        Path workDirectory = StressTestingHelper.ensureExistsAndEmpty(work).toPath();
        Map<String, String> config = DatabaseConfiguration.configureBackup(DatabaseConfiguration.configureTxLogRotationAndPruning(new HashMap<String, String>(), txPrune), backupHostname, backupPort);
        GraphDatabaseBuilder graphDatabaseBuilder = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDirectory.getAbsoluteFile()).setConfig(config);
        Control control = new Control(new Config());
        AtomicReference<GraphDatabaseService> dbRef = new AtomicReference<GraphDatabaseService>();
        ExecutorService service = Executors.newFixedThreadPool(3);
        try {
            dbRef.set(graphDatabaseBuilder.newGraphDatabase());
            if (enableIndexes) {
                TransactionalWorkload.setupIndexes((GraphDatabaseService)dbRef.get());
            }
            Future<?> workload = service.submit(new TransactionalWorkload(control, dbRef::get));
            Future<?> backupWorker = service.submit(new BackupLoad(control, backupHostname, backupPort, workDirectory));
            Future<?> startStopWorker = service.submit(new StartStop(control, (Factory<GraphDatabaseService>)((Factory)() -> ((GraphDatabaseBuilder)graphDatabaseBuilder).newGraphDatabase()), dbRef));
            Futures.combine((Future[])new Future[]{workload, backupWorker, startStopWorker}).get(durationInMinutes + 5L, TimeUnit.MINUTES);
            service.shutdown();
            if (!service.awaitTermination(30L, TimeUnit.SECONDS)) {
                ThreadTestUtils.dumpAllStackTraces();
                Assert.fail((String)"Didn't manage to shut down the workers correctly, dumped threads for forensic purposes");
            }
        }
        catch (TimeoutException t) {
            try {
                System.err.println(String.format("Timeout waiting task completion. Dumping all threads.", new Object[0]));
                ThreadTestUtils.dumpAllStackTraces();
                throw t;
            }
            catch (Throwable throwable) {
                ((GraphDatabaseService)dbRef.get()).shutdown();
                service.shutdown();
                throw throwable;
            }
        }
        dbRef.get().shutdown();
        service.shutdown();
        FileUtils.deleteRecursively((File)storeDirectory);
        FileUtils.deletePathRecursively((Path)workDirectory);
    }
}

