/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.stresstests;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.junit.Assert;
import org.neo4j.causalclustering.stresstests.Control;
import org.neo4j.function.Factory;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helper.Workload;

class StartStop
extends Workload {
    private final AtomicReference<GraphDatabaseService> dbRef;
    private final Factory<GraphDatabaseService> factory;

    StartStop(Control control, Factory<GraphDatabaseService> factory, AtomicReference<GraphDatabaseService> dbRef) {
        super(control);
        this.factory = factory;
        this.dbRef = dbRef;
    }

    @Override
    protected void doWork() {
        GraphDatabaseService db = this.dbRef.get();
        db.shutdown();
        LockSupport.parkNanos(TimeUnit.SECONDS.toNanos(5L));
        boolean replaced = this.dbRef.compareAndSet(db, (GraphDatabaseService)this.factory.newInstance());
        Assert.assertTrue((boolean)replaced);
    }
}

