/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.backup.stresstests;

import java.util.function.Supplier;
import org.neo4j.causalclustering.stresstests.Control;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.TransientFailureException;
import org.neo4j.helper.Workload;

class TransactionalWorkload
extends Workload {
    private static final Label label = Label.label((String)"Label");
    private final Supplier<GraphDatabaseService> dbRef;

    TransactionalWorkload(Control control, Supplier<GraphDatabaseService> dbRef) {
        super(control);
        this.dbRef = dbRef;
    }

    @Override
    protected void doWork() {
        GraphDatabaseService db = this.dbRef.get();
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode(new Label[]{label});
            for (int i = 1; i <= 8; ++i) {
                node.setProperty(TransactionalWorkload.prop(i), (Object)"let's add some data here so the transaction logs rotate more often...");
            }
            tx.success();
        }
        catch (DatabaseShutdownException | TransactionFailureException | TransientFailureException throwable) {
            // empty catch block
        }
    }

    static void setupIndexes(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            for (int i = 1; i <= 8; ++i) {
                db.schema().indexFor(label).on(TransactionalWorkload.prop(i)).create();
            }
            tx.success();
        }
    }

    private static String prop(int i) {
        return "prop" + i;
    }
}

