/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.stresstests;

import java.io.File;
import org.neo4j.backup.impl.OnlineBackupCommandBuilder;
import org.neo4j.backup.impl.SelectedBackupProtocol;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.ClusterMember;
import org.neo4j.causalclustering.stresstests.Control;
import org.neo4j.causalclustering.stresstests.RepeatOnRandomMember;
import org.neo4j.causalclustering.stresstests.Resources;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.io.NullOutputStream;
import org.neo4j.logging.Log;

class BackupRandomMember
extends RepeatOnRandomMember {
    private final File baseBackupDir;
    private final Log log;
    private long backupNumber;
    private long successfulBackups;

    BackupRandomMember(Control control, Resources resources) {
        super(control, resources);
        this.baseBackupDir = resources.backupDir();
        this.log = resources.logProvider().getLog(this.getClass());
    }

    @Override
    protected void doWorkOnMember(ClusterMember member) throws IncorrectUsage {
        try {
            AdvertisedSocketAddress address = (AdvertisedSocketAddress)member.config().get(CausalClusteringSettings.transaction_advertised_address);
            String backupName = "backup-" + this.backupNumber++;
            new OnlineBackupCommandBuilder().withOutput(NullOutputStream.NULL_OUTPUT_STREAM).withSelectedBackupStrategy(SelectedBackupProtocol.CATCHUP).withConsistencyCheck(Boolean.valueOf(true)).withHost(address.getHostname()).withPort(Integer.valueOf(address.getPort())).backup(this.baseBackupDir, backupName);
            this.log.info(String.format("Created backup %s from %s", backupName, member));
            ++this.successfulBackups;
        }
        catch (CommandFailed e) {
            this.log.info("Backup command failed");
        }
    }

    @Override
    public void validate() {
        if (this.successfulBackups == 0L) {
            throw new IllegalStateException("Failed to perform any backups");
        }
        this.log.info(String.format("Performed %d/%d successful backups.", this.successfulBackups, this.backupNumber));
    }
}

