/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.stresstests;

import io.netty.channel.Channel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.neo4j.causalclustering.catchup.CatchUpClient;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.ClusterMember;
import org.neo4j.causalclustering.discovery.ReadReplica;
import org.neo4j.causalclustering.handlers.ExceptionMonitoringHandler;
import org.neo4j.causalclustering.stresstests.Control;
import org.neo4j.causalclustering.stresstests.Resources;
import org.neo4j.function.Predicates;
import org.neo4j.helper.IsConnectionResetByPeer;
import org.neo4j.helper.IsStoreClosed;
import org.neo4j.helper.Workload;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.monitoring.Monitors;

class CatchupNewReadReplica
extends Workload {
    private final Predicate<Throwable> isStoreClosed = new IsStoreClosed();
    private final FileSystemAbstraction fs;
    private Cluster cluster;
    private boolean deleteStore;

    CatchupNewReadReplica(Control control, Resources resources) {
        super(control);
        this.fs = resources.fileSystem();
        this.cluster = resources.cluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected void doWork() {
        Supplier<Throwable> monitoredException;
        Throwable ex;
        block15: {
            int newMemberId = this.cluster.readReplicas().size();
            ReadReplica readReplica = this.cluster.addReadReplicaWithId(newMemberId);
            ex = null;
            monitoredException = null;
            monitoredException = this.startAndRegisterExceptionMonitor(readReplica);
            Predicates.await(this::leaderTxId, leaderTxId -> leaderTxId < 1L || leaderTxId <= this.txId((ClusterMember)readReplica, true), (long)10L, (TimeUnit)TimeUnit.MINUTES);
            try {
                this.cluster.removeReadReplicaWithMemberId(newMemberId);
                if (ex == null && this.deleteStore) {
                    this.fs.deleteRecursively(readReplica.storeDir());
                }
                this.deleteStore = !this.deleteStore;
            }
            catch (Throwable e) {
                ex = this.exception(ex, e);
            }
            break block15;
            catch (Throwable e) {
                try {
                    ex = e;
                }
                catch (Throwable throwable) {
                    try {
                        this.cluster.removeReadReplicaWithMemberId(newMemberId);
                        if (ex == null && this.deleteStore) {
                            this.fs.deleteRecursively(readReplica.storeDir());
                        }
                        this.deleteStore = !this.deleteStore;
                    }
                    catch (Throwable e2) {
                        ex = this.exception(ex, e2);
                    }
                    throw throwable;
                }
                try {
                    this.cluster.removeReadReplicaWithMemberId(newMemberId);
                    if (ex == null && this.deleteStore) {
                        this.fs.deleteRecursively(readReplica.storeDir());
                    }
                    this.deleteStore = !this.deleteStore;
                }
                catch (Throwable e3) {
                    ex = this.exception(ex, e3);
                }
            }
        }
        if (monitoredException != null && monitoredException.get() != null) {
            throw new RuntimeException(this.exception(monitoredException.get(), ex));
        }
        if (ex != null) {
            throw new RuntimeException(ex);
        }
    }

    private Throwable exception(Throwable outer, Throwable inner) {
        if (outer == null) {
            assert (inner != null);
            return inner;
        }
        if (inner != null) {
            outer.addSuppressed(inner);
        }
        return outer;
    }

    private Supplier<Throwable> startAndRegisterExceptionMonitor(ReadReplica readReplica) {
        readReplica.start();
        Monitors monitors = (Monitors)readReplica.database().getDependencyResolver().resolveDependency(Monitors.class);
        ExceptionMonitor exceptionMonitor = new ExceptionMonitor(new IsConnectionResetByPeer());
        monitors.addMonitorListener((Object)exceptionMonitor, new String[]{CatchUpClient.class.getName()});
        return exceptionMonitor;
    }

    private long leaderTxId() {
        try {
            return this.txId((ClusterMember)this.cluster.awaitLeader(), false);
        }
        catch (TimeoutException e) {
            return -1L;
        }
    }

    private long txId(ClusterMember member, boolean fail) {
        GraphDatabaseAPI database = member.database();
        if (database == null) {
            return this.errorValueOrThrow(fail, new IllegalStateException("database is shutdown"));
        }
        try {
            return ((TransactionIdStore)database.getDependencyResolver().resolveDependency(TransactionIdStore.class)).getLastClosedTransactionId();
        }
        catch (Throwable ex) {
            return this.errorValueOrThrow(fail && !this.isStoreClosed.test(ex), ex);
        }
    }

    private long errorValueOrThrow(boolean fail, Throwable error) {
        if (fail) {
            throw new RuntimeException(error);
        }
        return -1L;
    }

    private static class ExceptionMonitor
    implements ExceptionMonitoringHandler.Monitor,
    Supplier<Throwable> {
        private final AtomicReference<Throwable> exception = new AtomicReference();
        private Predicate<Throwable> reject;

        ExceptionMonitor(Predicate<Throwable> reject) {
            this.reject = reject;
        }

        public void exceptionCaught(Channel channel, Throwable cause) {
            if (!this.reject.test(cause)) {
                this.exception.set(cause);
            }
        }

        @Override
        public Throwable get() {
            return this.exception.get();
        }
    }
}

