/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.stresstests;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.causalclustering.stresstests.ClusterStressTesting;
import org.neo4j.causalclustering.stresstests.Config;
import org.neo4j.causalclustering.stresstests.Preparations;
import org.neo4j.causalclustering.stresstests.Validations;
import org.neo4j.causalclustering.stresstests.Workloads;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class ClusterStressScenarioSmoke {
    private final DefaultFileSystemRule fileSystem = new DefaultFileSystemRule();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public RuleChain rules = RuleChain.outerRule((TestRule)this.fileSystem).around((TestRule)this.pageCacheRule);
    private Config config;
    private PageCache pageCache;

    @Before
    public void setup() {
        this.pageCache = this.pageCacheRule.getPageCache((FileSystemAbstraction)this.fileSystem);
        this.config = new Config();
        this.config.workDurationMinutes(1);
    }

    @Test
    public void stressBackupRandomMemberAndStartStop() throws Exception {
        this.config.workloads(Workloads.CreateNodesWithProperties, Workloads.BackupRandomMember, Workloads.StartStopRandomMember);
        ClusterStressTesting.stressTest(this.config, (FileSystemAbstraction)this.fileSystem, this.pageCache);
    }

    @Test
    public void stressCatchupNewReadReplica() throws Exception {
        this.config.workloads(Workloads.CreateNodesWithProperties, Workloads.CatchupNewReadReplica, Workloads.StartStopRandomCore);
        ClusterStressTesting.stressTest(this.config, (FileSystemAbstraction)this.fileSystem, this.pageCache);
    }

    @Test
    public void stressReplaceRandomMember() throws Exception {
        this.config.workloads(Workloads.CreateNodesWithProperties, Workloads.ReplaceRandomMember);
        ClusterStressTesting.stressTest(this.config, (FileSystemAbstraction)this.fileSystem, this.pageCache);
    }

    @Test
    public void stressIdReuse() throws Exception {
        this.config.numberOfEdges(0);
        this.config.reelectIntervalSeconds(20);
        this.config.preparations(Preparations.IdReuseSetup);
        this.config.workloads(Workloads.IdReuseInsertion, Workloads.IdReuseDeletion, Workloads.IdReuseDeletion, Workloads.IdReuseReelection);
        this.config.validations(Validations.ConsistencyCheck, Validations.IdReuseUniqueFreeIds);
        ClusterStressTesting.stressTest(this.config, (FileSystemAbstraction)this.fileSystem, this.pageCache);
    }
}

