/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.stresstests;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.neo4j.causalclustering.stresstests.Config;
import org.neo4j.causalclustering.stresstests.Control;
import org.neo4j.causalclustering.stresstests.Preparation;
import org.neo4j.causalclustering.stresstests.Resources;
import org.neo4j.causalclustering.stresstests.Validation;
import org.neo4j.helper.Workload;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.logging.Log;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class ClusterStressTesting {
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public RuleChain rules = RuleChain.outerRule((TestRule)this.fileSystemRule).around((TestRule)this.pageCacheRule);
    private FileSystemAbstraction fileSystem;
    private PageCache pageCache;

    @Before
    public void setup() {
        this.fileSystem = this.fileSystemRule.get();
        this.pageCache = this.pageCacheRule.getPageCache(this.fileSystem);
    }

    @Test
    public void shouldBehaveCorrectlyUnderStress() throws Exception {
        ClusterStressTesting.stressTest(new Config(), this.fileSystem, this.pageCache);
    }

    static void stressTest(Config config, FileSystemAbstraction fileSystem, PageCache pageCache) throws Exception {
        Resources resources = new Resources(fileSystem, pageCache, config);
        Control control = new Control(config);
        Log log = config.logProvider().getLog(ClusterStressTesting.class);
        log.info(config.toString());
        List preparations = config.preparations().stream().map(preparation -> preparation.create(resources)).collect(Collectors.toList());
        List workloads = config.workloads().stream().map(workload -> workload.create(control, resources, config)).collect(Collectors.toList());
        List validations = config.validations().stream().map(validator -> validator.create(resources)).collect(Collectors.toList());
        if (workloads.size() == 0) {
            throw new IllegalArgumentException("No workloads.");
        }
        ExecutorService executor = Executors.newCachedThreadPool();
        try {
            log.info("Starting resources");
            resources.start();
            log.info("Preparing scenario");
            for (Preparation preparation2 : preparations) {
                preparation2.prepare();
            }
            log.info("Preparing workloads");
            for (Iterator workload2 : workloads) {
                ((Workload)((Object)workload2)).prepare();
            }
            log.info("Starting workloads");
            ArrayList completions = new ArrayList();
            for (Workload workload3 : workloads) {
                completions.add(executor.submit(workload3));
            }
            control.awaitEnd(completions);
            for (Workload workload3 : workloads) {
                workload3.validate();
            }
        }
        catch (Throwable cause) {
            control.onFailure(cause);
        }
        log.info("Shutting down executor");
        executor.shutdownNow();
        executor.awaitTermination(5L, TimeUnit.MINUTES);
        log.info("Stopping resources");
        resources.stop();
        control.assertNoFailure();
        log.info("Validating results");
        for (Validation validation : validations) {
            validation.validate();
        }
        log.info("Cleaning up");
        resources.cleanup();
    }
}

