/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.stresstests;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.neo4j.causalclustering.stresstests.Preparations;
import org.neo4j.causalclustering.stresstests.Validations;
import org.neo4j.causalclustering.stresstests.Workloads;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;

public class Config {
    private static final String ENV_OVERRIDE_PREFIX = "STRESS_TESTING_";
    private LogProvider logProvider = FormattedLogProvider.toOutputStream((OutputStream)System.out);
    private String workingDir = Config.envOrDefault("WORKING_DIR", new File(System.getProperty("java.io.tmpdir")).getPath());
    private int numberOfCores = Config.envOrDefault("NUMBER_OF_CORES", 3);
    private int numberOfEdges = Config.envOrDefault("NUMBER_OF_EDGES", 1);
    private int workDurationMinutes = Config.envOrDefault("WORK_DURATION_MINUTES", 30);
    private int shutdownDurationMinutes = Config.envOrDefault("SHUTDOWN_DURATION_MINUTES", 5);
    private String txPrune = Config.envOrDefault("TX_PRUNE", "50 files");
    private Collection<Preparations> preparations = Config.envOrDefault(Preparations.class, (String)"PREPARATIONS", (Enum[])new Preparations[0]);
    private Collection<Workloads> workloads = Config.envOrDefault(Workloads.class, (String)"WORKLOADS", (Enum[])new Workloads[0]);
    private Collection<Validations> validations = Config.envOrDefault(Validations.class, (String)"VALIDATIONS", (Enum[])new Validations[]{Validations.ConsistencyCheck});
    private boolean enableIndexes = Config.envOrDefault("ENABLE_INDEXES", false);
    private long reelectIntervalSeconds = Config.envOrDefault("REELECT_INTERVAL_SECONDS", 60L);

    private static String envOrDefault(String name, String defaultValue) {
        String environmentVariableName = ENV_OVERRIDE_PREFIX + name;
        return Optional.ofNullable(System.getenv(environmentVariableName)).orElse(defaultValue);
    }

    private static int envOrDefault(String name, int defaultValue) {
        String environmentVariableName = ENV_OVERRIDE_PREFIX + name;
        return Optional.ofNullable(System.getenv(environmentVariableName)).map(Integer::parseInt).orElse(defaultValue);
    }

    private static long envOrDefault(String name, long defaultValue) {
        String environmentVariableName = ENV_OVERRIDE_PREFIX + name;
        return Optional.ofNullable(System.getenv(environmentVariableName)).map(Long::parseLong).orElse(defaultValue);
    }

    private static boolean envOrDefault(String name, boolean defaultValue) {
        String environmentVariableName = ENV_OVERRIDE_PREFIX + name;
        return Optional.ofNullable(System.getenv(environmentVariableName)).map(Boolean::parseBoolean).orElse(defaultValue);
    }

    @SafeVarargs
    private static <T extends Enum<T>> Collection<T> envOrDefault(Class<T> type, String name, T ... defaultValue) {
        String environmentVariableName = ENV_OVERRIDE_PREFIX + name;
        return Optional.ofNullable(System.getenv(environmentVariableName)).map(env -> Config.parseEnum(env, type)).orElse(Arrays.asList(defaultValue));
    }

    private static <T extends Enum<T>> Collection<T> parseEnum(String value, Class<T> type) {
        String[] split;
        if (value == null || value.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<T> workloads = new ArrayList<T>();
        for (String workloadString : split = value.split(",")) {
            workloads.add(Enum.valueOf(type, workloadString));
        }
        return workloads;
    }

    public LogProvider logProvider() {
        return this.logProvider;
    }

    public void logProvider(LogProvider logProvider) {
        this.logProvider = logProvider;
    }

    public String workingDir() {
        return this.workingDir;
    }

    public int numberOfCores() {
        return this.numberOfCores;
    }

    public int numberOfEdges() {
        return this.numberOfEdges;
    }

    public void numberOfEdges(int numberOfEdges) {
        this.numberOfEdges = numberOfEdges;
    }

    public void workDurationMinutes(int workDurationMinutes) {
        this.workDurationMinutes = workDurationMinutes;
    }

    public int workDurationMinutes() {
        return this.workDurationMinutes;
    }

    public int shutdownDurationMinutes() {
        return this.shutdownDurationMinutes;
    }

    public String txPrune() {
        return this.txPrune;
    }

    public void preparations(Preparations ... preparations) {
        this.preparations = Arrays.asList(preparations);
    }

    public Collection<Preparations> preparations() {
        return this.preparations;
    }

    public void workloads(Workloads ... workloads) {
        this.workloads = Arrays.asList(workloads);
    }

    public Collection<Workloads> workloads() {
        return this.workloads;
    }

    public void validations(Validations ... validations) {
        this.validations = Arrays.asList(validations);
    }

    public Collection<Validations> validations() {
        return this.validations;
    }

    public boolean enableIndexes() {
        return this.enableIndexes;
    }

    public long reelectIntervalSeconds() {
        return this.reelectIntervalSeconds;
    }

    public void reelectIntervalSeconds(int reelectIntervalSeconds) {
        this.reelectIntervalSeconds = reelectIntervalSeconds;
    }

    public String toString() {
        return "Config{numberOfCores=" + this.numberOfCores + ", numberOfEdges=" + this.numberOfEdges + ", workingDir='" + this.workingDir + '\'' + ", workDurationMinutes=" + this.workDurationMinutes + ", shutdownDurationMinutes=" + this.shutdownDurationMinutes + ", txPrune='" + this.txPrune + '\'' + ", preparations=" + this.preparations + ", workloads=" + this.workloads + ", validations=" + this.validations + ", enableIndexes=" + this.enableIndexes + ", reelectIntervalSeconds=" + this.reelectIntervalSeconds + '}';
    }
}

