/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.stresstests;

import java.io.PrintStream;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.ClusterMember;
import org.neo4j.causalclustering.stresstests.Resources;
import org.neo4j.causalclustering.stresstests.Validation;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.consistency.ConsistencyCheckTool;
import org.neo4j.helpers.collection.Iterables;

public class ConsistencyCheck
extends Validation {
    private final Cluster cluster;

    ConsistencyCheck(Resources resources) {
        this.cluster = resources.cluster();
    }

    @Override
    protected void validate() throws Exception {
        Iterable members = Iterables.concat((Iterable[])new Iterable[]{this.cluster.coreMembers(), this.cluster.readReplicas()});
        for (ClusterMember member : members) {
            String storeDir = member.storeDir().getAbsolutePath();
            ConsistencyCheckService.Result result = ConsistencyCheckTool.runConsistencyCheckTool((String[])new String[]{storeDir}, (PrintStream)System.out, (PrintStream)System.err);
            if (result.isSuccessful()) continue;
            throw new RuntimeException("Not consistent database in " + storeDir);
        }
    }
}

