/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.stresstests;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import org.neo4j.causalclustering.stresstests.Config;
import org.neo4j.concurrent.Futures;
import org.neo4j.function.Suppliers;
import org.neo4j.logging.Log;

public class Control {
    private final AtomicBoolean stopTheWorld = new AtomicBoolean();
    private final BooleanSupplier keepGoing;
    private final Log log;
    private final long totalDurationMinutes;
    private Throwable failure;

    public Control(Config config) {
        this.log = config.logProvider().getLog(this.getClass());
        long workDurationMinutes = config.workDurationMinutes();
        this.totalDurationMinutes = workDurationMinutes + (long)config.shutdownDurationMinutes();
        BooleanSupplier notExpired = Suppliers.untilTimeExpired((long)workDurationMinutes, (TimeUnit)TimeUnit.MINUTES);
        this.keepGoing = () -> !this.stopTheWorld.get() && notExpired.getAsBoolean();
    }

    public boolean keepGoing() {
        return this.keepGoing.getAsBoolean();
    }

    public synchronized void onFailure(Throwable cause) {
        if (this.failure == null) {
            this.failure = cause;
        } else {
            this.failure.addSuppressed(cause);
        }
        this.log.error("Failure occurred", cause);
        this.stopTheWorld.set(true);
    }

    public synchronized void assertNoFailure() {
        if (this.failure != null) {
            throw new RuntimeException("Test failed", this.failure);
        }
    }

    public void awaitEnd(Iterable<Future<?>> completions) throws InterruptedException, TimeoutException, ExecutionException {
        Futures.combine(completions).get(this.totalDurationMinutes, TimeUnit.MINUTES);
    }
}

