/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.stresstests;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.stresstests.Config;
import org.neo4j.causalclustering.stresstests.Control;
import org.neo4j.causalclustering.stresstests.Resources;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helper.Workload;
import org.neo4j.kernel.impl.util.CappedLogger;
import org.neo4j.logging.Log;
import org.neo4j.test.Randoms;

class CreateNodesWithProperties
extends Workload {
    private static final Label label = Label.label((String)"Label");
    private final Cluster cluster;
    private final CappedLogger txLogger;
    private final boolean enableIndexes;
    private long txSuccessCount;
    private long txFailCount;

    CreateNodesWithProperties(Control control, Resources resources, Config config) {
        super(control);
        this.enableIndexes = config.enableIndexes();
        this.cluster = resources.cluster();
        Log log = resources.logProvider().getLog(this.getClass());
        this.txLogger = new CappedLogger(log).setTimeLimit(5L, TimeUnit.SECONDS, resources.clock());
    }

    @Override
    public void prepare() {
        if (this.enableIndexes) {
            CreateNodesWithProperties.setupIndexes(this.cluster);
        }
    }

    @Override
    protected void doWork() {
        this.txLogger.info("SuccessCount: " + this.txSuccessCount + " FailCount: " + this.txFailCount);
        Randoms randoms = new Randoms();
        try {
            this.cluster.coreTx((db, tx) -> {
                Node node = db.createNode(new Label[]{label});
                for (int i = 1; i <= 8; ++i) {
                    node.setProperty(CreateNodesWithProperties.prop(i), randoms.propertyValue());
                }
                tx.success();
            });
        }
        catch (Throwable e) {
            ++this.txFailCount;
            if (this.isInterrupted(e) || this.isTransient(e)) {
                return;
            }
            throw new RuntimeException(e);
        }
        ++this.txSuccessCount;
    }

    private static void setupIndexes(Cluster cluster) {
        try {
            cluster.coreTx((db, tx) -> {
                for (int i = 1; i <= 8; ++i) {
                    db.schema().indexFor(label).on(CreateNodesWithProperties.prop(i)).create();
                }
                tx.success();
            });
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static String prop(int i) {
        return "prop" + i;
    }

    private boolean isTransient(Throwable e) {
        return e != null && (e instanceof TimeoutException || e instanceof DatabaseShutdownException || e instanceof TransactionFailureException || this.isInterrupted(e.getCause()));
    }

    private boolean isInterrupted(Throwable e) {
        if (e == null) {
            return false;
        }
        if (e instanceof InterruptedException) {
            Thread.interrupted();
            return true;
        }
        return this.isInterrupted(e.getCause());
    }
}

