/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.stresstests;

import java.io.File;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.ClusterMember;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.stresstests.Config;
import org.neo4j.causalclustering.stresstests.Control;
import org.neo4j.causalclustering.stresstests.Preparation;
import org.neo4j.causalclustering.stresstests.Resources;
import org.neo4j.causalclustering.stresstests.TxHelp;
import org.neo4j.causalclustering.stresstests.Validation;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.security.WriteOperationsNotAllowedException;
import org.neo4j.helper.Workload;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.id.IdContainer;
import org.neo4j.logging.Log;

class IdReuse {
    private static final RelationshipType RELATIONSHIP_TYPE = RelationshipType.withName((String)"testType");

    IdReuse() {
    }

    static class DeletionWorkload
    extends Workload {
        private final SecureRandom rnd = new SecureRandom();
        private final int idHighRange;
        private Cluster cluster;

        DeletionWorkload(Control control, Resources resources) {
            super(control);
            this.cluster = resources.cluster();
            this.idHighRange = 2000000;
        }

        @Override
        protected void doWork() {
            try {
                this.cluster.coreTx((db, tx) -> {
                    Node node = db.getNodeById((long)this.rnd.nextInt(this.idHighRange));
                    Iterables.stream((Iterable)node.getRelationships()).forEach(Relationship::delete);
                    node.delete();
                    tx.success();
                });
            }
            catch (NotFoundException notFoundException) {
            }
            catch (Throwable e) {
                if (TxHelp.isInterrupted(e) || TxHelp.isTransient(e)) {
                    return;
                }
                throw new RuntimeException("DeletionWorkload", e);
            }
        }
    }

    static class ReelectionWorkload
    extends Workload {
        private final long reelectIntervalSeconds;
        private final Log log;
        private Cluster cluster;

        ReelectionWorkload(Control control, Resources resources, Config config) {
            super(control);
            this.cluster = resources.cluster();
            this.reelectIntervalSeconds = config.reelectIntervalSeconds();
            this.log = config.logProvider().getLog(this.getClass());
        }

        @Override
        protected void doWork() {
            try {
                CoreClusterMember leader = this.cluster.awaitLeader();
                leader.shutdown();
                leader.start();
                this.log.info("Restarting leader");
                TimeUnit.SECONDS.sleep(this.reelectIntervalSeconds);
            }
            catch (Throwable e) {
                if (TxHelp.isInterrupted(e) || TxHelp.isTransient(e)) {
                    return;
                }
                throw new RuntimeException("ReelectionWorkload", e);
            }
        }
    }

    static class InsertionWorkload
    extends Workload {
        private Cluster cluster;

        InsertionWorkload(Control control, Resources resources) {
            super(control);
            this.cluster = resources.cluster();
        }

        @Override
        protected void doWork() {
            try {
                this.cluster.coreTx((db, tx) -> {
                    Node nodeStart = db.createNode();
                    Node nodeEnd = db.createNode();
                    nodeStart.createRelationshipTo(nodeEnd, RELATIONSHIP_TYPE);
                    tx.success();
                });
            }
            catch (Throwable e) {
                if (TxHelp.isInterrupted(e) || TxHelp.isTransient(e)) {
                    return;
                }
                throw new RuntimeException("InsertionWorkload", e);
            }
        }
    }

    static class IdReuseSetup
    extends Preparation {
        private final Cluster cluster;

        IdReuseSetup(Resources resources) {
            this.cluster = resources.cluster();
        }

        @Override
        protected void prepare() throws Exception {
            for (int i = 0; i < 1000; ++i) {
                try {
                    this.cluster.coreTx((db, tx) -> {
                        for (int j = 0; j < 1000; ++j) {
                            Node start = db.createNode();
                            Node end = db.createNode();
                            start.createRelationshipTo(end, RELATIONSHIP_TYPE);
                        }
                        tx.success();
                    });
                    continue;
                }
                catch (WriteOperationsNotAllowedException writeOperationsNotAllowedException) {
                    // empty catch block
                }
            }
        }
    }

    static class UniqueFreeIds
    extends Validation {
        private final Cluster cluster;
        private final FileSystemAbstraction fs;
        private final Log log;

        UniqueFreeIds(Resources resources) {
            this.cluster = resources.cluster();
            this.fs = resources.fileSystem();
            this.log = resources.logProvider().getLog(this.getClass());
        }

        @Override
        protected void validate() {
            Iterable members = Iterables.concat((Iterable[])new Iterable[]{this.cluster.coreMembers(), this.cluster.readReplicas()});
            HashSet unusedIds = new HashSet();
            HashSet nonUniqueIds = new HashSet();
            for (ClusterMember member : members) {
                this.visitAllIds(member, id -> {
                    if (!unusedIds.add(id)) {
                        nonUniqueIds.add(id);
                    }
                });
            }
            if (nonUniqueIds.size() != 0) {
                for (ClusterMember member : members) {
                    this.visitAllIds(member, id -> {
                        if (nonUniqueIds.contains(id)) {
                            this.log.error(member + " has non-unique free ID: " + id);
                        }
                    });
                }
                throw new IllegalStateException("Non-unique IDs found: " + nonUniqueIds);
            }
            this.log.info("Total of " + unusedIds.size() + " reusable ids found");
        }

        void visitAllIds(ClusterMember member, Consumer<Long> idConsumer) {
            String storeDir = member.storeDir().getAbsolutePath();
            File idFile = new File(storeDir, "neostore.nodestore.db.id");
            IdContainer idContainer = new IdContainer(this.fs, idFile, 1024, true);
            idContainer.init();
            this.log.info(idFile.getAbsolutePath() + " has " + idContainer.getFreeIdCount() + " free ids");
            long id = idContainer.getReusableId();
            while (id != -1L) {
                idConsumer.accept(id);
                id = idContainer.getReusableId();
            }
            idContainer.close(0L);
        }
    }
}

