/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.stresstests;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.backup.impl.OnlineBackupCommandBuilder;
import org.neo4j.backup.impl.SelectedBackupProtocol;
import org.neo4j.causalclustering.BackupUtil;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.ClusterMember;
import org.neo4j.causalclustering.discovery.CoreClusterMember;
import org.neo4j.causalclustering.stresstests.Control;
import org.neo4j.causalclustering.stresstests.RepeatOnRandomMember;
import org.neo4j.causalclustering.stresstests.Resources;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.io.NullOutputStream;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.Log;

class ReplaceRandomMember
extends RepeatOnRandomMember {
    private final Cluster cluster;
    private final File baseBackupDir;
    private final FileSystemAbstraction fs;
    private final Log log;
    private int backupNumber;

    ReplaceRandomMember(Control control, Resources resources) {
        super(control, resources);
        this.cluster = resources.cluster();
        this.baseBackupDir = resources.backupDir();
        this.fs = resources.fileSystem();
        this.log = resources.logProvider().getLog(this.getClass());
    }

    @Override
    protected void doWorkOnMember(ClusterMember oldMember) throws CommandFailed, IncorrectUsage, IOException {
        CoreClusterMember newMember;
        File backupDir = null;
        String backupName = null;
        boolean replaceFromBackup = ThreadLocalRandom.current().nextBoolean();
        if (replaceFromBackup) {
            backupName = "backup-" + this.backupNumber++;
            AdvertisedSocketAddress address = (AdvertisedSocketAddress)oldMember.config().get(CausalClusteringSettings.transaction_advertised_address);
            backupDir = new File(this.baseBackupDir, backupName);
            new OnlineBackupCommandBuilder().withOutput(NullOutputStream.NULL_OUTPUT_STREAM).withSelectedBackupStrategy(SelectedBackupProtocol.CATCHUP).withConsistencyCheck(Boolean.valueOf(false)).withHost(address.getHostname()).withPort(Integer.valueOf(address.getPort())).backup(this.baseBackupDir, backupName);
            this.log.info("Created backup: " + backupName + " from: " + oldMember);
        }
        this.log.info("Stopping: " + oldMember);
        oldMember.shutdown();
        Object object = newMember = oldMember instanceof CoreClusterMember ? this.cluster.newCoreMember() : this.cluster.newReadReplica();
        if (backupDir != null) {
            this.log.info("Restoring backup: " + backupName + " to: " + newMember);
            BackupUtil.restoreFromBackup((File)backupDir, (FileSystemAbstraction)this.fs, (ClusterMember)newMember);
        }
        this.log.info("Starting: " + newMember);
        newMember.start();
    }
}

