/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.stresstests;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Clock;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.causalclustering.discovery.Cluster;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.HazelcastDiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.IpFamily;
import org.neo4j.causalclustering.stresstests.ClusterConfiguration;
import org.neo4j.causalclustering.stresstests.Config;
import org.neo4j.helper.DatabaseConfiguration;
import org.neo4j.helper.StressTestingHelper;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;

class Resources {
    private final Cluster cluster;
    private final File clusterDir;
    private final File backupDir;
    private final FileSystemAbstraction fileSystem;
    private final PageCache pageCache;
    private final LogProvider logProvider;

    Resources(FileSystemAbstraction fileSystem, PageCache pageCache, Config config) throws IOException {
        this(fileSystem, pageCache, (LogProvider)FormattedLogProvider.toOutputStream((OutputStream)System.out), config);
    }

    private Resources(FileSystemAbstraction fileSystem, PageCache pageCache, LogProvider logProvider, Config config) throws IOException {
        this.fileSystem = fileSystem;
        this.pageCache = pageCache;
        this.logProvider = logProvider;
        int numberOfCores = config.numberOfCores();
        int numberOfEdges = config.numberOfEdges();
        String workingDirectory = config.workingDir();
        String txPrune = config.txPrune();
        this.clusterDir = StressTestingHelper.ensureExistsAndEmpty(new File(workingDirectory, "cluster"));
        this.backupDir = StressTestingHelper.ensureExistsAndEmpty(new File(workingDirectory, "backups"));
        Map<String, String> coreParams = ClusterConfiguration.enableRaftMessageLogging(ClusterConfiguration.configureRaftLogRotationAndPruning(DatabaseConfiguration.configureTxLogRotationAndPruning(new HashMap<String, String>(), txPrune)));
        Map<String, String> readReplicaParams = DatabaseConfiguration.configureTxLogRotationAndPruning(new HashMap<String, String>(), txPrune);
        HazelcastDiscoveryServiceFactory discoveryServiceFactory = new HazelcastDiscoveryServiceFactory();
        this.cluster = new Cluster(this.clusterDir, numberOfCores, numberOfEdges, (DiscoveryServiceFactory)discoveryServiceFactory, coreParams, Collections.emptyMap(), readReplicaParams, Collections.emptyMap(), "standard", IpFamily.IPV4, false);
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public FileSystemAbstraction fileSystem() {
        return this.fileSystem;
    }

    public LogProvider logProvider() {
        return this.logProvider;
    }

    public File backupDir() {
        return this.backupDir;
    }

    public PageCache pageCache() {
        return this.pageCache;
    }

    public void start() throws Exception {
        this.cluster.start();
    }

    public void stop() {
        this.cluster.shutdown();
    }

    public void cleanup() throws IOException {
        FileUtils.deleteRecursively((File)this.clusterDir);
        FileUtils.deleteRecursively((File)this.backupDir);
    }

    public Clock clock() {
        return Clock.systemUTC();
    }
}

